package com.zurrtum.create.content.processing.recipe;

import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2371;

public class ProcessingInventory implements class_1278 {
    private static final int[] INPUT_SLOTS = {0};
    private static final int[] ALL_SLOTS = SlotRangeCache.get(32);
    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    private static final Optional<Integer> LIMIT = Optional.of(1);
    public float remainingTime;
    public float recipeDuration;
    public boolean appliedRecipe;
    private boolean limit;
    private byte outputFlag = 0;
    private final Predicate<class_2350> canInsert;
    private final Consumer<class_1799> callback;
    private final class_2371<class_1799> stacks;

    public ProcessingInventory(Consumer<class_1799> callback, Predicate<class_2350> canInsert) {
        this.stacks = class_2371.method_10213(32, class_1799.field_8037);
        this.canInsert = canInsert;
        this.callback = callback;
    }

    public void outputAllowInsertion() {
        outputFlag = (byte) (limit ? 1 : 2);
        limit = false;
    }

    public void outputForbidInsertion() {
        limit = outputFlag == 1;
        outputFlag = 0;
    }

    @Override
    public int method_5439() {
        return 32;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return outputFlag == 0 ? INPUT_SLOTS : ALL_SLOTS;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (outputFlag == 0) {
            return slot == 0 && canInsert.test(dir);
        }
        return slot != 0;
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        if (outputFlag == 0) {
            return method_5442();
        }
        return true;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    @Override
    public class_1799 onExtract(class_1799 stack) {
        if (limit) {
            return removeMaxSize(stack, LIMIT);
        }
        return stack;
    }

    @Override
    public class_1799 method_5438(int slot) {
        if (slot >= 32) {
            return class_1799.field_8037;
        }
        return stacks.get(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        if (slot >= 32) {
            return;
        }
        if (limit && stack != class_1799.field_8037) {
            setMaxSize(stack, LIMIT);
        }
        stacks.set(slot, stack);
        if (slot == 0 && !stack.method_7960()) {
            callback.accept(stack);
        }
    }

    public ProcessingInventory withSlotLimit(boolean limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public int method_5444() {
        return limit ? 1 : class_1278.super.method_5444();
    }

    @Override
    public void method_5448() {
        remainingTime = 0;
        recipeDuration = 0;
        appliedRecipe = false;
        class_1278.super.method_5448();
    }

    public void write(class_11372 view) {
        class_11372.class_11373<class_1799> list = view.method_71467("Inventory", class_1799.field_49266);
        list.method_71484(stacks.getFirst());
        for (int i = 1; i < stacks.size(); i++) {
            class_1799 stack = stacks.get(i);
            if (stack.method_7960()) {
                continue;
            }
            list.method_71484(stack);
        }
        view.method_71464("ProcessingTime", remainingTime);
        view.method_71464("RecipeTime", recipeDuration);
        view.method_71472("AppliedRecipe", appliedRecipe);
    }

    public void read(class_11368 view) {
        class_11368.class_11369<class_1799> list = view.method_71437("Inventory", class_1799.field_49266);
        int i = 0;
        for (class_1799 itemStack : list) {
            stacks.set(i++, itemStack);
        }
        for (int size = stacks.size(); i < size; i++) {
            stacks.set(i, class_1799.field_8037);
        }
        remainingTime = view.method_71423("ProcessingTime", 0);
        recipeDuration = view.method_71423("RecipeTime", 0);
        appliedRecipe = view.method_71433("AppliedRecipe", false);
        if (appliedRecipe && method_5442())
            appliedRecipe = false;
    }
}
