package com.zurrtum.create.content.redstone.displayLink;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.redstone.displayLink.source.RedstonePowerDisplaySource;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_10;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_9904;

public class DisplayLinkBlock extends WrenchableDirectionalBlock implements IBE<DisplayLinkBlockEntity>, NeighborUpdateListeningBlock {

    public static final class_2746 POWERED = class_2741.field_12484;

    public static final MapCodec<DisplayLinkBlock> field_46280 = method_54094(DisplayLinkBlock::new);

    public DisplayLinkBlock(class_2251 p_i48415_1_) {
        super(p_i48415_1_);
        method_9590(method_9564().method_11657(POWERED, false));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 placed = super.method_9605(context);
        placed = placed.method_11657(field_10927, context.method_8038());
        return placed.method_11657(POWERED, shouldBePowered(placed, context.method_8045(), context.method_8037()));
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public static void notifyGatherers(class_1936 level, class_2338 pos) {
        forEachAttachedGatherer(level, pos, DisplayLinkBlockEntity::tickSource);
    }

    @SuppressWarnings("unchecked")
    public static <T extends DisplaySource> void sendToGatherers(
        class_1936 level,
        class_2338 pos,
        BiConsumer<DisplayLinkBlockEntity, T> callback,
        Class<T> type
    ) {
        forEachAttachedGatherer(
            level, pos, dgte -> {
                if (type.isInstance(dgte.activeSource))
                    callback.accept(dgte, (T) dgte.activeSource);
            }
        );
    }

    private static void forEachAttachedGatherer(class_1936 level, class_2338 pos, Consumer<DisplayLinkBlockEntity> callback) {
        for (class_2350 d : Iterate.directions) {
            class_2338 offsetPos = pos.method_10093(d);
            class_2680 blockState = level.method_8320(offsetPos);
            if (!blockState.method_27852(AllBlocks.DISPLAY_LINK))
                continue;

            class_2586 blockEntity = level.method_8321(offsetPos);
            if (!(blockEntity instanceof DisplayLinkBlockEntity dlbe))
                continue;
            if (dlbe.activeSource == null)
                continue;
            if (dlbe.getDirection() != d.method_10153())
                continue;

            callback.accept(dlbe);
        }
    }

    @Override
    public void neighborUpdate(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        if (worldIn.field_9236)
            return;
        if (fromPos.equals(pos.method_10093(state.method_11654(field_10927).method_10153())))
            sendToGatherers(worldIn, fromPos, (dlte, p) -> dlte.tickSource(), RedstonePowerDisplaySource.class);
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 worldIn,
        class_2338 pos,
        class_2248 blockIn,
        @Nullable class_9904 wireOrientation,
        boolean isMoving
    ) {
        if (worldIn.field_9236)
            return;

        boolean powered = shouldBePowered(state, worldIn, pos);
        boolean previouslyPowered = state.method_11654(POWERED);
        if (previouslyPowered != powered) {
            worldIn.method_8652(pos, state.method_28493(POWERED), class_2248.field_31028);
            if (!powered)
                withBlockEntityDo(worldIn, pos, DisplayLinkBlockEntity::onNoLongerPowered);
        }
    }

    private boolean shouldBePowered(class_2680 state, class_1937 worldIn, class_2338 pos) {
        boolean powered = false;
        for (class_2350 d : Iterate.directions) {
            if (d.method_10153() == state.method_11654(field_10927))
                continue;
            if (worldIn.method_49808(pos.method_10093(d), d) == 0)
                continue;
            powered = true;
            break;
        }
        return powered;
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(POWERED));
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        if (player == null)
            return class_1269.field_5811;
        if (player.method_5715())
            return class_1269.field_5811;
        if (level.field_9236) {
            withBlockEntityDo(level, pos, be -> AllClientHandle.INSTANCE.openDisplayLinkScreen(be, player));
        }
        return class_1269.field_5812;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.DATA_GATHERER.get(pState.method_11654(field_10927));
    }

    @Override
    public Class<DisplayLinkBlockEntity> getBlockEntityClass() {
        return DisplayLinkBlockEntity.class;
    }

    @Override
    public class_2591<? extends DisplayLinkBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.DISPLAY_LINK;
    }

    @Override
    protected @NotNull MapCodec<? extends class_2318> method_53969() {
        return field_46280;
    }
}
