package com.zurrtum.create.content.redstone.displayLink.source;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_3218;
import net.minecraft.class_5250;

public class ScoreboardDisplaySource extends ValueListDisplaySource {

    @Override
    protected Stream<IntAttached<class_5250>> provideEntries(DisplayLinkContext context, int maxRows) {
        class_1937 level = context.blockEntity().method_10997();
        if (!(level instanceof class_3218 sLevel))
            return Stream.empty();

        String name = context.sourceConfig().method_68564("Objective", "");

        return showScoreboard(sLevel, name, maxRows);
    }

    protected Stream<IntAttached<class_5250>> showScoreboard(class_3218 sLevel, String objectiveName, int maxRows) {
        class_266 objective = sLevel.method_14170().method_1170(objectiveName);
        if (objective == null)
            return notFound(objectiveName).stream();

        return sLevel.method_14170().method_1184(objective).stream()
            .map(score -> IntAttached.with(score.comp_2128(), class_2561.method_43470(score.comp_2127()).method_27661())).sorted(IntAttached.comparator()).limit(maxRows);
    }

    private ImmutableList<IntAttached<class_5250>> notFound(String objective) {
        return ImmutableList.of(IntAttached.with(404, class_2561.method_43469("create.display_source.scoreboard.objective_not_found", objective)));
    }

    @Override
    protected String getTranslationKey() {
        return "scoreboard";
    }

    @Override
    protected boolean valueFirst() {
        return false;
    }

}