package com.zurrtum.create.content.redstone.displayLink.target;

import com.zurrtum.create.api.behaviour.display.DisplayHolder;
import com.zurrtum.create.api.behaviour.display.DisplayTarget;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_5250;
import net.minecraft.class_8242;

public class SignDisplayTarget extends DisplayTarget {

    @Override
    public void acceptText(int line, List<class_5250> text, DisplayLinkContext context) {
        class_2586 be = context.getTargetBlockEntity();
        if (!(be instanceof class_2625 sign))
            return;

        boolean changed = false;
        Couple<class_8242> signText = Couple.createWithContext(sign::method_49843);
        DisplayHolder holder = (DisplayHolder) sign;
        for (int i = 0; i < text.size() && i + line < 4; i++) {
            if (i == 0)
                reserve(i + line, holder, context);
            if (i > 0 && isReserved(i + line, holder, context))
                break;

            final int iFinal = i;
            String content = text.get(iFinal).method_10858(sign.method_45470());
            signText = signText.map(st -> st.method_49857(iFinal + line, class_2561.method_43470(content)));
            changed = true;
        }

        if (changed) {
            signText.forEachWithContext(sign::method_49840);
            context.level().method_8413(context.getTargetPos(), sign.method_11010(), sign.method_11010(), 2);
        }
    }

    @Override
    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        return new DisplayTargetStats(4, 15, this);
    }

    @Override
    public boolean requiresComponentSanitization() {
        return true;
    }

}
