package com.zurrtum.create.content.trains.track;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class TrackBlockEntityTilt {
    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    public Optional<Double> smoothingAngle;
    private Couple<Pair<class_243, Integer>> previousSmoothingHandles;

    private final TrackBlockEntity blockEntity;

    public TrackBlockEntityTilt(TrackBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        smoothingAngle = Optional.empty();
    }

    public void tryApplySmoothing() {
        if (smoothingAngle.isPresent())
            return;

        Couple<BezierConnection> discoveredSlopes = Couple.create(null, null);
        class_243 axis = null;

        class_2680 blockState = blockEntity.method_11010();
        class_2338 worldPosition = blockEntity.method_11016();
        class_1937 level = blockEntity.method_10997();

        if (!(blockState.method_26204() instanceof ITrackBlock itb))
            return;
        List<class_243> axes = itb.getTrackAxes(level, worldPosition, blockState);
        if (axes.size() != 1)
            return;
        if (axes.getFirst().field_1351 != 0)
            return;
        if (blockEntity.boundLocation != null)
            return;

        for (BezierConnection bezierConnection : blockEntity.connections.values()) {
            if (bezierConnection.starts.getFirst().field_1351 == bezierConnection.starts.getSecond().field_1351)
                continue;
            class_243 normedAxis = bezierConnection.axes.getFirst().method_1029();

            if (axis != null) {
                if (discoveredSlopes.getSecond() != null)
                    return;
                if (normedAxis.method_1026(axis) > -1 + 1 / 64.0)
                    return;
                discoveredSlopes.setSecond(bezierConnection);
                continue;
            }

            axis = normedAxis;
            discoveredSlopes.setFirst(bezierConnection);
        }

        if (discoveredSlopes.either(Objects::isNull))
            return;
        if (discoveredSlopes.getFirst().starts.getSecond().field_1351 > discoveredSlopes.getSecond().starts.getSecond().field_1351)
            discoveredSlopes = discoveredSlopes.swap();

        Couple<class_243> lowStarts = discoveredSlopes.getFirst().starts;
        Couple<class_243> highStarts = discoveredSlopes.getSecond().starts;
        class_243 lowestPoint = lowStarts.getSecond();
        class_243 highestPoint = highStarts.getSecond();

        if (lowestPoint.field_1351 > lowStarts.getFirst().field_1351)
            return;
        if (highestPoint.field_1351 < highStarts.getFirst().field_1351)
            return;

        blockEntity.removeInboundConnections(false);
        blockEntity.connections.clear();
        TrackPropagator.onRailRemoved(level, worldPosition, blockState);

        double hDistance = discoveredSlopes.getFirst().getLength() + discoveredSlopes.getSecond().getLength();
        class_243 baseAxis = discoveredSlopes.getFirst().axes.getFirst();
        double baseAxisLength = baseAxis.field_1352 != 0 && baseAxis.field_1350 != 0 ? Math.sqrt(2) : 1;
        double vDistance = highestPoint.field_1351 - lowestPoint.field_1351;
        double m = vDistance / (hDistance);

        class_243 diff = highStarts.getFirst().method_1020(lowStarts.getFirst());
        boolean flipRotation = diff.method_1026(new class_243(1, 0, 2).method_1029()) <= 0;
        smoothingAngle = Optional.of(Math.toDegrees(class_3532.method_15349(m, 1)) * (flipRotation ? -1 : 1));

        int smoothingParam = class_3532.method_15340((int) (m * baseAxisLength * 16), 0, 15);

        Couple<Integer> smoothingResult = Couple.create(0, smoothingParam);
        class_243 raisedOffset = diff.method_1029().method_1031(0, class_3532.method_15350(m, 0, 1 - 1 / 512.0), 0).method_1029().method_1021(baseAxisLength);

        highStarts.setFirst(lowStarts.getFirst().method_1019(raisedOffset));

        boolean first = true;
        for (BezierConnection bezierConnection : discoveredSlopes) {
            int smoothingToApply = smoothingResult.get(first);

            if (bezierConnection.smoothing == null)
                bezierConnection.smoothing = Couple.create(0, 0);
            bezierConnection.smoothing.setFirst(smoothingToApply);
            bezierConnection.axes.setFirst(bezierConnection.axes.getFirst().method_1031(0, (first ? 1 : -1) * -m, 0).method_1029());

            first = false;
            class_2338 otherPosition = bezierConnection.getKey();
            class_2680 otherState = level.method_8320(otherPosition);
            if (!(otherState.method_26204() instanceof TrackBlock))
                continue;
            level.method_8501(otherPosition, otherState.method_11657(TrackBlock.HAS_BE, true));
            class_2586 otherBE = level.method_8321(otherPosition);
            if (otherBE instanceof TrackBlockEntity tbe) {
                blockEntity.addConnection(bezierConnection);
                tbe.addConnection(bezierConnection.secondary());
            }
        }
    }

    public void captureSmoothingHandles() {
        boolean first = true;
        previousSmoothingHandles = Couple.create(null, null);
        for (BezierConnection bezierConnection : blockEntity.connections.values()) {
            previousSmoothingHandles.set(
                first,
                Pair.of(bezierConnection.starts.getFirst(), bezierConnection.smoothing == null ? 0 : bezierConnection.smoothing.getFirst())
            );
            first = false;
        }
    }

    public void undoSmoothing() {
        if (smoothingAngle.isEmpty())
            return;
        if (previousSmoothingHandles == null)
            return;
        if (blockEntity.connections.size() == 2)
            return;

        class_2680 blockState = blockEntity.method_11010();
        class_2338 worldPosition = blockEntity.method_11016();
        class_1937 level = blockEntity.method_10997();

        List<BezierConnection> validConnections = new ArrayList<>();
        for (BezierConnection bezierConnection : blockEntity.connections.values()) {
            class_2338 otherPosition = bezierConnection.getKey();
            class_2586 otherBE = level.method_8321(otherPosition);
            if (otherBE instanceof TrackBlockEntity tbe && tbe.connections.containsKey(worldPosition))
                validConnections.add(bezierConnection);
        }

        blockEntity.removeInboundConnections(false);
        TrackPropagator.onRailRemoved(level, worldPosition, blockState);
        blockEntity.connections.clear();
        smoothingAngle = Optional.empty();

        for (BezierConnection bezierConnection : validConnections) {
            blockEntity.addConnection(restoreToOriginalCurve(bezierConnection));

            class_2338 otherPosition = bezierConnection.getKey();
            class_2680 otherState = level.method_8320(otherPosition);
            if (!(otherState.method_26204() instanceof TrackBlock))
                continue;
            level.method_8501(otherPosition, otherState.method_11657(TrackBlock.HAS_BE, true));
            class_2586 otherBE = level.method_8321(otherPosition);
            if (otherBE instanceof TrackBlockEntity tbe)
                tbe.addConnection(bezierConnection.secondary());
        }

        blockEntity.notifyUpdate();
        previousSmoothingHandles = null;
        TrackPropagator.onRailAdded(level, worldPosition, blockState);
    }

    public BezierConnection restoreToOriginalCurve(BezierConnection bezierConnection) {
        if (bezierConnection.smoothing != null) {
            bezierConnection.smoothing.setFirst(0);
            if (bezierConnection.smoothing.getFirst() == 0 && bezierConnection.smoothing.getSecond() == 0)
                bezierConnection.smoothing = null;
        }
        class_243 raisedStart = bezierConnection.starts.getFirst();
        bezierConnection.starts.setFirst(new TrackNodeLocation(raisedStart).getLocation());
        bezierConnection.axes.setFirst(bezierConnection.axes.getFirst().method_18805(1, 0, 1).method_1029());
        return bezierConnection;
    }

    public int getYOffsetForAxisEnd(class_243 end) {
        if (smoothingAngle.isEmpty())
            return 0;
        for (BezierConnection bezierConnection : blockEntity.connections.values())
            if (compareHandles(bezierConnection.starts.getFirst(), end))
                return bezierConnection.yOffsetAt(end);
        if (previousSmoothingHandles == null)
            return 0;
        for (Pair<class_243, Integer> handle : previousSmoothingHandles)
            if (handle != null && compareHandles(handle.getFirst(), end))
                return handle.getSecond();
        return 0;
    }

    public static boolean compareHandles(class_243 handle1, class_243 handle2) {
        return new TrackNodeLocation(handle1).getLocation().method_18805(1, 0, 1)
            .method_1025(new TrackNodeLocation(handle2).getLocation().method_18805(1, 0, 1)) < 1 / 512f;
    }

}
