package com.zurrtum.create.foundation.recipe;

import com.zurrtum.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3545;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

public class RecipeApplier {
    public static <T extends class_9695> void applyCreateRecipeOn(class_1542 entity, T input, CreateRecipe<T> recipe) {
        class_1937 world = entity.method_37908();
        List<class_1799> stacks = applyCreateRecipeOn(entity.method_37908(), entity.method_6983().method_7947(), input, recipe);
        int size = stacks.size();
        if (size == 0) {
            entity.method_31472();
            return;
        }
        entity.method_6979(stacks.getFirst());
        if (size == 1) {
            return;
        }
        double x = entity.method_23317();
        double y = entity.method_23318();
        double z = entity.method_23321();
        class_243 velocity = entity.method_18798();
        for (int i = 1; i < size; i++) {
            class_1542 entityIn = new class_1542(world, x, y, z, stacks.get(i));
            entityIn.method_18799(velocity);
            world.method_8649(entityIn);
        }
    }

    public static <T extends class_9695> List<class_1799> applyCreateRecipeOn(class_1937 world, int count, T input, CreateRecipe<T> recipe) {
        if (recipe.isRollable()) {
            List<class_1799> stacks = new ArrayList<>();
            HashMap<class_1799, class_3545<class_1799, Integer>> buffer = new HashMap<>();
            class_1799 exist;
            for (int i = 0, amount, max; i < count; i++) {
                for (class_1799 stack : recipe.craft(input, world.field_9229)) {
                    class_3545<class_1799, Integer> item = buffer.get(stack);
                    if (item == null) {
                        buffer.put(stack, new class_3545<>(stack, stack.method_7914()));
                    } else {
                        max = item.method_15441();
                        exist = item.method_15442();
                        amount = stack.method_7947() + exist.method_7947();
                        if (amount >= max) {
                            exist.method_7939(amount - max);
                            stack.method_7939(max);
                            stacks.add(stack);
                        } else {
                            exist.method_7939(amount);
                        }
                    }
                }
            }
            buffer.values().stream().map(class_3545::method_15442).filter(stack -> !stack.method_7960()).forEach(stacks::add);
            return stacks;
        } else {
            return ItemHelper.multipliedOutput(recipe.craft(input, world.field_9229), count);
        }
    }

    public static <T extends class_9695> List<class_1799> applyRecipeOn(class_1937 level, int count, T input, class_8786<? extends class_1860<T>> entry) {
        class_1860<T> recipe = entry.comp_1933();
        if (recipe instanceof CreateRecipe<T> createRecipe) {
            return applyCreateRecipeOn(level, count, input, createRecipe);
        } else {
            return applyRecipeOn(level, count, input, recipe);
        }
    }

    public static <T extends class_9695> List<class_1799> applyRecipeOn(class_1937 level, int count, T input, class_1860<T> recipe) {
        return ItemHelper.multipliedOutput(recipe.method_8116(input, level.method_30349()), count);
    }
}
