package com.zurrtum.create.infrastructure.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ClipboardEntry {
    public static final Codec<ClipboardEntry> CODEC = RecordCodecBuilder.create(i -> i.group(
        Codec.BOOL.fieldOf("checked").forGetter(c -> c.checked),
        class_8824.field_46597.fieldOf("text").forGetter(c -> c.text),
        class_1799.field_49266.fieldOf("icon").forGetter(c -> c.icon),
        Codec.INT.fieldOf("item_amount").forGetter(c -> c.itemAmount)
    ).apply(
        i, (checked, text, icon, itemAmount) -> {
            ClipboardEntry entry = new ClipboardEntry(checked, text.method_27661());
            if (!icon.method_7960())
                entry.displayItem(icon, itemAmount);

            return entry;
        }
    ));

    public static final class_9139<class_9129, ClipboardEntry> STREAM_CODEC = class_9139.method_56905(
        class_9135.field_48547,
        c -> c.checked,
        class_8824.field_49668,
        c -> c.text,
        class_1799.field_49268,
        c -> c.icon,
        class_9135.field_49675,
        c -> c.itemAmount,
        (checked, text, icon, itemAmount) -> {
            ClipboardEntry entry = new ClipboardEntry(checked, text.method_27661());
            if (!icon.method_7960())
                entry.displayItem(icon, itemAmount);

            return entry;
        }
    );

    public boolean checked;
    public class_5250 text;
    public class_1799 icon;
    public int itemAmount;

    public ClipboardEntry(boolean checked, class_5250 text) {
        this.checked = checked;
        this.text = text;
        this.icon = class_1799.field_8037;
    }

    public ClipboardEntry displayItem(class_1799 icon, int amount) {
        this.icon = icon;
        this.itemAmount = amount;
        return this;
    }

    public static List<List<ClipboardEntry>> readAll(class_1799 clipboardItem) {
        List<List<ClipboardEntry>> entries = new ArrayList<>();

        // Both these lists are immutable, so we unfortunately need to re-create them to make them mutable
        List<List<ClipboardEntry>> saved = clipboardItem.method_58695(AllDataComponents.CLIPBOARD_PAGES, Collections.emptyList());
        for (List<ClipboardEntry> inner : saved)
            entries.add(new ArrayList<>(inner));

        return entries;
    }

    public static List<ClipboardEntry> getLastViewedEntries(class_1799 heldItem) {
        List<List<ClipboardEntry>> pages = ClipboardEntry.readAll(heldItem);
        if (pages.isEmpty())
            return new ArrayList<>();
        int page = !heldItem.method_57826(AllDataComponents.CLIPBOARD_PREVIOUSLY_OPENED_PAGE) ? 0 : Math.min(
            heldItem.method_58695(
                AllDataComponents.CLIPBOARD_PREVIOUSLY_OPENED_PAGE,
                0
            ), pages.size() - 1
        );
        List<ClipboardEntry> entries = pages.get(page);
        return entries;
    }

    public static void saveAll(List<List<ClipboardEntry>> entries, class_1799 clipboardItem) {
        clipboardItem.method_57379(AllDataComponents.CLIPBOARD_PAGES, entries);
    }

    public class_2487 writeNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10556("Checked", checked);
        nbt.method_67494("Text", class_8824.field_46597, text);
        if (icon.method_7960())
            return nbt;
        nbt.method_67494("Icon", class_1799.field_24671, icon);
        nbt.method_10569("ItemAmount", itemAmount);
        return nbt;
    }

    public static ClipboardEntry readNBT(class_2487 tag) {
        ClipboardEntry clipboardEntry = new ClipboardEntry(
            tag.method_68566("Checked", false),
            tag.method_67491("Text", class_8824.field_46597).orElse(class_5244.field_39003).method_27661()
        );
        if (tag.method_10545("Icon"))
            clipboardEntry.displayItem(tag.method_67491("Icon", class_1799.field_24671).orElse(class_1799.field_8037), tag.method_68083("ItemAmount", 0));
        return clipboardEntry;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o)
            return true;
        if (!(o instanceof ClipboardEntry that))
            return false;

        return checked == that.checked && text.equals(that.text) && class_1799.method_31577(icon, that.icon);
    }

    @Override
    public int hashCode() {
        int result = Boolean.hashCode(checked);
        result = 31 * result + text.hashCode();
        result = 31 * result + class_1799.method_57355(icon);
        return result;
    }
}
