/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.TranslatingContraption;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.foundation.collision.ContinuousOBBCollider;
import com.zurrtum.create.foundation.collision.Matrix3d;
import com.zurrtum.create.foundation.collision.OrientedBB;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1311;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

public class ContraptionCollider {
    static void collideEntities(AbstractContraptionEntity contraptionEntity) {
        class_1937 world = contraptionEntity.method_73183();
        Contraption contraption = contraptionEntity.getContraption();
        class_238 bounds = contraptionEntity.method_5829();
        if (contraption == null) {
            return;
        }
        if (bounds == null) {
            return;
        }
        class_243 contraptionPosition = contraptionEntity.method_73189();
        class_243 contraptionMotion = contraptionPosition.method_1020(contraptionEntity.getPrevPositionVec());
        class_243 anchorVec = contraptionEntity.getAnchorVec();
        AbstractContraptionEntity.ContraptionRotationState rotation = null;
        List entitiesWithinAABB = world.method_8390(class_1297.class, bounds.method_1014(2.0).method_1012(0.0, 32.0, 0.0), contraptionEntity::method_30949);
        for (class_1297 entity : entitiesWithinAABB) {
            double idealVerticalMotion;
            boolean anyCollision;
            class_243 entityMotion;
            if (!entity.method_5805()) continue;
            PlayerType playerType = ContraptionCollider.getPlayerType(entity);
            entity.method_24204().forEach(e -> {
                if (e instanceof class_3222) {
                    class_3222 playerEntity = (class_3222)e;
                    playerEntity.field_13987.field_14138 = 0;
                }
            });
            if (playerType == PlayerType.SERVER) continue;
            if (rotation == null) {
                rotation = contraptionEntity.getRotationState();
            }
            Matrix3d rotationMatrix = rotation.asMatrix();
            class_243 entityPosition = entity.method_73189();
            class_238 entityBounds = entity.method_5829();
            class_243 motion = entity.method_18798();
            float yawOffset = rotation.getYawOffset();
            class_243 position = ContraptionCollider.getWorldToLocalTranslation(entity, anchorVec, rotationMatrix, yawOffset);
            motion = motion.method_1020(contraptionMotion);
            motion = rotationMatrix.transform(motion);
            class_238 localBB = entityBounds.method_997(position).method_1014(1.0E-7);
            OrientedBB obb = new OrientedBB(localBB);
            obb.setRotation(rotationMatrix);
            class_243 motionCopy = motion;
            List collidableBBs = contraption.getSimplifiedEntityColliders().orElseGet(() -> {
                ArrayList bbs = new ArrayList();
                List<class_265> potentialHits = ContraptionCollider.getPotentiallyCollidedShapes(world, contraption, localBB.method_18804(motionCopy));
                potentialHits.forEach(shape -> bbs.addAll(shape.method_1090()));
                return bbs;
            });
            MutableObject collisionResponse = new MutableObject((Object)class_243.field_1353);
            MutableObject normal = new MutableObject((Object)class_243.field_1353);
            MutableObject location = new MutableObject((Object)class_243.field_1353);
            MutableBoolean surfaceCollision = new MutableBoolean(false);
            MutableFloat temporalResponse = new MutableFloat(1.0f);
            class_243 obbCenter = obb.getCenter();
            boolean doHorizontalPass = !rotation.hasVerticalRotation();
            for (boolean horizontalPass : Iterate.trueAndFalse) {
                boolean noVerticalCollision;
                boolean verticalPass = !horizontalPass || !doHorizontalPass;
                for (class_238 bb : collidableBBs) {
                    boolean nearest;
                    class_243 separation;
                    double timeOfImpact;
                    class_243 currentResponse = (class_243)collisionResponse.getValue();
                    class_243 currentCenter = obbCenter.method_1019(currentResponse);
                    if (Math.abs(currentCenter.field_1352 - bb.method_1005().field_1352) - entityBounds.method_17939() - 1.0 > bb.method_17939() / 2.0 || Math.abs(currentCenter.field_1351 + motion.field_1351 - bb.method_1005().field_1351) - entityBounds.method_17940() - 1.0 > bb.method_17940() / 2.0 || Math.abs(currentCenter.field_1350 - bb.method_1005().field_1350) - entityBounds.method_17941() - 1.0 > bb.method_17941() / 2.0) continue;
                    obb.setCenter(currentCenter);
                    ContinuousOBBCollider.ContinuousSeparationManifold intersect = obb.intersect(bb, motion);
                    if (intersect == null) continue;
                    if (verticalPass && surfaceCollision.isFalse()) {
                        surfaceCollision.setValue(intersect.isSurfaceCollision());
                    }
                    boolean isTemporal = (timeOfImpact = intersect.getTimeOfImpact()) > 0.0 && timeOfImpact < 1.0;
                    class_243 collidingNormal = intersect.getCollisionNormal();
                    class_243 collisionPosition = intersect.getCollisionPosition();
                    if (!isTemporal && (separation = intersect.asSeparationVec(entity.method_49476())) != null && !separation.equals((Object)class_243.field_1353)) {
                        collisionResponse.setValue((Object)currentResponse.method_1019(separation));
                        timeOfImpact = 0.0;
                    }
                    boolean bl = nearest = timeOfImpact >= 0.0 && (double)temporalResponse.getValue().floatValue() > timeOfImpact;
                    if (collidingNormal != null && nearest) {
                        normal.setValue((Object)collidingNormal);
                    }
                    if (collisionPosition != null && nearest) {
                        location.setValue((Object)collisionPosition);
                    }
                    if (!isTemporal || !((double)temporalResponse.getValue().floatValue() > timeOfImpact)) continue;
                    temporalResponse.setValue((Number)timeOfImpact);
                }
                if (verticalPass) break;
                boolean noVerticalMotionResponse = temporalResponse.getValue().floatValue() == 1.0f;
                boolean bl = noVerticalCollision = ((class_243)collisionResponse.getValue()).field_1351 == 0.0;
                if (noVerticalCollision && noVerticalMotionResponse) break;
                collisionResponse.setValue((Object)((class_243)collisionResponse.getValue()).method_18805(1.0078125, 0.0, 1.0078125));
            }
            class_243 entityMotionNoTemporal = entityMotion = entity.method_18798();
            class_243 collisionNormal = (class_243)normal.getValue();
            class_243 collisionLocation = (class_243)location.getValue();
            class_243 totalResponse = (class_243)collisionResponse.getValue();
            boolean hardCollision = !totalResponse.equals((Object)class_243.field_1353);
            boolean temporalCollision = temporalResponse.getValue().floatValue() != 1.0f;
            class_243 motionResponse = !temporalCollision ? motion : motion.method_1029().method_1021(motion.method_1033() * (double)temporalResponse.getValue().floatValue());
            rotationMatrix.transpose();
            motionResponse = rotationMatrix.transform(motionResponse).method_1019(contraptionMotion);
            totalResponse = rotationMatrix.transform(totalResponse);
            totalResponse = VecHelper.rotate(totalResponse, yawOffset, class_2350.class_2351.field_11052);
            collisionNormal = rotationMatrix.transform(collisionNormal);
            collisionNormal = VecHelper.rotate(collisionNormal, yawOffset, class_2350.class_2351.field_11052);
            collisionNormal = collisionNormal.method_1029();
            collisionLocation = rotationMatrix.transform(collisionLocation);
            collisionLocation = VecHelper.rotate(collisionLocation, yawOffset, class_2350.class_2351.field_11052);
            rotationMatrix.transpose();
            double bounce = 0.0;
            double slide = 0.0;
            if (!collisionLocation.equals((Object)class_243.field_1353)) {
                class_2680 blockState;
                collisionLocation = collisionLocation.method_1019(entity.method_73189().method_1019(entity.method_5829().method_1005()).method_1021(0.5));
                if (temporalCollision) {
                    collisionLocation = collisionLocation.method_1031(0.0, motionResponse.field_1351, 0.0);
                }
                class_2338 pos = class_2338.method_49638((class_2374)contraptionEntity.toLocalVector(entity.method_73189(), 0.0f));
                if (contraption.getBlocks().containsKey(pos) && (blockState = contraption.getBlocks().get(pos).comp_1342()).method_26164(class_3481.field_22414)) {
                    surfaceCollision.setTrue();
                    totalResponse = totalResponse.method_1031(0.0, (double)0.1f, 0.0);
                }
                pos = class_2338.method_49638((class_2374)contraptionEntity.toLocalVector(collisionLocation, 0.0f));
                if (contraption.getBlocks().containsKey(pos)) {
                    blockState = contraption.getBlocks().get(pos).comp_1342();
                    MovingInteractionBehaviour movingInteractionBehaviour = contraption.interactors.get(pos);
                    if (movingInteractionBehaviour != null) {
                        movingInteractionBehaviour.handleEntityCollision(entity, pos, contraptionEntity);
                    }
                    bounce = BlockHelper.getBounceMultiplier(blockState.method_26204());
                    slide = Math.max(0.0f, blockState.method_26204().method_9499() - 0.6f);
                }
            }
            boolean hasNormal = !collisionNormal.equals((Object)class_243.field_1353);
            boolean bl = anyCollision = hardCollision || temporalCollision;
            if (bounce > 0.0 && hasNormal && anyCollision && ContraptionCollider.bounceEntity(entity, collisionNormal, contraptionEntity, bounce)) {
                entity.method_73183().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14560, class_3419.field_15245, 0.5f, 1.0f);
                continue;
            }
            if (temporalCollision && (idealVerticalMotion = motionResponse.field_1351) != entityMotion.field_1351) {
                entity.method_18799(entityMotion.method_18805(1.0, 0.0, 1.0).method_1031(0.0, idealVerticalMotion, 0.0));
                entityMotion = entity.method_18798();
            }
            if (hardCollision) {
                double motionX = entityMotion.method_10216();
                double motionY = entityMotion.method_10214();
                double motionZ = entityMotion.method_10215();
                double intersectX = totalResponse.method_10216();
                double intersectY = totalResponse.method_10214();
                double intersectZ = totalResponse.method_10215();
                double horizonalEpsilon = 0.0078125;
                if (motionX != 0.0 && Math.abs(intersectX) > horizonalEpsilon && motionX > 0.0 == intersectX < 0.0) {
                    entityMotion = entityMotion.method_18805(0.0, 1.0, 1.0);
                }
                if (motionY != 0.0 && intersectY != 0.0 && motionY > 0.0 == intersectY < 0.0) {
                    entityMotion = entityMotion.method_18805(1.0, 0.0, 1.0).method_1031(0.0, contraptionMotion.field_1351, 0.0);
                }
                if (motionZ != 0.0 && Math.abs(intersectZ) > horizonalEpsilon && motionZ > 0.0 == intersectZ < 0.0) {
                    entityMotion = entityMotion.method_18805(1.0, 1.0, 0.0);
                }
            }
            if (bounce == 0.0 && slide > 0.0 && hasNormal && anyCollision && rotation.hasVerticalRotation()) {
                double slideFactor = collisionNormal.method_18805(1.0, 0.0, 1.0).method_1033() * 1.25;
                class_243 motionIn = entityMotionNoTemporal.method_18805(0.0, 0.9, 0.0).method_1031(0.0, (double)-0.01f, 0.0);
                class_243 slideNormal = collisionNormal.method_1036(motionIn.method_1036(collisionNormal)).method_1029();
                class_243 newMotion = entityMotion.method_18805(0.85, 0.0, 0.85).method_1019(slideNormal.method_1021(((double)0.2f + slide) * motionIn.method_1033() * slideFactor).method_1031(0.0, (double)-0.1f - collisionNormal.field_1351 * 0.125, 0.0));
                entity.method_18799(newMotion);
                entityMotion = entity.method_18798();
            }
            if (!hardCollision && surfaceCollision.isFalse()) continue;
            class_243 allowedMovement = ContraptionCollider.collide(totalResponse, entity);
            entity.method_5814(entityPosition.field_1352 + allowedMovement.field_1352, entityPosition.field_1351 + allowedMovement.field_1351, entityPosition.field_1350 + allowedMovement.field_1350);
            entityPosition = entity.method_73189();
            entityMotion = ContraptionCollider.handleDamageFromTrain(world, contraptionEntity, contraptionMotion, entity, entityMotion, playerType);
            entity.field_6037 = true;
            if (surfaceCollision.isTrue()) {
                boolean canWalk;
                contraptionEntity.registerColliding(entity);
                entity.field_6017 = 0.0;
                boolean bl2 = canWalk = bounce != 0.0 || slide == 0.0;
                if (canWalk || !rotation.hasVerticalRotation()) {
                    if (canWalk) {
                        entity.method_24830(true);
                    }
                    if (entity instanceof class_1542) {
                        entityMotion = entityMotion.method_18805(0.5, 1.0, 0.5);
                    }
                }
                class_243 contactPointMotion = contraptionEntity.getContactPointMotion(entityPosition);
                allowedMovement = ContraptionCollider.collide(contactPointMotion, entity);
                entity.method_5814(entityPosition.field_1352 + allowedMovement.field_1352, entityPosition.field_1351, entityPosition.field_1350 + allowedMovement.field_1350);
            }
            entity.method_18799(entityMotion);
        }
    }

    private static class_243 handleDamageFromTrain(class_1937 world, AbstractContraptionEntity contraptionEntity, class_243 contraptionMotion, class_1297 entity, class_243 entityMotion, PlayerType playerType) {
        class_1657 p;
        if (!(contraptionEntity instanceof CarriageContraptionEntity)) {
            return entityMotion;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)contraptionEntity;
        if (!entity.method_24828()) {
            return entityMotion;
        }
        if (AllSynchedDatas.CONTRAPTION_GROUNDED.get(entity).booleanValue()) {
            AllSynchedDatas.CONTRAPTION_GROUNDED.set(entity, false);
            return entityMotion;
        }
        if (cce.collidingEntities.containsKey(entity)) {
            return entityMotion;
        }
        if (entity instanceof class_1542) {
            return entityMotion;
        }
        if (cce.nonDamageTicks != 0) {
            return entityMotion;
        }
        if (!((Boolean)AllConfigs.server().trains.trainsCauseDamage.get()).booleanValue()) {
            return entityMotion;
        }
        class_243 diffMotion = contraptionMotion.method_1020(entity.method_18798());
        if (diffMotion.method_1033() <= (double)0.35f || contraptionMotion.method_1033() <= (double)0.35f) {
            return entityMotion;
        }
        class_1282 source = AllDamageSources.get(world).runOver(contraptionEntity);
        double damage = diffMotion.method_1033();
        if (entity.method_5864().method_5891() == class_1311.field_6302) {
            damage *= 2.0;
        }
        if (entity instanceof class_1657 && ((p = (class_1657)entity).method_68878() || p.method_7325())) {
            return entityMotion;
        }
        if (playerType != PlayerType.CLIENT) {
            class_3218 serverWorld = (class_3218)world;
            entity.method_64397(serverWorld, source, (float)((int)(damage * 16.0)));
            serverWorld.method_8396(null, entity.method_24515(), class_3417.field_15016, class_3419.field_15254, 1.0f, 0.75f);
            if (!entity.method_5805()) {
                contraptionEntity.getControllingPlayer().ifPresent(uuid -> AllAdvancements.TRAIN_ROADKILL.trigger((class_3222)serverWorld.method_18470(uuid)));
            }
        }
        class_243 added = entityMotion.method_1019(contraptionMotion.method_18805(1.0, 0.0, 1.0).method_1029().method_1031(0.0, 0.25, 0.0).method_1021(damage * 4.0)).method_1019(diffMotion);
        return VecHelper.clamp(added, 3.0f);
    }

    public static boolean bounceEntity(class_1297 entity, class_243 normal, AbstractContraptionEntity contraption, double factor) {
        if (factor == 0.0) {
            return false;
        }
        if (entity.method_21750()) {
            return false;
        }
        class_243 contactPointMotion = contraption.getContactPointMotion(entity.method_73189());
        class_243 motion = entity.method_18798().method_1020(contactPointMotion);
        class_243 deltav = normal.method_1021(factor * 2.0 * motion.method_1026(normal));
        if (deltav.method_1026(deltav) < (double)0.1f) {
            return false;
        }
        entity.method_18799(entity.method_18798().method_1020(deltav));
        return true;
    }

    public static class_243 getWorldToLocalTranslation(class_1297 entity, class_243 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        class_243 entityPosition = entity.method_73189();
        class_243 centerY = new class_243(0.0, entity.method_5829().method_17940() / 2.0, 0.0);
        class_243 position = entityPosition;
        position = position.method_1019(centerY);
        position = ContraptionCollider.worldToLocalPos(position, anchorVec, rotationMatrix, yawOffset);
        position = position.method_1020(centerY);
        position = position.method_1020(entityPosition);
        return position;
    }

    public static class_243 worldToLocalPos(class_243 worldPos, AbstractContraptionEntity contraptionEntity) {
        return ContraptionCollider.worldToLocalPos(worldPos, contraptionEntity.getAnchorVec(), contraptionEntity.getRotationState());
    }

    public static class_243 worldToLocalPos(class_243 worldPos, class_243 anchorVec, AbstractContraptionEntity.ContraptionRotationState rotation) {
        return ContraptionCollider.worldToLocalPos(worldPos, anchorVec, rotation.asMatrix(), rotation.getYawOffset());
    }

    public static class_243 worldToLocalPos(class_243 worldPos, class_243 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        class_243 localPos = worldPos;
        localPos = localPos.method_1020(anchorVec);
        localPos = localPos.method_1020(VecHelper.CENTER_OF_ORIGIN);
        localPos = VecHelper.rotate(localPos, -yawOffset, class_2350.class_2351.field_11052);
        localPos = rotationMatrix.transform(localPos);
        localPos = localPos.method_1019(VecHelper.CENTER_OF_ORIGIN);
        return localPos;
    }

    public static class_243 collide(class_243 p_20273_, class_1297 e) {
        boolean flag3;
        class_238 aabb = e.method_5829();
        class_1937 world = e.method_73183();
        List list = world.method_20743(e, aabb.method_18804(p_20273_));
        class_243 vec3 = p_20273_.method_1027() == 0.0 ? p_20273_ : class_1297.method_20736((class_1297)e, (class_243)p_20273_, (class_238)aabb, (class_1937)world, (List)list);
        boolean flag = p_20273_.field_1352 != vec3.field_1352;
        boolean flag1 = p_20273_.field_1351 != vec3.field_1351;
        boolean flag2 = p_20273_.field_1350 != vec3.field_1350;
        boolean bl = flag3 = flag1 && p_20273_.field_1351 < 0.0;
        if (e.method_49476() > 0.0f && flag3 && (flag || flag2)) {
            class_243 vec33;
            class_243 vec31 = class_1297.method_20736((class_1297)e, (class_243)new class_243(p_20273_.field_1352, (double)e.method_49476(), p_20273_.field_1350), (class_238)aabb, (class_1937)world, (List)list);
            class_243 vec32 = class_1297.method_20736((class_1297)e, (class_243)new class_243(0.0, (double)e.method_49476(), 0.0), (class_238)aabb.method_1012(p_20273_.field_1352, 0.0, p_20273_.field_1350), (class_1937)world, (List)list);
            if (vec32.field_1351 < (double)e.method_49476() && (vec33 = class_1297.method_20736((class_1297)e, (class_243)new class_243(p_20273_.field_1352, 0.0, p_20273_.field_1350), (class_238)aabb.method_997(vec32), (class_1937)world, (List)list).method_1019(vec32)).method_37268() > vec31.method_37268()) {
                vec31 = vec33;
            }
            if (vec31.method_37268() > vec3.method_37268()) {
                return vec31.method_1019(class_1297.method_20736((class_1297)e, (class_243)new class_243(0.0, -vec31.field_1351 + p_20273_.field_1351, 0.0), (class_238)aabb.method_997(vec31), (class_1937)world, (List)list));
            }
        }
        return vec3;
    }

    private static PlayerType getPlayerType(class_1297 entity) {
        return entity instanceof class_1657 ? PlayerType.SERVER : PlayerType.NONE;
    }

    public static List<class_265> getPotentiallyCollidedShapes(class_1937 world, Contraption contraption, class_238 localBB) {
        double width;
        double height = localBB.method_17940();
        double horizontalFactor = height > (width = localBB.method_17939()) && width != 0.0 ? height / width : 1.0;
        double verticalFactor = width > height && height != 0.0 ? width / height : 1.0;
        class_238 blockScanBB = localBB.method_1014(0.5);
        blockScanBB = blockScanBB.method_1009(horizontalFactor, verticalFactor, horizontalFactor);
        class_2338 min = class_2338.method_49637((double)blockScanBB.field_1323, (double)blockScanBB.field_1322, (double)blockScanBB.field_1321);
        class_2338 max = class_2338.method_49637((double)blockScanBB.field_1320, (double)blockScanBB.field_1325, (double)blockScanBB.field_1324);
        ArrayList<class_265> potentialHits = new ArrayList<class_265>();
        for (class_2338 p : class_2338.method_10097((class_2338)min, (class_2338)max)) {
            if (!contraption.blocks.containsKey(p) || contraption.isHiddenInPortal(p)) continue;
            class_3499.class_3501 info = contraption.getBlocks().get(p);
            class_2680 blockState = info.comp_1342();
            class_2338 pos = info.comp_1341();
            class_265 collisionShape = blockState.method_26220((class_1922)world, p).method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            if (collisionShape.method_1110()) continue;
            potentialHits.add(collisionShape);
        }
        return potentialHits;
    }

    public static boolean collideBlocks(AbstractContraptionEntity contraptionEntity) {
        if (!contraptionEntity.supportsTerrainCollision()) {
            return false;
        }
        class_1937 world = contraptionEntity.method_73183();
        class_243 motion = contraptionEntity.method_18798();
        TranslatingContraption contraption = (TranslatingContraption)contraptionEntity.getContraption();
        class_238 bounds = contraptionEntity.method_5829();
        class_243 position = contraptionEntity.method_73189();
        class_2338 gridPos = class_2338.method_49638((class_2374)position);
        if (contraption == null) {
            return false;
        }
        if (bounds == null) {
            return false;
        }
        if (motion.equals((Object)class_243.field_1353)) {
            return false;
        }
        class_2350 movementDirection = class_2350.method_10142((double)motion.field_1352, (double)motion.field_1351, (double)motion.field_1350);
        if (movementDirection.method_10171() == class_2350.class_2352.field_11056) {
            gridPos = gridPos.method_10093(movementDirection);
        }
        if (ContraptionCollider.isCollidingWithWorld(world, contraption, gridPos, movementDirection)) {
            return true;
        }
        for (ControlledContraptionEntity otherContraptionEntity : world.method_8390(ControlledContraptionEntity.class, bounds.method_1014(1.0), e -> !e.equals((Object)contraptionEntity))) {
            if (!otherContraptionEntity.supportsTerrainCollision()) continue;
            class_243 otherMotion = otherContraptionEntity.method_18798();
            TranslatingContraption otherContraption = (TranslatingContraption)otherContraptionEntity.getContraption();
            class_238 otherBounds = otherContraptionEntity.method_5829();
            class_243 otherPosition = otherContraptionEntity.method_73189();
            if (otherContraption == null) {
                return false;
            }
            if (otherBounds == null) {
                return false;
            }
            if (!bounds.method_997(motion).method_994(otherBounds.method_997(otherMotion))) continue;
            for (class_2338 colliderPos : contraption.getOrCreateColliders(world, movementDirection)) {
                colliderPos = colliderPos.method_10081((class_2382)gridPos).method_10059((class_2382)class_2338.method_49638((class_2374)otherPosition));
                if (!otherContraption.getBlocks().containsKey(colliderPos)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCollidingWithWorld(class_1937 world, TranslatingContraption contraption, class_2338 anchor, class_2350 movementDirection) {
        for (class_2338 pos : contraption.getOrCreateColliders(world, movementDirection)) {
            class_2338 colliderPos = pos.method_10081((class_2382)anchor);
            if (!world.method_8477(colliderPos)) {
                return true;
            }
            class_2680 collidedState = world.method_8320(colliderPos);
            class_3499.class_3501 blockInfo = contraption.getBlocks().get(pos);
            boolean emptyCollider = collidedState.method_26220((class_1922)world, pos).method_1110();
            if (collidedState.method_26204() instanceof class_2282) continue;
            MovementBehaviour movementBehaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)blockInfo.comp_1342());
            if (movementBehaviour != null) {
                if (movementBehaviour instanceof BlockBreakingMovementBehaviour) {
                    BlockBreakingMovementBehaviour behaviour = (BlockBreakingMovementBehaviour)movementBehaviour;
                    if (behaviour.canBreak(world, colliderPos, collidedState) || emptyCollider) continue;
                    return true;
                }
                if (movementBehaviour instanceof HarvesterMovementBehaviour) {
                    HarvesterMovementBehaviour harvesterMovementBehaviour = (HarvesterMovementBehaviour)movementBehaviour;
                    if (harvesterMovementBehaviour.isValidCrop(world, colliderPos, collidedState) || harvesterMovementBehaviour.isValidOther(world, colliderPos, collidedState) || emptyCollider) continue;
                    return true;
                }
            }
            if (collidedState.method_27852((class_2248)AllBlocks.PULLEY_MAGNET) && pos.equals((Object)class_2338.field_10980) && movementDirection == class_2350.field_11036 || collidedState.method_45474() || emptyCollider) continue;
            return true;
        }
        return false;
    }

    public static enum PlayerType {
        NONE,
        CLIENT,
        REMOTE,
        SERVER;

    }
}

