/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.bearing;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.decoration.copycat.CopycatBlockEntity;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.Pair;

public class BearingContraption
extends Contraption {
    protected int sailBlocks;
    protected class_2350 facing;
    private boolean isWindmill;

    public BearingContraption() {
    }

    public BearingContraption(boolean isWindmill, class_2350 facing) {
        this.isWindmill = isWindmill;
        this.facing = facing;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        class_2338 offset = pos.method_10093(this.facing);
        if (!this.searchMovedStructure(world, offset, null)) {
            return false;
        }
        this.startMoving(world);
        this.expandBoundsAroundAxis(this.facing.method_10166());
        if (this.isWindmill && this.sailBlocks < (Integer)AllConfigs.server().kinetics.minimumWindmillSails.get()) {
            throw AssemblyException.notEnoughSails(this.sailBlocks);
        }
        return !this.blocks.isEmpty();
    }

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.BEARING;
    }

    @Override
    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return pos.equals((Object)this.anchor.method_10093(this.facing.method_10153()));
    }

    @Override
    public void addBlock(class_1937 level, class_2338 pos, Pair<class_3499.class_3501, class_2586> capture) {
        class_2338 localPos = pos.method_10059((class_2382)this.anchor);
        if (!this.getBlocks().containsKey(localPos) && this.getSailBlock(capture).method_26164(AllBlockTags.WINDMILL_SAILS)) {
            ++this.sailBlocks;
        }
        super.addBlock(level, pos, capture);
    }

    private class_2680 getSailBlock(Pair<class_3499.class_3501, class_2586> capture) {
        Object object;
        class_2680 state = ((class_3499.class_3501)capture.getKey()).comp_1342();
        if (state.method_27852((class_2248)AllBlocks.COPYCAT_PANEL) && (object = capture.getRight()) instanceof CopycatBlockEntity) {
            CopycatBlockEntity cbe = (CopycatBlockEntity)object;
            return cbe.getMaterial();
        }
        return state;
    }

    @Override
    public void write(class_11372 view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.method_71465("Sails", this.sailBlocks);
        view.method_71465("Facing", this.facing.method_10146());
    }

    @Override
    public void read(class_1937 world, class_11368 view, boolean spawnData) {
        this.sailBlocks = view.method_71424("Sails", 0);
        this.facing = class_2350.method_10143((int)view.method_71424("Facing", 0));
        super.read(world, view, spawnData);
    }

    public int getSailBlocks() {
        return this.sailBlocks;
    }

    public class_2350 getFacing() {
        return this.facing;
    }

    @Override
    public boolean canBeStabilized(class_2350 facing, class_2338 localPos) {
        if (facing.method_10153() == this.facing && class_2338.field_10980.equals((Object)localPos)) {
            return false;
        }
        return facing.method_10166() == this.facing.method_10166();
    }
}

