/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.minecart;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.contraptions.minecart.MinecartSim2020;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;

public class CouplingPhysics {
    public static void tick(class_3218 world) {
        CouplingHandler.forEachLoadedCoupling((class_1937)world, c -> CouplingPhysics.tickCoupling(world, c));
    }

    public static void tickCoupling(class_3218 world, Couple<MinecartController> c) {
        Couple<class_1688> carts = c.map(MinecartController::cart);
        float couplingLength = ((MinecartController)c.getFirst()).getCouplingLength(true);
        CouplingPhysics.softCollisionStep(world, carts, couplingLength);
        if (!class_1688.method_61566((class_1937)world)) {
            CouplingPhysics.hardCollisionStep(world, carts, couplingLength);
        }
    }

    public static void hardCollisionStep(class_3218 world, Couple<class_1688> carts, double couplingLength) {
        if (!MinecartSim2020.canAddMotion(((Couple)carts).get(false)) && MinecartSim2020.canAddMotion(((Couple)carts).get(true))) {
            carts = ((Couple)carts).swap();
        }
        Couple<Object> corrections = Couple.create(null, null);
        Couple<Double> maxSpeed = ((Couple)carts).map(cart -> cart.method_7504(world));
        boolean firstLoop = true;
        for (boolean current : new boolean[]{true, false, true}) {
            float correctionMagnitude;
            class_1688 cart2 = (class_1688)((Couple)carts).get(current);
            class_1688 otherCart = (class_1688)((Couple)carts).get(!current);
            float stress = (float)(couplingLength - cart2.method_73189().method_1022(otherCart.method_73189()));
            if (Math.abs(stress) < 0.125f) continue;
            class_243 pos = cart2.method_73189();
            class_243 link = otherCart.method_73189().method_1020(pos);
            float f = correctionMagnitude = firstLoop ? -stress / 2.0f : -stress;
            if (!MinecartSim2020.canAddMotion(cart2)) {
                correctionMagnitude /= 2.0f;
            }
            class_243 correction = link.method_1029().method_1021((double)correctionMagnitude);
            float maxResolveSpeed = 1.75f;
            correction = VecHelper.clamp(correction, (float)Math.min((double)maxResolveSpeed, maxSpeed.get(current)));
            if (corrections.get(current) == null) {
                corrections.set(current, correction);
            }
            cart2.method_5784(class_1313.field_6308, correction);
            cart2.method_18799(cart2.method_18798().method_1021((double)0.95f));
            firstLoop = false;
        }
    }

    public static void softCollisionStep(class_3218 world, Couple<class_1688> carts, double couplingLength) {
        Couple<Float> maxSpeed = carts.map(cart -> Float.valueOf((float)cart.method_7504(world)));
        Couple<Boolean> canAddmotion = carts.map(MinecartSim2020::canAddMotion);
        Couple<class_243> motions = carts.map(class_1297::method_18798);
        motions.replaceWithParams(VecHelper::clamp, Couple.create(Float.valueOf(1.0f), Float.valueOf(1.0f)));
        Couple<class_243> nextPositions = carts.map(MinecartSim2020::predictNextPositionOf);
        Couple<class_2768> shapes = carts.mapWithContext((minecart, current) -> {
            class_2248 patt0$temp;
            int z;
            int y;
            class_243 vec = (class_243)nextPositions.get((boolean)current);
            int x = class_3532.method_15357((double)vec.method_10216());
            class_2338 pos = new class_2338(x, (y = class_3532.method_15357((double)vec.method_10214())) - 1, z = class_3532.method_15357((double)vec.method_10215()));
            class_2680 railState = world.method_8320(pos);
            if (!railState.method_26164(class_3481.field_15463)) {
                railState = world.method_8320(pos.method_10084());
            }
            if (!((patt0$temp = railState.method_26204()) instanceof class_2241)) {
                return null;
            }
            class_2241 block = (class_2241)patt0$temp;
            return (class_2768)railState.method_11654(block.method_9474());
        });
        float futureStress = (float)(couplingLength - ((class_243)nextPositions.getFirst()).method_1022((class_243)nextPositions.getSecond()));
        if (class_3532.method_20390((double)futureStress, (double)0.0)) {
            return;
        }
        for (boolean current2 : Iterate.trueAndFalse) {
            class_243 correction;
            class_243 pos = nextPositions.get(current2);
            class_243 link = nextPositions.get(!current2).method_1020(pos);
            float correctionMagnitude = -futureStress / 2.0f;
            if (canAddmotion.get(current2) != canAddmotion.get(!current2)) {
                float f = correctionMagnitude = canAddmotion.get(current2) == false ? 0.0f : correctionMagnitude * 2.0f;
            }
            if (!canAddmotion.get(current2).booleanValue()) continue;
            class_2768 shape = shapes.get(current2);
            if (shape != null) {
                class_243 railVec = MinecartSim2020.getRailVec(shape);
                correction = CouplingPhysics.followLinkOnRail(link, pos, correctionMagnitude, railVec).method_1020(pos);
            } else {
                correction = link.method_1029().method_1021((double)correctionMagnitude);
            }
            correction = VecHelper.clamp(correction, maxSpeed.get(current2).floatValue());
            motions.set(current2, motions.get(current2).method_1019(correction));
        }
        motions.replaceWithParams(VecHelper::clamp, maxSpeed);
        carts.forEachWithParams(class_1297::method_18799, motions);
    }

    public static class_243 followLinkOnRail(class_243 link, class_243 cart, float diffToReduce, class_243 railAxis) {
        double radius;
        class_243 center;
        double dotProduct = railAxis.method_1026(link);
        if (Double.isNaN(dotProduct) || dotProduct == 0.0 || diffToReduce == 0.0f) {
            return cart;
        }
        class_243 axis = railAxis.method_1021(-Math.signum(dotProduct));
        class_243 intersectSphere = VecHelper.intersectSphere(cart, axis, center = cart.method_1019(link), radius = link.method_1033() - (double)diffToReduce);
        if (intersectSphere == null) {
            return cart.method_1019(VecHelper.project(link, axis));
        }
        return intersectSphere;
    }
}

