/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.toolbox;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.item.ItemSlots;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolboxInventory
implements ItemInventory {
    public static final int STACKS_PER_COMPARTMENT = 4;
    public static final int SIZE = 32;
    public static final Codec<ToolboxInventory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemSlots.maxSizeCodec(32).fieldOf("items").forGetter(ItemSlots::fromHandler), (App)class_1799.field_49266.listOf().fieldOf("filters").forGetter(toolbox -> toolbox.filters)).apply((Applicative)instance, ToolboxInventory::deserialize));
    public static final class_9139<class_9129, ToolboxInventory> STREAM_CODEC = class_9139.method_56435(ItemSlots.STREAM_CODEC, ItemSlots::fromHandler, CatnipStreamCodecBuilders.list(class_1799.field_49268), toolbox -> toolbox.filters, ToolboxInventory::deserialize);
    public class_2371<class_1799> filters = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    class_2371<class_1799> stacks = class_2371.method_10213((int)32, (Object)class_1799.field_8037);
    @Nullable
    private final ToolboxBlockEntity blockEntity;
    private boolean limitedMode;

    public ToolboxInventory(@Nullable ToolboxBlockEntity be) {
        this.blockEntity = be;
        this.limitedMode = false;
    }

    public void inLimitedMode(Consumer<ToolboxInventory> action) {
        this.limitedMode = true;
        action.accept(this);
        this.limitedMode = false;
    }

    public int method_5439() {
        return 32;
    }

    public class_1799 method_5438(int slot) {
        if (slot >= 32) {
            return class_1799.field_8037;
        }
        return (class_1799)this.stacks.get(slot);
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (!stack.method_7909().method_31568()) {
            return false;
        }
        if (slot >= 32) {
            return false;
        }
        class_1799 filter = (class_1799)this.filters.get(slot / 4);
        boolean empty = filter.method_7960();
        if (this.limitedMode && empty) {
            return false;
        }
        return empty || ToolboxInventory.canItemsShareCompartment(filter, stack);
    }

    public void method_5447(int slot, class_1799 stack) {
        int compartment;
        if (slot >= 32) {
            return;
        }
        this.stacks.set(slot, (Object)stack);
        if (!stack.method_7960() && ((class_1799)this.filters.get(compartment = slot / 4)).method_7960()) {
            this.filters.set(compartment, (Object)stack.method_46651(1));
        }
    }

    public int distributeToCompartment(@NotNull class_1799 stack, int compartment, boolean simulate) {
        int i;
        if (stack.method_7960() || !stack.method_7909().method_31568()) {
            return 0;
        }
        class_1799 filter = (class_1799)this.filters.get(compartment);
        if (filter.method_7960() || !ToolboxInventory.canItemsShareCompartment(filter, stack)) {
            return 0;
        }
        int maxAmount = stack.method_7947();
        int stackSize = stack.method_7914();
        if (simulate) {
            int i2;
            int count = 0;
            int end = i2 + 4;
            for (i2 = compartment * 4; i2 < end; ++i2) {
                class_1799 target = this.method_5438(i2);
                if (target.method_7960()) {
                    return maxAmount;
                }
                if ((count += stackSize - target.method_7947()) < maxAmount) continue;
                return maxAmount;
            }
            return count;
        }
        int remaining = maxAmount;
        int end = i + 4;
        for (i = compartment * 4; i < end; ++i) {
            class_1799 target = this.method_5438(i);
            if (target.method_7960()) {
                this.method_5447(i, this.directCopy(stack, remaining));
                this.method_5431();
                return maxAmount;
            }
            int count = target.method_7947();
            if (count == stackSize) continue;
            int insert = Math.min(remaining, stackSize - count);
            target.method_7939(count + insert);
            if (remaining == insert) {
                this.method_5431();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.method_5431();
        return maxAmount - remaining;
    }

    public class_1799 takeFromCompartment(int maxAmount, int compartment, boolean simulate) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int index = compartment * 4;
        if (simulate) {
            for (int i = index + 4 - 1; i >= index; --i) {
                class_1799 findStack = (class_1799)this.stacks.get(i);
                if (findStack.method_7960()) continue;
                int count = findStack.method_7947();
                if (count >= maxAmount) {
                    return this.directCopy(findStack, maxAmount);
                }
                for (int j = i - 1; j >= index; --j) {
                    class_1799 stack = this.method_5438(i);
                    if (stack.method_7960() || (count += stack.method_7947()) < maxAmount) continue;
                    return this.directCopy(findStack, maxAmount);
                }
                return this.directCopy(findStack, count);
            }
            return class_1799.field_8037;
        }
        class_1799 stack = this.takeFromCompartment(maxAmount, index, index + 4 - 1);
        if (stack == class_1799.field_8037) {
            return stack;
        }
        this.method_5431();
        return stack;
    }

    protected class_1799 takeFromCompartment(int maxAmount, int start, int end) {
        for (int i = end; i >= start; --i) {
            class_1799 findStack = (class_1799)this.stacks.get(i);
            if (findStack.method_7960()) continue;
            int count = findStack.method_7947();
            if (count > maxAmount) {
                findStack.method_7939(count - maxAmount);
                return this.directCopy(findStack, maxAmount);
            }
            this.method_5447(i, class_1799.field_8037);
            if (count == maxAmount) {
                return findStack;
            }
            int remaining = maxAmount - count;
            for (int j = i - 1; j >= start; --j) {
                class_1799 stack = (class_1799)this.stacks.get(j);
                if (stack.method_7960()) continue;
                count = stack.method_7947();
                if (count < remaining) {
                    this.method_5447(i, class_1799.field_8037);
                    remaining -= count;
                    continue;
                }
                if (count == remaining) {
                    this.method_5447(i, class_1799.field_8037);
                } else {
                    stack.method_7939(count - remaining);
                }
                findStack.method_7939(maxAmount);
                return findStack;
            }
            findStack.method_7939(maxAmount - remaining);
            return findStack;
        }
        return class_1799.field_8037;
    }

    @Override
    public void method_5431() {
        if (this.blockEntity != null) {
            this.blockEntity.notifyUpdate();
        }
    }

    public static class_1799 cleanItemNBT(class_1799 stack) {
        if (stack.method_31574((class_1792)AllItems.BELT_CONNECTOR)) {
            stack.method_57381(AllDataComponents.BELT_FIRST_SHAFT);
        }
        return stack;
    }

    public static boolean canItemsShareCompartment(class_1799 stack1, class_1799 stack2) {
        if (!stack1.method_7946() && !stack2.method_7946() && stack1.method_7963() && stack2.method_7963()) {
            return stack1.method_7909() == stack2.method_7909();
        }
        if (stack1.method_31574((class_1792)AllItems.BELT_CONNECTOR) && stack2.method_31574((class_1792)AllItems.BELT_CONNECTOR)) {
            return true;
        }
        return class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }

    public void write(class_11372 view) {
        view.method_71468("Items", ItemSlots.CODEC, (Object)ItemSlots.fromHandler(this));
        view.method_71468("Compartments", CreateCodecs.ITEM_LIST_CODEC, this.filters);
    }

    public void read(class_11368 view) {
        view.method_71426("Items", ItemSlots.CODEC).ifPresentOrElse(slots -> {
            boolean[] fill = new boolean[32];
            slots.forEach((slot, stack) -> {
                this.stacks.set(slot, (Object)stack);
                fill[slot] = true;
            });
            for (int i = 0; i < 32; ++i) {
                if (fill[i]) continue;
                this.stacks.set(i, (Object)class_1799.field_8037);
            }
        }, () -> this.stacks.clear());
        view.method_71426("Compartments", CreateCodecs.ITEM_LIST_CODEC).ifPresentOrElse(list -> {
            int size = Math.min(list.size(), 32);
            for (int i = 0; i < size; ++i) {
                this.filters.set(i, (Object)((class_1799)list.get(i)));
            }
        }, () -> this.filters.clear());
    }

    private static ToolboxInventory deserialize(ItemSlots slots, List<class_1799> filters) {
        ToolboxInventory inventory = new ToolboxInventory(null);
        slots.forEach((arg_0, arg_1) -> inventory.stacks.set(arg_0, arg_1));
        int size = Math.min(filters.size(), 32);
        for (int i = 0; i < size; ++i) {
            inventory.filters.set(i, (Object)filters.get(i));
        }
        return inventory;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ToolboxInventory)) {
            return false;
        }
        ToolboxInventory that = (ToolboxInventory)o;
        return this.limitedMode == that.limitedMode && this.filters.equals(that.filters) && Objects.equals(this.blockEntity, that.blockEntity);
    }

    public int hashCode() {
        int result = this.filters.hashCode();
        result = 31 * result + Objects.hashCode(this.blockEntity);
        result = 31 * result + Boolean.hashCode(this.limitedMode);
        return result;
    }
}

