/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.PipeConnection;
import com.zurrtum.create.content.fluids.pipes.AxisPipeBlock;
import com.zurrtum.create.content.fluids.pipes.FluidPipeBlock;
import com.zurrtum.create.content.fluids.pipes.VanillaFluidTargets;
import com.zurrtum.create.content.fluids.pump.PumpBlock;
import com.zurrtum.create.content.fluids.pump.PumpBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class FluidPropagator {
    public static List<CreateTrigger> getSharedTriggers() {
        ArrayList<CreateTrigger> result = new ArrayList<CreateTrigger>();
        result.add(AllAdvancements.WATER_SUPPLY);
        result.add(AllAdvancements.CROSS_STREAMS);
        result.add(AllAdvancements.HONEY_DRAIN);
        return result;
    }

    public static void propagateChangedPipe(class_1936 world, class_2338 pipePos, class_2680 pipeState) {
        ArrayList<Pair<Integer, class_2338>> frontier = new ArrayList<Pair<Integer, class_2338>>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        HashSet<Pair<PumpBlockEntity, class_2350>> discoveredPumps = new HashSet<Pair<PumpBlockEntity, class_2350>>();
        frontier.add(Pair.of(0, pipePos));
        while (!frontier.isEmpty()) {
            Pair pair2 = (Pair)frontier.remove(0);
            class_2338 currentPos = (class_2338)pair2.getSecond();
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            class_2680 currentState = currentPos.equals((Object)pipePos) ? pipeState : world.method_8320(currentPos);
            FluidTransportBehaviour pipe = FluidPropagator.getPipe((class_1922)world, currentPos);
            if (pipe == null) continue;
            pipe.wipePressure();
            for (class_2350 direction : FluidPropagator.getPipeConnections(currentState, pipe)) {
                Integer distance;
                FluidTransportBehaviour targetPipe;
                class_1937 l;
                class_2338 target = currentPos.method_10093(direction);
                if (world instanceof class_1937 && !(l = (class_1937)world).method_8477(target)) continue;
                class_2586 blockEntity = world.method_8321(target);
                class_2680 targetState = world.method_8320(target);
                if (blockEntity instanceof PumpBlockEntity) {
                    if (!targetState.method_27852((class_2248)AllBlocks.MECHANICAL_PUMP) || ((class_2350)targetState.method_11654((class_2769)PumpBlock.FACING)).method_10166() != direction.method_10166()) continue;
                    discoveredPumps.add(Pair.of((PumpBlockEntity)blockEntity, direction.method_10153()));
                    continue;
                }
                if (visited.contains(target) || (targetPipe = FluidPropagator.getPipe((class_1922)world, target)) == null || (distance = (Integer)pair2.getFirst()) >= FluidPropagator.getPumpRange() && !targetPipe.hasAnyPressure() || !targetPipe.canHaveFlowToward(targetState, direction.method_10153())) continue;
                frontier.add(Pair.of(distance + 1, target));
            }
        }
        discoveredPumps.forEach(pair -> ((PumpBlockEntity)pair.getFirst()).updatePipesOnSide((class_2350)pair.getSecond()));
    }

    public static void resetAffectedFluidNetworks(class_1937 world, class_2338 start, class_2350 side) {
        ArrayList<class_2338> frontier = new ArrayList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        frontier.add(start);
        while (!frontier.isEmpty()) {
            class_2338 pos = (class_2338)frontier.remove(0);
            if (visited.contains(pos)) continue;
            visited.add(pos);
            FluidTransportBehaviour pipe = FluidPropagator.getPipe((class_1922)world, pos);
            if (pipe == null) continue;
            for (class_2350 d : Iterate.directions) {
                PipeConnection connection;
                class_2338 target;
                if (pos.equals((Object)start) && d != side || visited.contains(target = pos.method_10093(d)) || (connection = pipe.getConnection(d)) == null || !connection.hasFlow()) continue;
                PipeConnection.Flow flow = connection.flow.get();
                if (!flow.inbound) continue;
                connection.resetNetwork();
                frontier.add(target);
            }
        }
    }

    public static class_2350 validateNeighbourChange(class_2680 state, class_1937 world, class_2338 pos, class_2248 otherBlock, class_2338 neighborPos, boolean isMoving) {
        if (world.method_8608()) {
            return null;
        }
        otherBlock = world.method_8320(neighborPos).method_26204();
        if (otherBlock instanceof FluidPipeBlock) {
            return null;
        }
        if (otherBlock instanceof AxisPipeBlock) {
            return null;
        }
        if (otherBlock instanceof PumpBlock) {
            return null;
        }
        if (otherBlock instanceof class_2404) {
            return null;
        }
        if (FluidPropagator.getStraightPipeAxis(state) == null && !state.method_27852((class_2248)AllBlocks.ENCASED_FLUID_PIPE)) {
            return null;
        }
        for (class_2350 d : Iterate.directions) {
            if (!pos.method_10093(d).equals((Object)neighborPos)) continue;
            return d;
        }
        return null;
    }

    public static FluidTransportBehaviour getPipe(class_1922 reader, class_2338 pos) {
        return BlockEntityBehaviour.get(reader, pos, FluidTransportBehaviour.TYPE);
    }

    public static boolean isOpenEnd(class_1922 reader, class_2338 pos, class_2350 side) {
        class_2338 connectedPos = pos.method_10093(side);
        class_2680 connectedState = reader.method_8320(connectedPos);
        FluidTransportBehaviour pipe = FluidPropagator.getPipe(reader, connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, side.method_10153())) {
            return false;
        }
        if (PumpBlock.isPump(connectedState) && ((class_2350)connectedState.method_11654((class_2769)PumpBlock.FACING)).method_10166() == side.method_10166()) {
            return false;
        }
        if (VanillaFluidTargets.canProvideFluidWithoutCapability(connectedState)) {
            return true;
        }
        if (BlockHelper.hasBlockSolidSide(connectedState, reader, connectedPos, side.method_10153()) && !connectedState.method_26164(AllBlockTags.FAN_TRANSPARENT)) {
            return false;
        }
        if (FluidPropagator.hasFluidCapability(reader, connectedPos, side.method_10153())) {
            return false;
        }
        return connectedState.method_45474() && connectedState.method_26214(reader, connectedPos) != -1.0f || connectedState.method_28498((class_2769)class_2741.field_12508);
    }

    public static List<class_2350> getPipeConnections(class_2680 state, FluidTransportBehaviour pipe) {
        ArrayList<class_2350> list = new ArrayList<class_2350>();
        for (class_2350 d : Iterate.directions) {
            if (!pipe.canHaveFlowToward(state, d)) continue;
            list.add(d);
        }
        return list;
    }

    public static int getPumpRange() {
        return (Integer)AllConfigs.server().fluids.mechanicalPumpRange.get();
    }

    public static boolean hasFluidCapability(class_1922 world, class_2338 pos, class_2350 side) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null) {
            return false;
        }
        class_1937 targetWorld = blockEntity.method_10997();
        if (targetWorld == null) {
            return false;
        }
        return FluidHelper.hasFluidInventory(targetWorld, pos, null, blockEntity, side);
    }

    @Nullable
    public static class_2350.class_2351 getStraightPipeAxis(class_2680 state) {
        if (state.method_26204() instanceof PumpBlock) {
            return ((class_2350)state.method_11654((class_2769)PumpBlock.FACING)).method_10166();
        }
        if (state.method_26204() instanceof AxisPipeBlock) {
            return (class_2350.class_2351)state.method_11654((class_2769)AxisPipeBlock.field_11459);
        }
        if (!FluidPipeBlock.isPipe(state)) {
            return null;
        }
        class_2350.class_2351 axisFound = null;
        int connections = 0;
        for (class_2350.class_2351 axis : Iterate.axes) {
            class_2350 d1 = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)axis);
            class_2350 d2 = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
            boolean openAt1 = FluidPipeBlock.isOpenAt(state, d1);
            boolean openAt2 = FluidPipeBlock.isOpenAt(state, d2);
            if (openAt1) {
                ++connections;
            }
            if (openAt2) {
                ++connections;
            }
            if (!openAt1 || !openAt2) continue;
            if (axisFound != null) {
                return null;
            }
            axisFound = axis;
        }
        return connections == 2 ? axisFound : null;
    }
}

