/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crafter;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.crafter.CrafterHelper;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class ConnectedInputHandler {
    public static boolean shouldConnect(class_1937 world, class_2338 pos, class_2350 face, class_2350 direction) {
        class_2680 refState = world.method_8320(pos);
        if (!refState.method_28498(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            return false;
        }
        class_2350 refDirection = (class_2350)refState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING);
        if (direction.method_10166() == refDirection.method_10166()) {
            return false;
        }
        if (face == refDirection) {
            return false;
        }
        class_2680 neighbour = world.method_8320(pos.method_10093(direction));
        if (!neighbour.method_27852((class_2248)AllBlocks.MECHANICAL_CRAFTER)) {
            return false;
        }
        return refDirection == neighbour.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING);
    }

    public static void toggleConnection(class_1937 world, class_2338 pos, class_2338 pos2) {
        class_2338 controllerPos2;
        MechanicalCrafterBlockEntity crafter1 = CrafterHelper.getCrafter((class_1920)world, pos);
        MechanicalCrafterBlockEntity crafter2 = CrafterHelper.getCrafter((class_1920)world, pos2);
        if (crafter1 == null || crafter2 == null) {
            return;
        }
        class_2338 controllerPos1 = crafter1.method_11016().method_10081((class_2382)crafter1.input.data.getFirst());
        if (controllerPos1.equals((Object)(controllerPos2 = crafter2.method_11016().method_10081((class_2382)crafter2.input.data.getFirst())))) {
            MechanicalCrafterBlockEntity controller = CrafterHelper.getCrafter((class_1920)world, controllerPos1);
            Set<class_2338> positions = controller.input.data.stream().map(arg_0 -> ((class_2338)controllerPos1).method_10081(arg_0)).collect(Collectors.toSet());
            LinkedList<class_2338> frontier = new LinkedList<class_2338>();
            ArrayList<class_2338> splitGroup = new ArrayList<class_2338>();
            frontier.add(pos2);
            positions.remove(pos2);
            positions.remove(pos);
            while (!frontier.isEmpty()) {
                class_2338 current = (class_2338)frontier.removeFirst();
                for (class_2350 direction : Iterate.directions) {
                    class_2338 next = current.method_10093(direction);
                    if (!positions.remove(next)) continue;
                    splitGroup.add(next);
                    frontier.add(next);
                }
            }
            ConnectedInputHandler.initAndAddAll(world, crafter1, positions);
            ConnectedInputHandler.initAndAddAll(world, crafter2, splitGroup);
            crafter1.method_5431();
            crafter1.connectivityChanged();
            crafter2.method_5431();
            crafter2.connectivityChanged();
            return;
        }
        if (!crafter1.input.isController) {
            crafter1 = CrafterHelper.getCrafter((class_1920)world, controllerPos1);
        }
        if (!crafter2.input.isController) {
            crafter2 = CrafterHelper.getCrafter((class_1920)world, controllerPos2);
        }
        if (crafter1 == null || crafter2 == null) {
            return;
        }
        ConnectedInputHandler.connectControllers(world, crafter1, crafter2);
        world.method_8652(crafter1.method_11016(), crafter1.method_11010(), 3);
        crafter1.method_5431();
        crafter1.connectivityChanged();
        crafter2.method_5431();
        crafter2.connectivityChanged();
    }

    public static void initAndAddAll(class_1937 world, MechanicalCrafterBlockEntity crafter, Collection<class_2338> positions) {
        crafter.input = new ConnectedInput();
        positions.forEach(splitPos -> ConnectedInputHandler.modifyAndUpdate(world, splitPos, input -> {
            input.attachTo(crafter.method_11016(), (class_2338)splitPos);
            crafter.input.data.add(splitPos.method_10059((class_2382)crafter.method_11016()));
        }));
    }

    public static void connectControllers(class_1937 world, MechanicalCrafterBlockEntity crafter1, MechanicalCrafterBlockEntity crafter2) {
        crafter1.input.data.forEach(offset -> {
            class_2338 connectedPos = crafter1.method_11016().method_10081((class_2382)offset);
            ConnectedInputHandler.modifyAndUpdate(world, connectedPos, input -> {});
        });
        crafter2.input.data.forEach(offset -> {
            if (offset.equals((Object)class_2338.field_10980)) {
                return;
            }
            class_2338 connectedPos = crafter2.method_11016().method_10081((class_2382)offset);
            ConnectedInputHandler.modifyAndUpdate(world, connectedPos, input -> {
                input.attachTo(crafter1.method_11016(), connectedPos);
                crafter1.input.data.add(class_2338.field_10980.method_10059((class_2382)input.data.getFirst()));
            });
        });
        crafter2.input.attachTo(crafter1.method_11016(), crafter2.method_11016());
        crafter1.input.data.add(class_2338.field_10980.method_10059((class_2382)crafter2.input.data.getFirst()));
    }

    private static void modifyAndUpdate(class_1937 world, class_2338 pos, Consumer<ConnectedInput> callback) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof MechanicalCrafterBlockEntity)) {
            return;
        }
        MechanicalCrafterBlockEntity crafter = (MechanicalCrafterBlockEntity)blockEntity;
        callback.accept(crafter.input);
        crafter.method_5431();
        crafter.connectivityChanged();
    }

    public static class ConnectedInput {
        private static final Comparator<class_2338> Y_COMPARATOR = Comparator.comparingInt(class_2382::method_10264).reversed();
        private static final Comparator<class_2338> NORTH_COMPARATOR = Y_COMPARATOR.thenComparing(Comparator.comparingInt(class_2382::method_10263).reversed());
        private static final Comparator<class_2338> SOUTH_COMPARATOR = Y_COMPARATOR.thenComparingInt(class_2382::method_10263);
        private static final Comparator<class_2338> EAST_COMPARATOR = Y_COMPARATOR.thenComparing(Comparator.comparingInt(class_2382::method_10260).reversed());
        private static final Comparator<class_2338> WEST_COMPARATOR = Y_COMPARATOR.thenComparingInt(class_2382::method_10260);
        boolean isController = true;
        List<class_2338> data = Collections.synchronizedList(new ArrayList());

        public ConnectedInput() {
            this.data.add(class_2338.field_10980);
        }

        public void attachTo(class_2338 controllerPos, class_2338 myPos) {
            this.isController = false;
            this.data.clear();
            this.data.add(controllerPos.method_10059((class_2382)myPos));
        }

        public class_1263 getItemHandler(class_1937 world, class_2338 pos) {
            return new ConnectedInventory(this.getInventories(world, pos));
        }

        public MechanicalCrafterBlockEntity.CrafterItemHandler[] getInventories(class_1937 world, class_2338 pos) {
            if (!this.isController) {
                class_2338 controllerPos = pos.method_10081((class_2382)this.data.getFirst());
                ConnectedInput input = CrafterHelper.getInput((class_1920)world, controllerPos);
                if (input == this || input == null || !input.isController) {
                    return new MechanicalCrafterBlockEntity.CrafterItemHandler[0];
                }
                return input.getInventories(world, controllerPos);
            }
            Comparator<class_2338> invOrdering = switch ((class_2350)world.method_8320(pos).method_61767((class_2769)MechanicalCrafterBlock.HORIZONTAL_FACING, (Comparable)class_2350.field_11035)) {
                case class_2350.field_11043 -> NORTH_COMPARATOR;
                case class_2350.field_11034 -> EAST_COMPARATOR;
                case class_2350.field_11039 -> WEST_COMPARATOR;
                default -> SOUTH_COMPARATOR;
            };
            return (MechanicalCrafterBlockEntity.CrafterItemHandler[])this.data.stream().sorted(invOrdering).map(l -> CrafterHelper.getCrafter((class_1920)world, pos.method_10081((class_2382)l))).filter(Objects::nonNull).map(MechanicalCrafterBlockEntity::getInventory).toArray(MechanicalCrafterBlockEntity.CrafterItemHandler[]::new);
        }

        public void write(class_11372 view) {
            view.method_71472("Controller", this.isController);
            view.method_71468("Data", CreateCodecs.BLOCK_POS_LIST_CODEC, this.data);
        }

        public void read(class_11368 view) {
            this.isController = view.method_71433("Controller", false);
            this.data.clear();
            view.method_71426("Data", CreateCodecs.BLOCK_POS_LIST_CODEC).ifPresent(this.data::addAll);
            if (this.data.isEmpty()) {
                this.isController = true;
                this.data.add(class_2338.field_10980);
            }
        }
    }

    private static class ConnectedInventory
    implements SidedItemInventory {
        private final MechanicalCrafterBlockEntity.CrafterItemHandler[] itemHandler;
        private final int[] slots;
        private final int size;

        private ConnectedInventory(MechanicalCrafterBlockEntity.CrafterItemHandler[] itemHandler) {
            this.itemHandler = itemHandler;
            this.size = itemHandler.length;
            this.slots = SlotRangeCache.get(this.size);
        }

        public int[] method_5494(class_2350 side) {
            return this.slots;
        }

        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            return this.itemHandler[slot].method_5492(0, stack, dir);
        }

        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            return false;
        }

        public class_1799 onExtract(class_1799 stack) {
            return this.removeMaxSize(stack, MechanicalCrafterBlockEntity.CrafterItemHandler.LIMIT);
        }

        public int method_5444() {
            return 1;
        }

        public int method_5439() {
            return this.size;
        }

        public class_1799 method_5438(int slot) {
            if (slot >= this.size) {
                return class_1799.field_8037;
            }
            return this.itemHandler[slot].getStack();
        }

        public void method_5447(int slot, class_1799 stack) {
            if (slot >= this.size) {
                return;
            }
            MechanicalCrafterBlockEntity.CrafterItemHandler handler = this.itemHandler[slot];
            handler.setStack(stack);
            handler.method_5431();
        }
    }
}

