/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crank;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerValveScrollValueBehaviour;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class ValveHandleBlockEntity
extends HandCrankBlockEntity {
    public ServerScrollValueBehaviour angleInput;
    public int cooldown;
    public int startAngle;
    public int targetAngle;
    public int totalUseTicks;
    private boolean keepAlive;

    public ValveHandleBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.VALVE_HANDLE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.angleInput = new ServerValveScrollValueBehaviour(this);
        this.angleInput.between(-180, 180);
        this.angleInput.setValue(45);
        behaviours.add(this.angleInput);
    }

    @Override
    protected boolean clockwise() {
        return this.angleInput.getValue() < 0 ^ this.backwards;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("TotalUseTicks", this.totalUseTicks);
        view.method_71465("StartAngle", this.startAngle);
        view.method_71465("TargetAngle", this.targetAngle);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.totalUseTicks = view.method_71424("TotalUseTicks", 0);
        this.startAngle = view.method_71424("StartAngle", 0);
        this.targetAngle = view.method_71424("TargetAngle", 0);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.inUse == 0 && this.cooldown > 0) {
            --this.cooldown;
        }
        this.independentAngle = 0.0f;
    }

    public boolean showValue() {
        return this.inUse == 0;
    }

    public boolean activate(boolean sneak) {
        if (this.getTheoreticalSpeed() != 0.0f) {
            return false;
        }
        if (this.inUse > 0 || this.cooldown > 0) {
            return false;
        }
        if (this.field_11863.method_8608()) {
            return true;
        }
        int value = this.angleInput.getValue();
        int target = Math.abs(value);
        int rotationSpeed = AllBlocks.COPPER_VALVE_HANDLE.getRotationSpeed();
        double degreesPerTick = KineticBlockEntity.convertToAngular(rotationSpeed);
        this.inUse = (int)Math.ceil((double)target / degreesPerTick) + 2;
        this.startAngle = 0;
        this.targetAngle = Math.round((float)(this.startAngle + (target > 135 ? 180 : 90) * class_3532.method_17822((double)value)) / 90.0f) * 90;
        this.totalUseTicks = this.inUse;
        this.backwards = sneak;
        this.sequenceContext = SequencedGearshiftBlockEntity.SequenceContext.fromGearshift(SequencerInstructions.TURN_ANGLE, rotationSpeed, target);
        this.updateGeneratedRotation();
        this.cooldown = 4;
        return true;
    }

    @Override
    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        class_2680 state = this.field_11863.method_8320(pos);
        if (this.method_11017().method_20526(state)) {
            this.keepAlive = true;
            this.method_31664(state);
        } else {
            super.method_66473(pos, oldState);
        }
    }

    @Override
    public void method_11012() {
        if (this.keepAlive) {
            this.keepAlive = false;
            this.field_11863.method_22350(this.field_11867).method_12007((class_2586)this);
        } else {
            super.method_11012();
        }
    }
}

