/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.levelWrappers.WrappedLevel;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlockItem;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperItem;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.SandPaperItemComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1755;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3988;
import net.minecraft.class_4174;
import net.minecraft.class_4770;
import net.minecraft.class_5425;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class DeployerHandler {
    private static final Map<class_2338, List<class_1542>> CAPTURED_BLOCK_DROPS = new HashMap<class_2338, List<class_1542>>();
    public static final Map<class_2338, List<class_1542>> CAPTURED_BLOCK_DROPS_VIEW = Collections.unmodifiableMap(CAPTURED_BLOCK_DROPS);

    static boolean shouldActivate(class_1799 held, class_1937 world, class_2338 targetPos, @Nullable class_2350 facing) {
        if (held.method_7909() instanceof class_1747 && world.method_8320(targetPos).method_26204() == ((class_1747)held.method_7909()).method_7711()) {
            return false;
        }
        class_1792 class_17922 = held.method_7909();
        if (class_17922 instanceof class_1755) {
            class_1755 bucketItem = (class_1755)class_17922;
            class_3611 fluid = bucketItem.field_7905;
            if (fluid != class_3612.field_15906 && world.method_8316(targetPos).method_15772() == fluid) {
                return false;
            }
        }
        return held.method_7960() || facing != class_2350.field_11033 || BlockEntityBehaviour.get((class_1922)world, targetPos, TransportedItemStackHandlerBehaviour.TYPE) == null;
    }

    static void activate(DeployerPlayer player, class_243 vec, class_2338 clickedPos, class_243 extensionVector, DeployerBlockEntity.Mode mode) {
        class_3222 serverPlayer = player.cast();
        HashMultimap attributeModifiers = HashMultimap.create();
        class_1799 stack = serverPlayer.method_6047();
        ((class_9285)stack.method_58695(class_9334.field_49636, (Object)class_9285.field_49326)).comp_2393().forEach(e -> attributeModifiers.put((Object)e.comp_2395(), (Object)e.comp_2396()));
        serverPlayer.method_6127().method_59932((Multimap)attributeModifiers);
        DeployerHandler.activateInner(player, vec, clickedPos, extensionVector, mode);
        serverPlayer.method_6127().method_59935((Multimap)attributeModifiers);
    }

    private static void activateInner(DeployerPlayer player, class_243 vec, class_2338 clickedPos, class_243 extensionVector, DeployerBlockEntity.Mode mode) {
        SandPaperItemComponent component;
        class_1269.class_9860 success;
        class_1799 resultStack;
        class_1269 onItemRightClick;
        class_1269 onItemUse;
        boolean flag1;
        class_3959 rayTraceContext;
        class_3965 result;
        class_3222 serverPlayer = player.cast();
        class_243 rayOrigin = vec.method_1019(extensionVector.method_1021(1.515625));
        class_243 rayTarget = vec.method_1019(extensionVector.method_1021(2.484375));
        serverPlayer.method_5814(rayOrigin.field_1352, rayOrigin.field_1351, rayOrigin.field_1350);
        class_2338 pos = class_2338.method_49638((class_2374)vec);
        class_1799 stack = serverPlayer.method_6047();
        class_1792 item = stack.method_7909();
        class_3218 level = serverPlayer.method_51469();
        List<class_1297> entities = level.method_18467(class_1297.class, new class_238(clickedPos)).stream().filter(e -> !(e instanceof AbstractContraptionEntity)).toList();
        class_1268 hand = class_1268.field_5808;
        if (!entities.isEmpty()) {
            class_1297 entity = entities.get(level.field_9229.method_43048(entities.size()));
            ArrayList capturedDrops = new ArrayList();
            boolean success2 = false;
            AllSynchedDatas.CAPTURE_DROPS.set(entity, Optional.of(capturedDrops));
            if (mode == DeployerBlockEntity.Mode.USE) {
                Object cancelResult = null;
                if (cancelResult == null) {
                    class_1309 livingEntity;
                    if (entity.method_5688((class_1657)serverPlayer, hand).method_23665()) {
                        class_3988 villager;
                        if (entity instanceof class_3988 && (villager = (class_3988)entity).method_8257() == serverPlayer) {
                            villager.method_8259(null);
                        }
                        success2 = true;
                    } else if (entity instanceof class_1309 && stack.method_7920((class_1657)serverPlayer, livingEntity = (class_1309)entity, hand).method_23665()) {
                        success2 = true;
                    }
                }
                if (!success2 && entity instanceof class_1657) {
                    class_4174 foodProperties;
                    class_1657 playerEntity = (class_1657)entity;
                    if (stack.method_57826(class_9334.field_50075) && (foodProperties = (class_4174)stack.method_58694(class_9334.field_50075)) != null && playerEntity.method_7332(foodProperties.comp_2493())) {
                        class_1799 copy = stack.method_7972();
                        serverPlayer.method_6122(hand, stack.method_7910((class_1937)level, (class_1309)playerEntity));
                        player.setSpawnedItemEffects(copy);
                        success2 = true;
                    }
                    if (!success2 && stack.method_31573(AllItemTags.DEPLOYABLE_DRINK)) {
                        player.setSpawnedItemEffects(stack.method_7972());
                        serverPlayer.method_6122(hand, stack.method_7910((class_1937)level, (class_1309)playerEntity));
                        success2 = true;
                    }
                }
            }
            if (mode == DeployerBlockEntity.Mode.PUNCH) {
                serverPlayer.method_7350();
                serverPlayer.method_7324(entity);
                success2 = true;
            }
            AllSynchedDatas.CAPTURE_DROPS.set(entity, Optional.empty());
            capturedDrops.forEach(e -> serverPlayer.method_31548().method_7398(e));
            if (success2) {
                return;
            }
        }
        if ((result = level.method_17742(rayTraceContext = new class_3959(rayOrigin, rayTarget, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)serverPlayer))).method_17777() != clickedPos) {
            result = new class_3965(result.method_17784(), result.method_17780(), clickedPos, result.method_17781());
        }
        class_2680 clickedState = level.method_8320(clickedPos);
        class_2350 face = result.method_17780();
        if (face == null) {
            face = class_2350.method_10142((double)extensionVector.field_1352, (double)extensionVector.field_1351, (double)extensionVector.field_1350).method_10153();
        }
        if (mode == DeployerBlockEntity.Mode.PUNCH) {
            if (!level.method_8505((class_1297)serverPlayer, clickedPos)) {
                return;
            }
            if (clickedState.method_26218((class_1922)level, clickedPos).method_1110()) {
                player.setBlockBreakingProgress(null);
                return;
            }
            if (BlockHelper.extinguishFire((class_1937)level, (class_1657)serverPlayer, clickedPos, face)) {
                return;
            }
            if (stack.method_7960()) {
                return;
            }
            float progress = clickedState.method_26165((class_1657)serverPlayer, (class_1922)level, clickedPos) * 16.0f;
            float before = 0.0f;
            Pair<class_2338, Float> blockBreakingProgress = player.getBlockBreakingProgress();
            if (blockBreakingProgress != null) {
                before = ((Float)blockBreakingProgress.getValue()).floatValue();
            }
            progress += before;
            level.method_8396(null, clickedPos, clickedState.method_26231().method_10596(), class_3419.field_15254, 0.25f, 1.0f);
            if (progress >= 1.0f) {
                DeployerHandler.tryHarvestBlock(player, player.getInteractionManager(), clickedPos);
                level.method_8517(serverPlayer.method_5628(), clickedPos, -1);
                player.setBlockBreakingProgress(null);
                return;
            }
            if (progress <= 0.0f) {
                player.setBlockBreakingProgress(null);
                return;
            }
            if ((int)(before * 10.0f) != (int)(progress * 10.0f)) {
                level.method_8517(serverPlayer.method_5628(), clickedPos, (int)(progress * 10.0f));
            }
            player.setBlockBreakingProgress((Pair<class_2338, Float>)Pair.of((Object)clickedPos, (Object)Float.valueOf(progress)));
            return;
        }
        class_1838 itemusecontext = new class_1838((class_1657)serverPlayer, hand, result);
        boolean holdingSomething = !serverPlayer.method_6047().method_7960();
        boolean bl = flag1 = !serverPlayer.method_5715() || !holdingSomething || !serverPlayer.method_6047().method_7960();
        if (flag1 && DeployerHandler.safeOnUse(clickedState, (class_1937)level, clickedPos, player, hand, result).method_23665()) {
            return;
        }
        if (stack.method_7960()) {
            return;
        }
        if (item instanceof CartAssemblerBlockItem && clickedState.method_26166(new class_1750(itemusecontext))) {
            return;
        }
        if (item == class_1802.field_8884) {
            class_2350 newFace = result.method_17780();
            class_2338 newPos = result.method_17777();
            if (!class_4770.method_30032((class_1937)level, (class_2338)clickedPos, (class_2350)newFace)) {
                newFace = class_2350.field_11036;
            }
            if (clickedState.method_26215()) {
                newPos = newPos.method_10093(face.method_10153());
            }
            result = new class_3965(result.method_17784(), newFace, newPos, result.method_17781());
            itemusecontext = new class_1838((class_1657)serverPlayer, hand, result);
        }
        if ((onItemUse = stack.method_7981(itemusecontext)).method_23665()) {
            class_1747 bi;
            if (item instanceof class_1747 && ((bi = (class_1747)item).method_7711() instanceof class_2241 || bi.method_7711() instanceof ITrackBlock)) {
                player.setPlacedTracks(true);
            }
            return;
        }
        if (item == class_1802.field_8634) {
            return;
        }
        if (item.method_40131().method_40220(AllItemTags.DEPLOYABLE_DRINK)) {
            return;
        }
        Object itemUseWorld = level;
        if (item instanceof class_1755 || item instanceof SandPaperItem) {
            itemUseWorld = new ItemUseWorld(level, face, pos);
        }
        if ((onItemRightClick = item.method_7836((class_1937)itemUseWorld, (class_1657)serverPlayer, hand)).method_23665() && item instanceof class_1785) {
            class_1785 bucketItem = (class_1785)item;
            bucketItem.method_7728((class_1309)serverPlayer, (class_1937)level, stack, clickedPos);
        }
        if (onItemRightClick instanceof class_1269.class_9860 && ((resultStack = (success = (class_1269.class_9860)onItemRightClick).method_61396()) != null && resultStack != stack || resultStack.method_7947() != stack.method_7947() || resultStack.method_7935((class_1309)serverPlayer) > 0 || resultStack.method_7919() != stack.method_7919())) {
            serverPlayer.method_6122(hand, resultStack);
        }
        if (stack.method_7909() instanceof SandPaperItem && (component = (SandPaperItemComponent)stack.method_58694(AllDataComponents.SAND_PAPER_POLISHING)) != null) {
            player.setSpawnedItemEffects(component.item());
            AllSoundEvents.SANDING_SHORT.playOnServer((class_1937)level, (class_2382)pos, 0.25f, 1.0f);
        }
        if (!serverPlayer.method_6030().method_7960()) {
            serverPlayer.method_6122(hand, stack.method_7910((class_1937)level, (class_1309)serverPlayer));
        }
        serverPlayer.method_6021();
    }

    public static boolean tryHarvestBlock(DeployerPlayer player, class_3225 interactionManager, class_2338 pos) {
        class_3222 serverPlayer = player.cast();
        class_3218 world = serverPlayer.method_51469();
        class_2680 blockstate = world.method_8320(pos);
        class_1934 gameType = interactionManager.method_14257();
        class_2586 blockEntity = world.method_8321(pos);
        if (serverPlayer.method_21701((class_1937)world, pos, gameType)) {
            return false;
        }
        class_1799 prevHeldItem = serverPlayer.method_6047();
        class_1799 heldItem = prevHeldItem.method_7972();
        boolean canHarvest = serverPlayer.method_7305(blockstate) && serverPlayer.method_7294();
        prevHeldItem.method_7952((class_1937)world, blockstate, pos, (class_1657)player.cast());
        class_2338 posUp = pos.method_10084();
        class_2680 stateUp = world.method_8320(posUp);
        if (blockstate.method_26204() instanceof class_2320 && blockstate.method_11654((class_2769)class_2320.field_10929) == class_2756.field_12607 && stateUp.method_26204() == blockstate.method_26204() && stateUp.method_11654((class_2769)class_2320.field_10929) == class_2756.field_12609) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 35);
            world.method_8652(posUp, class_2246.field_10124.method_9564(), 35);
        } else {
            blockstate.method_26204().method_9576((class_1937)world, pos, blockstate, (class_1657)player.cast());
            if (!world.method_8652(pos, world.method_8316(pos).method_15772().method_15785().method_15759(), world.method_8608() ? 11 : 3)) {
                return true;
            }
        }
        blockstate.method_26204().method_9585((class_1936)world, pos, blockstate);
        if (!canHarvest) {
            return true;
        }
        class_2248.method_9609((class_2680)blockstate, (class_3218)world, (class_2338)pos, (class_2586)blockEntity, (class_1297)player.cast(), (class_1799)prevHeldItem).forEach(item -> serverPlayer.method_31548().method_7398(item));
        blockstate.method_26180(world, pos, prevHeldItem, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_1269 safeOnUse(class_2680 state, class_1937 world, class_2338 pos, DeployerPlayer player, class_1268 hand, class_3965 ray) {
        ArrayList drops = new ArrayList(4);
        CAPTURED_BLOCK_DROPS.put(pos, drops);
        try {
            class_1269 result = BlockHelper.invokeUse(state, world, (class_1657)player.cast(), hand, ray);
            for (class_1542 itemEntity : drops) {
                player.cast().method_31548().method_7398(itemEntity.method_6983());
            }
            class_1269 class_12692 = result;
            return class_12692;
        }
        finally {
            CAPTURED_BLOCK_DROPS.remove(pos);
        }
    }

    private static final class ItemUseWorld
    extends WrappedLevel
    implements class_5425 {
        private final class_2350 face;
        private final class_2338 pos;
        boolean rayMode = false;

        private ItemUseWorld(class_3218 level, class_2350 face, class_2338 pos) {
            super((class_1937)level);
            this.face = face;
            this.pos = pos;
        }

        public class_1266 method_8404(class_2338 pos) {
            return this.method_8410().method_8404(pos);
        }

        public class_3218 method_8410() {
            return (class_3218)this.level;
        }

        public class_3965 method_17742(class_3959 context) {
            this.rayMode = true;
            class_3965 rayTraceBlocks = super.method_17742(context);
            this.rayMode = false;
            return rayTraceBlocks;
        }

        @Override
        public class_2680 method_8320(class_2338 position) {
            if (this.rayMode && (this.pos.method_10079(this.face.method_10153(), 3).equals((Object)position) || this.pos.method_10079(this.face.method_10153(), 1).equals((Object)position))) {
                return class_2246.field_9987.method_9564();
            }
            return this.level.method_8320(position);
        }
    }
}

