/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.simpleRelays;

import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public class CogwheelBlockItem
extends class_1747 {
    boolean large;
    private final int placementHelperId;
    private final int integratedCogHelperId;

    public CogwheelBlockItem(CogWheelBlock block, class_1792.class_1793 builder) {
        super((class_2248)block, builder);
        this.large = block.isLarge;
        this.placementHelperId = PlacementHelpers.register(this.large ? new LargeCogHelper() : new SmallCogHelper());
        this.integratedCogHelperId = PlacementHelpers.register(this.large ? new IntegratedLargeCogHelper() : new IntegratedSmallCogHelper());
    }

    public static class_1269 onItemUseFirst(class_1937 world, class_1657 player, class_1799 stack, class_1268 hand, class_3965 ray, class_2338 pos) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof CogwheelBlockItem) {
            class_2680 state;
            CogwheelBlockItem item = (CogwheelBlockItem)class_17922;
            IPlacementHelper helper = PlacementHelpers.get(item.placementHelperId);
            if (helper.matchesState(state = world.method_8320(pos)) && player != null && !player.method_5715()) {
                class_1269 result = helper.getOffset(player, world, state, pos, ray).placeInWorld(world, item, player, hand);
                if (result != class_1269.field_52423) {
                    return result;
                }
            } else if (item.integratedCogHelperId != -1 && (helper = PlacementHelpers.get(item.integratedCogHelperId)).matchesState(state) && player != null && !player.method_5715()) {
                return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, item, player, hand);
            }
        }
        return null;
    }

    private static class LargeCogHelper
    extends DiagonalCogHelper {
        private LargeCogHelper() {
        }

        @Override
        public Predicate<class_1799> getItemPredicate() {
            return ((Predicate<class_1799>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (ICogWheel.isLargeCog(state)) {
                class_2350.class_2351 axis = ((IRotate)state.method_26204()).getRotationAxis(state);
                class_2350 side = IPlacementHelper.orderedByDistanceOnlyAxis(pos, ray.method_17784(), axis).get(0);
                List<class_2350> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.method_17784(), axis);
                for (class_2350 dir : directions) {
                    class_2338 newPos = pos.method_10093(dir).method_10093(side);
                    if (!CogWheelBlock.isValidCogwheelPosition(true, (class_4538)world, newPos, dir.method_10166()) || !world.method_8320(newPos).method_45474()) continue;
                    return PlacementOffset.success((class_2382)newPos, s -> (class_2680)s.method_11657((class_2769)class_2741.field_12496, (Comparable)dir.method_10166()));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, world, state, pos, ray);
        }
    }

    private static class SmallCogHelper
    extends DiagonalCogHelper {
        private SmallCogHelper() {
        }

        @Override
        public Predicate<class_1799> getItemPredicate() {
            return ((Predicate<class_1799>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (!ICogWheel.isLargeCog(state)) {
                class_2350.class_2351 axis = ((IRotate)state.method_26204()).getRotationAxis(state);
                List<class_2350> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.method_17784(), axis);
                for (class_2350 dir : directions) {
                    class_2338 newPos = pos.method_10093(dir);
                    if (!CogWheelBlock.isValidCogwheelPosition(false, (class_4538)world, newPos, axis) || !world.method_8320(newPos).method_45474()) continue;
                    return PlacementOffset.success((class_2382)newPos, s -> (class_2680)s.method_11657((class_2769)class_2741.field_12496, (Comparable)axis));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, world, state, pos, ray);
        }
    }

    public static class IntegratedLargeCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<class_1799> getItemPredicate() {
            return ((Predicate<class_1799>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public Predicate<class_2680> getStatePredicate() {
            return s -> !ICogWheel.isDedicatedCogWheel(s.method_26204()) && ICogWheel.isSmallCog(s);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            class_2350 face = ray.method_17780();
            class_2350.class_2351 newAxis = state.method_28498(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((class_2350)state.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)).method_10166() : (state.method_28498(DirectionalKineticBlock.FACING) ? ((class_2350)state.method_11654(DirectionalKineticBlock.FACING)).method_10166() : (state.method_28498(RotatedPillarKineticBlock.AXIS) ? (class_2350.class_2351)state.method_11654(RotatedPillarKineticBlock.AXIS) : class_2350.class_2351.field_11052));
            if (face.method_10166() == newAxis) {
                return PlacementOffset.fail();
            }
            List<class_2350> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.method_17784(), face.method_10166(), newAxis);
            for (class_2350 d : directions) {
                class_2338 newPos = pos.method_10093(face).method_10093(d);
                if (!world.method_8320(newPos).method_45474()) continue;
                if (!CogWheelBlock.isValidCogwheelPosition(false, (class_4538)world, newPos, newAxis)) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success((class_2382)newPos, s -> (class_2680)s.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)newAxis));
            }
            return PlacementOffset.fail();
        }
    }

    public static class IntegratedSmallCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<class_1799> getItemPredicate() {
            return ((Predicate<class_1799>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public Predicate<class_2680> getStatePredicate() {
            return s -> !ICogWheel.isDedicatedCogWheel(s.method_26204()) && ICogWheel.isSmallCog(s);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            class_2350 face = ray.method_17780();
            class_2350.class_2351 newAxis = state.method_28498(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((class_2350)state.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)).method_10166() : (state.method_28498(DirectionalKineticBlock.FACING) ? ((class_2350)state.method_11654(DirectionalKineticBlock.FACING)).method_10166() : (state.method_28498(RotatedPillarKineticBlock.AXIS) ? (class_2350.class_2351)state.method_11654(RotatedPillarKineticBlock.AXIS) : class_2350.class_2351.field_11052));
            if (face.method_10166() == newAxis) {
                return PlacementOffset.fail();
            }
            List<class_2350> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.method_17784(), newAxis);
            for (class_2350 d : directions) {
                class_2338 newPos = pos.method_10093(d);
                if (!world.method_8320(newPos).method_45474()) continue;
                if (!CogWheelBlock.isValidCogwheelPosition(false, (class_4538)world, newPos, newAxis)) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success().at((class_2382)newPos).withTransform(s -> (class_2680)s.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)newAxis));
            }
            return PlacementOffset.fail();
        }
    }

    public static abstract class DiagonalCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<class_2680> getStatePredicate() {
            return s -> ICogWheel.isSmallCog(s) || ICogWheel.isLargeCog(s);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            class_2350.class_2351 axis = ((IRotate)state.method_26204()).getRotationAxis(state);
            class_2350 closest = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.method_17784(), axis).getFirst();
            List<class_2350> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.method_17784(), axis, (class_2350 d) -> d.method_10166() != closest.method_10166());
            for (class_2350 dir : directions) {
                class_2338 newPos = pos.method_10093(dir).method_10093(closest);
                if (!world.method_8320(newPos).method_45474() || !CogWheelBlock.isValidCogwheelPosition(ICogWheel.isLargeCog(state), (class_4538)world, newPos, axis)) continue;
                return PlacementOffset.success((class_2382)newPos, s -> (class_2680)s.method_11657((class_2769)class_2741.field_12496, (Comparable)axis));
            }
            return PlacementOffset.fail();
        }

        protected boolean hitOnShaft(class_2680 state, class_3965 ray) {
            return AllShapes.SIX_VOXEL_POLE.get(((IRotate)state.method_26204()).getRotationAxis(state)).method_1107().method_1014(0.001).method_1006(ray.method_17784().method_1020(ray.method_17784().method_1032(Iterate.axisSet)));
        }
    }
}

