/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.factoryBoard;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.PanelSlot;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.repackager.RepackagerBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class FactoryPanelBlockEntity
extends SmartBlockEntity {
    public EnumMap<PanelSlot, ServerFactoryPanelBehaviour> panels;
    public boolean redraw;
    public boolean restocker = false;
    public class_265 lastShape;

    public FactoryPanelBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.FACTORY_PANEL, pos, state);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1014(8.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.panels = new EnumMap(PanelSlot.class);
        this.redraw = true;
        for (PanelSlot slot : PanelSlot.values()) {
            ServerFactoryPanelBehaviour e = new ServerFactoryPanelBehaviour(this, slot);
            this.panels.put(slot, e);
            behaviours.add(e);
        }
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.FACTORY_GAUGE);
    }

    @Override
    public void lazyTick() {
        class_2680 state;
        super.lazyTick();
        if (this.field_11863.method_8608()) {
            return;
        }
        if (this.activePanels() == 0) {
            this.field_11863.method_8501(this.field_11867, class_2246.field_10124.method_9564());
        }
        if ((state = this.method_11010()).method_27852((class_2248)AllBlocks.FACTORY_GAUGE)) {
            boolean shouldBeRestocker = this.field_11863.method_8320(this.field_11867.method_10093(FactoryPanelBlock.connectedDirection(state).method_10153())).method_27852((class_2248)AllBlocks.PACKAGER);
            if (this.restocker == shouldBeRestocker) {
                return;
            }
            this.restocker = shouldBeRestocker;
            this.redraw = true;
            this.sendData();
        }
    }

    @Nullable
    public PackagerBlockEntity getRestockedPackager() {
        class_2680 state = this.method_11010();
        if (!this.restocker || !state.method_27852((class_2248)AllBlocks.FACTORY_GAUGE)) {
            return null;
        }
        class_2338 packagerPos = this.field_11867.method_10093(FactoryPanelBlock.connectedDirection(state).method_10153());
        if (!this.field_11863.method_8477(packagerPos)) {
            return null;
        }
        class_2586 be = this.field_11863.method_8321(packagerPos);
        if (!(be instanceof PackagerBlockEntity)) {
            return null;
        }
        PackagerBlockEntity pbe = (PackagerBlockEntity)be;
        if (pbe instanceof RepackagerBlockEntity) {
            return null;
        }
        return pbe;
    }

    public int activePanels() {
        int result = 0;
        for (ServerFactoryPanelBehaviour panelBehaviour : this.panels.values()) {
            if (!panelBehaviour.isActive()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void remove() {
        for (ServerFactoryPanelBehaviour panelBehaviour : this.panels.values()) {
            if (!panelBehaviour.isActive()) continue;
            panelBehaviour.disconnectAll();
        }
        super.remove();
    }

    @Override
    public void destroy() {
        super.destroy();
        int panelCount = this.activePanels();
        if (panelCount > 1) {
            class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)new class_1799((class_1935)AllItems.FACTORY_GAUGE, panelCount - 1));
        }
    }

    public boolean addPanel(PanelSlot slot, UUID frequency) {
        ServerFactoryPanelBehaviour behaviour = this.panels.get((Object)slot);
        if (behaviour != null && !behaviour.isActive()) {
            behaviour.enable();
            if (frequency != null) {
                behaviour.setNetwork(frequency);
            }
            this.redraw = true;
            this.lastShape = null;
            if (this.activePanels() > 1) {
                class_2498 soundType = this.method_11010().method_26231();
                this.field_11863.method_8396(null, this.field_11867, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public boolean removePanel(PanelSlot slot) {
        ServerFactoryPanelBehaviour behaviour = this.panels.get((Object)slot);
        if (behaviour != null && behaviour.isActive()) {
            behaviour.disable();
            this.redraw = true;
            this.lastShape = null;
            if (this.activePanels() > 0) {
                class_2498 soundType = this.method_11010().method_26231();
                this.field_11863.method_8396(null, this.field_11867, soundType.method_10595(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public class_265 getShape() {
        if (this.lastShape != null) {
            return this.lastShape;
        }
        float xRot = 57.295776f * FactoryPanelBlock.getXRot(this.method_11010()) + 90.0f;
        float yRot = 57.295776f * FactoryPanelBlock.getYRot(this.method_11010());
        class_2350 connectedDirection = FactoryPanelBlock.connectedDirection(this.method_11010());
        class_243 inflateAxes = VecHelper.axisAlingedPlaneOf(connectedDirection);
        this.lastShape = class_259.method_1073();
        for (ServerFactoryPanelBehaviour behaviour : this.panels.values()) {
            if (!behaviour.isActive()) continue;
            FactoryPanelPosition panelPosition = behaviour.getPanelPosition();
            class_243 vec = new class_243(0.25 + (double)panelPosition.slot().xOffset * 0.5, 0.0625, 0.25 + (double)panelPosition.slot().yOffset * 0.5);
            vec = VecHelper.rotateCentered(vec, 180.0, class_2350.class_2351.field_11052);
            vec = VecHelper.rotateCentered(vec, xRot, class_2350.class_2351.field_11048);
            vec = VecHelper.rotateCentered(vec, yRot, class_2350.class_2351.field_11052);
            class_238 bb = new class_238(vec, vec).method_1014(0.0625).method_1009(inflateAxes.field_1352 * 3.0 / 16.0, inflateAxes.field_1351 * 3.0 / 16.0, inflateAxes.field_1350 * 3.0 / 16.0);
            this.lastShape = class_259.method_1084((class_265)this.lastShape, (class_265)class_259.method_1078((class_238)bb));
        }
        return this.lastShape;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.restocker = view.method_71433("Restocker", false);
        if (clientPacket && view.method_71433("Redraw", false)) {
            this.lastShape = null;
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71472("Restocker", this.restocker);
        if (clientPacket && this.redraw) {
            view.method_71472("Redraw", true);
            this.redraw = false;
        }
    }
}

