/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.basin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.content.processing.basin.BasinOperatingBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.fluids.SidedFluidInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasinBlockEntity
extends SmartBlockEntity {
    public boolean areFluidsMoving = false;
    LerpedFloat ingredientRotationSpeed;
    public LerpedFloat ingredientRotation;
    public SmartFluidTankBehaviour inputTank;
    protected SmartFluidTankBehaviour outputTank;
    private ServerFilteringBehaviour filtering;
    private boolean contentsChanged = true;
    private Couple<SmartFluidTankBehaviour> tanks;
    public BasinInventory itemCapability = new BasinInventory(this);
    public BasinFluidHandler fluidCapability;
    List<class_2350> disabledSpoutputs;
    class_2350 preferredSpoutput = null;
    protected List<class_1799> spoutputBuffer;
    protected List<FluidStack> spoutputFluidBuffer;
    int recipeBackupCheck = 20;
    public static final int OUTPUT_ANIMATION_TIME = 10;
    public List<IntAttached<class_1799>> visualizedOutputItems;
    public List<IntAttached<FluidStack>> visualizedOutputFluids;
    @Nullable
    private BlazeBurnerBlock.HeatLevel cachedHeatLevel;

    public BasinBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.BASIN, pos, state);
        this.ingredientRotation = LerpedFloat.angular().startWithValue(0.0);
        this.ingredientRotationSpeed = LerpedFloat.linear().startWithValue(0.0);
        this.tanks = Couple.create(this.inputTank, this.outputTank);
        this.visualizedOutputItems = Collections.synchronizedList(new ArrayList());
        this.visualizedOutputFluids = Collections.synchronizedList(new ArrayList());
        this.disabledSpoutputs = new ArrayList<class_2350>();
        this.spoutputBuffer = new ArrayList<class_1799>();
        this.spoutputFluidBuffer = new ArrayList<FluidStack>();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this));
        this.filtering = new ServerFilteringBehaviour(this).withCallback(newFilter -> {
            this.contentsChanged = true;
        }).forRecipes();
        behaviours.add(this.filtering);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, this, 2, 81000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, this, 2, 81000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add(this.inputTank);
        behaviours.add(this.outputTank);
        this.fluidCapability = new BasinFluidHandler(this.outputTank.getTanks(), this.inputTank.getTanks());
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.itemCapability.read(view);
        this.preferredSpoutput = view.method_71426("PreferredSpoutput", (Codec)class_2350.field_29502).orElse(null);
        this.disabledSpoutputs.clear();
        this.spoutputBuffer.clear();
        this.spoutputFluidBuffer.clear();
        view.method_71426("DisabledSpoutput", CreateCodecs.DIRECTION_LIST_CODEC).ifPresent(this.disabledSpoutputs::addAll);
        view.method_71426("Overflow", CreateCodecs.ITEM_LIST_CODEC).ifPresent(this.spoutputBuffer::addAll);
        view.method_71426("FluidOverflow", CreateCodecs.FLUID_LIST_CODEC).ifPresent(this.spoutputFluidBuffer::addAll);
        if (!clientPacket) {
            return;
        }
        view.method_71437("VisualizedItems", class_1799.field_49266).method_71456().forEach(stack -> this.visualizedOutputItems.add(IntAttached.with(10, stack)));
        view.method_71437("VisualizedFluids", FluidStack.OPTIONAL_CODEC).method_71456().forEach(stack -> this.visualizedOutputFluids.add(IntAttached.with(10, stack)));
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        this.itemCapability.write(view);
        if (this.preferredSpoutput != null) {
            view.method_71468("PreferredSpoutput", (Codec)class_2350.field_29502, (Object)this.preferredSpoutput);
        }
        view.method_71468("DisabledSpoutput", CreateCodecs.DIRECTION_LIST_CODEC, this.disabledSpoutputs);
        view.method_71468("Overflow", CreateCodecs.ITEM_LIST_CODEC, this.spoutputBuffer);
        view.method_71468("FluidOverflow", CreateCodecs.FLUID_LIST_CODEC, this.spoutputFluidBuffer);
        if (!clientPacket) {
            return;
        }
        class_11372.class_11373 items = view.method_71467("VisualizedItems", class_1799.field_49266);
        this.visualizedOutputItems.stream().map(IntAttached::getValue).forEach(arg_0 -> ((class_11372.class_11373)items).method_71484(arg_0));
        class_11372.class_11373 fluids = view.method_71467("VisualizedFluids", FluidStack.OPTIONAL_CODEC);
        this.visualizedOutputFluids.stream().map(IntAttached::getValue).forEach(arg_0 -> ((class_11372.class_11373)fluids).method_71484(arg_0));
        this.visualizedOutputItems.clear();
        this.visualizedOutputFluids.clear();
    }

    @Override
    public void destroy() {
        super.destroy();
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1263)this.itemCapability);
        this.spoutputBuffer.forEach(is -> class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)is));
    }

    @Override
    public void remove() {
        super.remove();
        this.onEmptied();
    }

    public void onEmptied() {
        this.getOperator().ifPresent(be -> {
            be.basinRemoved = true;
        });
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (!this.field_11863.method_8608()) {
            this.updateSpoutput();
            if (this.recipeBackupCheck-- > 0) {
                return;
            }
            this.recipeBackupCheck = 20;
            if (this.isEmpty()) {
                return;
            }
            this.notifyChangeOfContents();
            return;
        }
        class_2586 blockEntity = this.field_11863.method_8321(this.field_11867.method_10086(2));
        if (!(blockEntity instanceof MechanicalMixerBlockEntity)) {
            this.setAreFluidsMoving(false);
            return;
        }
        MechanicalMixerBlockEntity mixer = (MechanicalMixerBlockEntity)blockEntity;
    }

    public boolean isEmpty() {
        return this.itemCapability.method_5442() && this.inputTank.isEmpty() && this.outputTank.isEmpty();
    }

    public void onWrenched(class_2350 face) {
        class_2680 blockState = this.method_11010();
        class_2350 currentFacing = (class_2350)blockState.method_11654(BasinBlock.FACING);
        this.disabledSpoutputs.remove(face);
        if (currentFacing == face) {
            if (this.preferredSpoutput == face) {
                this.preferredSpoutput = null;
            }
            this.disabledSpoutputs.add(face);
        } else {
            this.preferredSpoutput = face;
        }
        this.updateSpoutput();
    }

    private void updateSpoutput() {
        class_2680 blockState = this.method_11010();
        class_2350 currentFacing = (class_2350)blockState.method_11654(BasinBlock.FACING);
        class_2350 newFacing = class_2350.field_11033;
        for (class_2350 test : Iterate.horizontalDirections) {
            boolean canOutputTo = BasinBlock.canOutputTo((class_1922)this.field_11863, this.field_11867, test);
            if (!canOutputTo || this.disabledSpoutputs.contains(test)) continue;
            newFacing = test;
        }
        if (this.preferredSpoutput != null && BasinBlock.canOutputTo((class_1922)this.field_11863, this.field_11867, this.preferredSpoutput) && this.preferredSpoutput != class_2350.field_11036) {
            newFacing = this.preferredSpoutput;
        }
        if (newFacing == currentFacing) {
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_11657(BasinBlock.FACING, (Comparable)newFacing));
        if (newFacing.method_10166().method_10178()) {
            return;
        }
        for (int slot = 9; slot < 18; ++slot) {
            class_1799 stack = this.itemCapability.method_5438(slot);
            if (stack.method_7960() || !this.acceptOutputs((List<class_1799>)ImmutableList.of((Object)stack), Collections.emptyList(), true)) continue;
            this.acceptOutputs((List<class_1799>)ImmutableList.of((Object)stack), Collections.emptyList(), false);
            this.itemCapability.method_5447(slot, class_1799.field_8037);
        }
        SidedFluidInventory handler = this.outputTank.getCapability();
        for (int slot = 0; slot < 2; ++slot) {
            FluidStack fs = handler.getStack(slot);
            if (fs.isEmpty()) continue;
            fs = fs.copy();
            if (!this.acceptOutputs(Collections.emptyList(), (List<FluidStack>)ImmutableList.of((Object)fs), true)) continue;
            handler.setStack(slot, FluidStack.EMPTY);
            this.acceptOutputs(Collections.emptyList(), (List<FluidStack>)ImmutableList.of((Object)fs), false);
        }
        this.notifyChangeOfContents();
        this.notifyUpdate();
    }

    @Override
    public void tick() {
        this.cachedHeatLevel = null;
        super.tick();
        if (this.field_11863.method_8608()) {
            AllClientHandle.INSTANCE.createBasinFluidParticles(this.field_11863, this);
            this.tickVisualizedOutputs();
            this.ingredientRotationSpeed.tickChaser();
            this.ingredientRotation.setValue(this.ingredientRotation.getValue() + this.ingredientRotationSpeed.getValue());
        }
        if (!(this.spoutputBuffer.isEmpty() && this.spoutputFluidBuffer.isEmpty() || this.field_11863.method_8608())) {
            this.tryClearingSpoutputOverflow();
        }
        if (!this.contentsChanged) {
            return;
        }
        this.contentsChanged = false;
        this.getOperator().ifPresent(be -> be.basinChecker.scheduleUpdate());
        for (class_2350 offset : Iterate.horizontalDirections) {
            class_2586 be2;
            class_2338 toUpdate = this.field_11867.method_10084().method_10093(offset);
            class_2680 stateToUpdate = this.field_11863.method_8320(toUpdate);
            if (!(stateToUpdate.method_26204() instanceof BasinBlock) || stateToUpdate.method_11654(BasinBlock.FACING) != offset.method_10153() || !((be2 = this.field_11863.method_8321(toUpdate)) instanceof BasinBlockEntity)) continue;
            ((BasinBlockEntity)be2).contentsChanged = true;
        }
    }

    private void tryClearingSpoutputOverflow() {
        class_1263 targetInv;
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof BasinBlock)) {
            return;
        }
        class_2350 direction = (class_2350)blockState.method_11654(BasinBlock.FACING);
        class_2586 be = this.field_11863.method_8321(this.field_11867.method_10074().method_10093(direction));
        ServerFilteringBehaviour filter = null;
        InvManipulationBehaviour inserter = null;
        if (be != null) {
            filter = BlockEntityBehaviour.get((class_1922)this.field_11863, be.method_11016(), ServerFilteringBehaviour.TYPE);
            inserter = BlockEntityBehaviour.get((class_1922)this.field_11863, be.method_11016(), InvManipulationBehaviour.TYPE);
        }
        if (filter != null && filter.isRecipeFilter()) {
            filter = null;
        }
        class_2350 opposite = direction.method_10153();
        class_1263 class_12632 = targetInv = be == null ? null : ItemHelper.getInventory(this.field_11863, be.method_11016(), null, be, opposite);
        if (targetInv == null && inserter != null) {
            targetInv = (class_1263)inserter.getInventory();
        }
        FluidInventory targetTank = be == null ? null : FluidHelper.getFluidInventory(this.field_11863, be.method_11016(), null, be, opposite);
        boolean update = false;
        Iterator<Object> iterator = this.spoutputBuffer.iterator();
        while (iterator.hasNext()) {
            class_1799 itemStack = iterator.next();
            if (direction == class_2350.field_11033) {
                class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)itemStack);
                iterator.remove();
                update = true;
                continue;
            }
            if (targetInv == null) break;
            if (targetInv.countSpace(itemStack, 1) == 0 || filter != null && !filter.test(itemStack)) continue;
            if (this.visualizedOutputItems.size() < 3) {
                this.visualizedOutputItems.add(IntAttached.withZero(itemStack));
            }
            update = true;
            int count = itemStack.method_7947();
            int insert = targetInv.insertExist(itemStack, opposite);
            if (insert == count) {
                iterator.remove();
                continue;
            }
            itemStack.method_7934(insert);
        }
        iterator = this.spoutputFluidBuffer.iterator();
        while (iterator.hasNext()) {
            FluidStack fluidStack = (FluidStack)iterator.next();
            if (direction == class_2350.field_11033) {
                iterator.remove();
                update = true;
                continue;
            }
            if (targetTank == null) break;
            if (targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? !targetTank.forcePreciseInsert(fluidStack) : !targetTank.preciseInsert(fluidStack, opposite)) continue;
            update = true;
            iterator.remove();
            if (this.visualizedOutputFluids.size() >= 3) continue;
            this.visualizedOutputFluids.add(IntAttached.withZero(fluidStack));
        }
        if (update) {
            this.notifyChangeOfContents();
            this.sendData();
        }
    }

    public float getTotalFluidUnits(float partialTicks) {
        int renderedFluids = 0;
        float totalUnits = 0.0f;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                totalUnits += units;
                ++renderedFluids;
            }
        }
        if (renderedFluids == 0) {
            return 0.0f;
        }
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        return totalUnits;
    }

    private Optional<BasinOperatingBlockEntity> getOperator() {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        class_2586 be = this.field_11863.method_8321(this.field_11867.method_10086(2));
        if (be instanceof BasinOperatingBlockEntity) {
            return Optional.of((BasinOperatingBlockEntity)be);
        }
        return Optional.empty();
    }

    public ServerFilteringBehaviour getFilter() {
        return this.filtering;
    }

    public void notifyChangeOfContents() {
        this.contentsChanged = true;
    }

    public boolean canContinueProcessing() {
        return this.spoutputBuffer.isEmpty() && this.spoutputFluidBuffer.isEmpty();
    }

    public boolean acceptOutputs(List<class_1799> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        this.itemCapability.disableCheck();
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, outputFluids, simulate);
        this.itemCapability.enableCheck();
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<class_1799> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof BasinBlock)) {
            return false;
        }
        class_2350 direction = (class_2350)blockState.method_11654(BasinBlock.FACING);
        if (direction != class_2350.field_11033) {
            boolean externalTankNotPresent;
            class_1263 targetInv;
            class_2586 be = this.field_11863.method_8321(this.field_11867.method_10074().method_10093(direction));
            InvManipulationBehaviour inserter = be == null ? null : BlockEntityBehaviour.get((class_1922)this.field_11863, be.method_11016(), InvManipulationBehaviour.TYPE);
            class_2350 opposite = direction.method_10153();
            class_1263 class_12632 = targetInv = be == null ? null : ItemHelper.getInventory(this.field_11863, be.method_11016(), null, be, opposite);
            if (targetInv == null && inserter != null) {
                targetInv = (class_1263)inserter.getInventory();
            }
            FluidInventory targetTank = be == null ? null : FluidHelper.getFluidInventory(this.field_11863, be.method_11016(), null, be, opposite);
            boolean bl = externalTankNotPresent = targetTank == null;
            if (!outputItems.isEmpty() && targetInv == null) {
                return false;
            }
            if (!outputFluids.isEmpty() && externalTankNotPresent) {
                targetTank = this.outputTank.getCapability();
                if (targetTank == null) {
                    return false;
                }
                if (!this.acceptFluidOutputsIntoBasin(outputFluids, simulate, targetTank)) {
                    return false;
                }
            }
            if (simulate) {
                return true;
            }
            for (class_1799 itemStack : outputItems) {
                if (itemStack.method_7960()) continue;
                this.spoutputBuffer.add(itemStack.method_7972());
            }
            if (!externalTankNotPresent) {
                for (FluidStack fluidStack : outputFluids) {
                    this.spoutputFluidBuffer.add(fluidStack.copy());
                }
            }
            return true;
        }
        if (!this.acceptItemOutputsIntoBasin(outputItems, simulate, this.itemCapability)) {
            return false;
        }
        if (outputFluids.isEmpty()) {
            return true;
        }
        return this.acceptFluidOutputsIntoBasin(outputFluids, simulate, this.outputTank.getCapability());
    }

    private boolean acceptFluidOutputsIntoBasin(List<FluidStack> outputFluids, boolean simulate, FluidInventory targetTank) {
        if (simulate) {
            return targetTank.countSpace(outputFluids);
        }
        targetTank.insert(outputFluids);
        return true;
    }

    private boolean acceptItemOutputsIntoBasin(List<class_1799> outputItems, boolean simulate, class_1263 targetInv) {
        if (simulate) {
            return targetInv.countSpace(outputItems, 9, 17);
        }
        targetInv.insert(outputItems, 9, 17);
        return true;
    }

    public void readOnlyItems(class_11368 view) {
        this.itemCapability.read(view);
    }

    public static BlazeBurnerBlock.HeatLevel getHeatLevelOf(class_2680 state) {
        if (state.method_28498(BlazeBurnerBlock.HEAT_LEVEL)) {
            return (BlazeBurnerBlock.HeatLevel)((Object)state.method_11654(BlazeBurnerBlock.HEAT_LEVEL));
        }
        return state.method_26164(AllBlockTags.PASSIVE_BOILER_HEATERS) && BlockHelper.isNotUnheated(state) ? BlazeBurnerBlock.HeatLevel.SMOULDERING : BlazeBurnerBlock.HeatLevel.NONE;
    }

    public Couple<SmartFluidTankBehaviour> getTanks() {
        return this.tanks;
    }

    private void tickVisualizedOutputs() {
        this.visualizedOutputFluids.forEach(IntAttached::decrement);
        this.visualizedOutputItems.forEach(IntAttached::decrement);
        this.visualizedOutputFluids.removeIf(IntAttached::isOrBelowZero);
        this.visualizedOutputItems.removeIf(IntAttached::isOrBelowZero);
    }

    public boolean setAreFluidsMoving(boolean areFluidsMoving) {
        this.areFluidsMoving = areFluidsMoving;
        this.ingredientRotationSpeed.chase(areFluidsMoving ? 20.0 : 0.0, 0.1f, LerpedFloat.Chaser.EXP);
        return areFluidsMoving;
    }

    @NotNull
    BlazeBurnerBlock.HeatLevel getHeatLevel() {
        if (this.cachedHeatLevel == null) {
            if (this.field_11863 == null) {
                return BlazeBurnerBlock.HeatLevel.NONE;
            }
            this.cachedHeatLevel = BasinBlockEntity.getHeatLevelOf(this.field_11863.method_8320(this.method_11016().method_10087(1)));
        }
        return this.cachedHeatLevel;
    }

    public static class BasinFluidHandler
    implements FluidInventory {
        private static final Optional<Integer> LIMIT = Optional.of(81000);
        private final SmartFluidTankBehaviour.TankSegment[] output;
        private final SmartFluidTankBehaviour.TankSegment[] input;

        public BasinFluidHandler(SmartFluidTankBehaviour.TankSegment[] output, SmartFluidTankBehaviour.TankSegment[] input) {
            this.output = output;
            this.input = input;
        }

        @Override
        public int getMaxAmountPerStack() {
            return 81000;
        }

        @Override
        public FluidStack onExtract(FluidStack stack) {
            return this.removeMaxSize(stack, LIMIT);
        }

        @Override
        public boolean isValid(int slot, FluidStack stack) {
            if (slot < 2) {
                return false;
            }
            int size = this.input.length;
            int current = slot - 2;
            for (int i = 0; i < size; ++i) {
                FluidStack fluid = this.input[i].getFluid();
                if (fluid.isEmpty() || !this.matches(fluid, stack) || i == current) continue;
                return false;
            }
            return true;
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public FluidStack getStack(int slot) {
            if (slot >= 4) {
                return FluidStack.EMPTY;
            }
            return slot < 2 ? this.output[slot].getFluid() : this.input[slot - 2].getFluid();
        }

        @Override
        public void setStack(int slot, FluidStack stack) {
            if (slot >= 4) {
                return;
            }
            SmartFluidTankBehaviour.TankSegment tank = slot < 2 ? this.output[slot] : this.input[slot - 2];
            tank.setFluid(stack);
        }

        @Override
        public void markDirty() {
            for (SmartFluidTankBehaviour.TankSegment tank : this.input) {
                tank.markDirty();
            }
            for (SmartFluidTankBehaviour.TankSegment tank : this.output) {
                tank.markDirty();
            }
        }
    }
}

