/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.schematics;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.schematics.SchematicItem;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public class SchematicInstances {
    private static final WorldAttached<Cache<Integer, SchematicLevel>> LOADED_SCHEMATICS = new WorldAttached<Cache>($ -> CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build());

    @Nullable
    public static SchematicLevel get(class_1937 world, class_1799 schematic) {
        int hash;
        Cache<Integer, SchematicLevel> map = LOADED_SCHEMATICS.get((class_1936)world);
        SchematicLevel ifPresent = (SchematicLevel)map.getIfPresent((Object)(hash = SchematicInstances.getHash(schematic)));
        if (ifPresent != null) {
            return ifPresent;
        }
        SchematicLevel loadWorld = SchematicInstances.loadWorld(world, schematic);
        if (loadWorld == null) {
            return null;
        }
        map.put((Object)hash, (Object)loadWorld);
        return loadWorld;
    }

    private static SchematicLevel loadWorld(class_1937 wrapped, class_1799 schematic) {
        if (schematic == null || !schematic.method_57826(AllDataComponents.SCHEMATIC_FILE)) {
            return null;
        }
        if (!schematic.method_57826(AllDataComponents.SCHEMATIC_DEPLOYED)) {
            return null;
        }
        class_3499 activeTemplate = SchematicItem.loadSchematic(wrapped, schematic);
        if (activeTemplate.method_15160().equals((Object)class_2382.field_11176)) {
            return null;
        }
        class_2338 anchor = (class_2338)schematic.method_58694(AllDataComponents.SCHEMATIC_ANCHOR);
        SchematicLevel world = new SchematicLevel(anchor, wrapped);
        class_3492 settings = SchematicItem.getSettings(schematic);
        activeTemplate.method_15172((class_5425)world, anchor, anchor, settings, wrapped.method_8409(), 2);
        StructureTransform transform = new StructureTransform(settings.method_15134(), class_2350.class_2351.field_11052, settings.method_15113(), settings.method_15114());
        for (class_2586 be : world.getBlockEntities()) {
            transform.apply(be);
        }
        return world;
    }

    public static void clearHash(class_1799 schematic) {
        if (schematic == null || !schematic.method_57826(AllDataComponents.SCHEMATIC_FILE)) {
            return;
        }
        schematic.method_57381(AllDataComponents.SCHEMATIC_HASH);
    }

    public static int getHash(class_1799 schematic) {
        if (schematic == null || !schematic.method_57826(AllDataComponents.SCHEMATIC_FILE)) {
            return -1;
        }
        if (!schematic.method_57826(AllDataComponents.SCHEMATIC_HASH)) {
            schematic.method_57379(AllDataComponents.SCHEMATIC_HASH, (Object)schematic.method_57380().hashCode());
        }
        return (Integer)schematic.method_58695(AllDataComponents.SCHEMATIC_HASH, (Object)-1);
    }
}

