/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.graph;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.server.MinecraftServer;

public class EdgePointStorage {
    private Map<EdgePointType<?>, Map<UUID, TrackEdgePoint>> pointsByType = new HashMap();

    public <T extends TrackEdgePoint> void put(EdgePointType<T> type, TrackEdgePoint point) {
        this.getMap(type).put(point.getId(), point);
    }

    public <T extends TrackEdgePoint> T get(EdgePointType<T> type, UUID id) {
        return (T)this.getMap(type).get(id);
    }

    public <T extends TrackEdgePoint> T remove(EdgePointType<T> type, UUID id) {
        return (T)this.getMap(type).remove(id);
    }

    public <T extends TrackEdgePoint> Collection<T> values(EdgePointType<T> type) {
        return this.getMap(type).values().stream().map(e -> e).toList();
    }

    public Map<UUID, TrackEdgePoint> getMap(EdgePointType<? extends TrackEdgePoint> type) {
        return this.pointsByType.computeIfAbsent(type, t -> new HashMap());
    }

    public void tick(MinecraftServer server, TrackGraph graph, boolean preTrains) {
        this.pointsByType.values().forEach(map -> map.values().forEach(p -> p.tick(server, graph, preTrains)));
    }

    public void transferAll(TrackGraph target, EdgePointStorage other) {
        this.pointsByType.forEach((type, map) -> {
            other.getMap((EdgePointType<? extends TrackEdgePoint>)type).putAll((Map<UUID, TrackEdgePoint>)map);
            map.values().forEach(ep -> Create.RAILWAYS.sync.pointAdded(target, (TrackEdgePoint)ep));
        });
        this.pointsByType.clear();
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        for (Map.Entry<EdgePointType<?>, Map<UUID, TrackEdgePoint>> entry : this.pointsByType.entrySet()) {
            EdgePointType<?> type = entry.getKey();
            class_11372.class_11374 list = view.method_71476(type.getId().toString());
            entry.getValue().values().forEach(edgePoint -> edgePoint.write(list.method_71480(), dimensions));
        }
    }

    public static <T> DataResult<T> encode(EdgePointStorage input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder map = ops.mapBuilder();
        for (Map.Entry<EdgePointType<?>, Map<UUID, TrackEdgePoint>> entry : input.pointsByType.entrySet()) {
            EdgePointType<?> type = entry.getKey();
            ListBuilder list = ops.listBuilder();
            for (TrackEdgePoint edgePoint : entry.getValue().values()) {
                list.add(edgePoint.encode(ops, empty, dimensions));
            }
            map.add(type.getId().toString(), list.build(empty));
        }
        return map.build(empty);
    }

    public void read(class_11368 view, DimensionPalette dimensions) {
        for (EdgePointType<?> type : EdgePointType.TYPES.values()) {
            Map<UUID, TrackEdgePoint> map = this.getMap(type);
            view.method_71438(type.getId().toString()).forEach(item -> {
                Object edgePoint = type.create();
                ((TrackEdgePoint)edgePoint).read((class_11368)item, false, dimensions);
                map.put(((TrackEdgePoint)edgePoint).getId(), (TrackEdgePoint)edgePoint);
            });
        }
    }

    public <T> void decode(DynamicOps<T> ops, T input, DimensionPalette dimensions) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        for (EdgePointType<?> type : EdgePointType.TYPES.values()) {
            Map<UUID, TrackEdgePoint> typeMap = this.getMap(type);
            ops.getList(map.get(type.getId().toString())).ifSuccess(list -> list.accept(item -> {
                Object edgePoint = type.create();
                ((TrackEdgePoint)edgePoint).decode((DynamicOps<Object>)ops, (Object)item, false, dimensions);
                typeMap.put(((TrackEdgePoint)edgePoint).getId(), (TrackEdgePoint)edgePoint);
            }));
        }
    }
}

