/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.inventory;

import com.google.common.base.Predicates;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public class TankManipulationBehaviour
extends CapManipulationBehaviourBase<FluidInventory, TankManipulationBehaviour> {
    public static final BehaviourType<TankManipulationBehaviour> OBSERVE = new BehaviourType();
    private final BehaviourType<TankManipulationBehaviour> behaviourType;

    public TankManipulationBehaviour(SmartBlockEntity be, CapManipulationBehaviourBase.InterfaceProvider target) {
        this(OBSERVE, be, target);
    }

    private TankManipulationBehaviour(BehaviourType<TankManipulationBehaviour> type, SmartBlockEntity be, CapManipulationBehaviourBase.InterfaceProvider target) {
        super(be, target);
        this.behaviourType = type;
    }

    public FluidStack extractAny() {
        FluidInventory inventory = (FluidInventory)this.getInventory();
        if (inventory == null) {
            return FluidStack.EMPTY;
        }
        Predicate<FluidStack> filterTest = this.getFilterTest((Predicate<FluidStack>)Predicates.alwaysTrue());
        if (this.simulateNext) {
            return inventory.count(filterTest);
        }
        return inventory.extract(filterTest);
    }

    protected Predicate<FluidStack> getFilterTest(Predicate<FluidStack> customFilter) {
        Predicate<FluidStack> test = customFilter;
        ServerFilteringBehaviour filter = this.blockEntity.getBehaviour(ServerFilteringBehaviour.TYPE);
        if (filter != null) {
            test = customFilter.and(filter::test);
        }
        return test;
    }

    @Override
    protected FluidInventory getCapability(class_1937 world, class_2338 pos, class_2586 blockEntity, @Nullable class_2350 side) {
        return FluidHelper.getFluidInventory(world, pos, null, blockEntity, side);
    }

    @Override
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }
}

