/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.items;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import org.jetbrains.annotations.NotNull;

public interface BaseInventory
extends Iterable<class_1799> {
    public static final Hash.Strategy<class_1799> ITEM_STACK_HASH_STRATEGY;

    default public void create$setStack(int slot, class_1799 stack) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public int create$size() {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public int create$getMaxCount(class_1799 stack) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public class_1799 create$getStack(int slot) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public boolean create$isValid(int slot, class_1799 stack) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public void create$markDirty() {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public int count(class_1799 stack, class_2350 side) {
        return this.count(stack);
    }

    default public int count(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.count(stack, maxAmount);
    }

    default public int count(class_1799 stack, int maxAmount, class_2350 side) {
        return this.count(stack, maxAmount);
    }

    default public int count(class_1799 stack, int maxAmount) {
        int count = 0;
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 target = this.create$getStack(i);
            if (target.method_7960() || !this.matches(target, stack) || (count += target.method_7947()) < maxAmount) continue;
            return maxAmount;
        }
        return count;
    }

    default public class_1799 count(Predicate<class_1799> predicate, class_2350 side) {
        return this.count(predicate);
    }

    default public class_1799 count(Predicate<class_1799> predicate) {
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = this.create$getStack(i);
            if (stack.method_7960() || !predicate.test(stack)) continue;
            return this.onExtract(stack);
        }
        return class_1799.field_8037;
    }

    default public class_1799 count(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        return this.count(predicate, maxAmount);
    }

    default public class_1799 count(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 findStack = this.create$getStack(i);
            if (findStack.method_7960() || !predicate.test(findStack)) continue;
            int count = findStack.method_7947();
            if (count >= maxAmount) {
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            ++i;
            while (i < size) {
                class_1799 stack = this.create$getStack(i);
                if (!stack.method_7960() && this.matches(stack, findStack) && (count += stack.method_7947()) >= maxAmount) {
                    return this.onExtract(this.directCopy(findStack, maxAmount));
                }
                ++i;
            }
            return this.onExtract(this.directCopy(findStack, count));
        }
        return class_1799.field_8037;
    }

    default public int countAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        return this.countAll(predicate, maxAmount);
    }

    default public int countAll(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return 0;
        }
        int count = 0;
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = this.create$getStack(i);
            if (stack.method_7960() || !predicate.test(stack) || (count += stack.method_7947()) < maxAmount) continue;
            return maxAmount;
        }
        return count;
    }

    default public class_1799 countAny(class_2350 side) {
        return this.countAny();
    }

    default public class_1799 countAny() {
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 target = this.create$getStack(i);
            if (target.method_7960()) continue;
            return this.onExtract(this.directCopy(target, target.method_7947()));
        }
        return class_1799.field_8037;
    }

    default public class_1799 countAny(int maxAmount, class_2350 side) {
        return this.extractAny(maxAmount);
    }

    default public class_1799 countAny(int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 findStack = this.create$getStack(i);
            if (findStack.method_7960()) continue;
            int count = findStack.method_7947();
            if (count >= maxAmount) {
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            ++i;
            while (i < size) {
                class_1799 stack = this.create$getStack(i);
                if (!stack.method_7960() && this.matches(stack, findStack) && (count += stack.method_7947()) >= maxAmount) {
                    return this.onExtract(this.directCopy(findStack, maxAmount));
                }
                ++i;
            }
            return this.onExtract(this.directCopy(findStack, count));
        }
        return class_1799.field_8037;
    }

    default public int countSpace(class_1799 stack, class_2350 side) {
        return this.countSpace(stack);
    }

    default public int countSpace(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.countSpace(stack, maxAmount);
    }

    default public int countSpace(class_1799 stack, int maxAmount, class_2350 side) {
        return this.countSpace(stack, maxAmount);
    }

    default public int countSpace(class_1799 stack, int maxAmount) {
        int count = 0;
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 target;
            if (!this.create$isValid(i, stack) || !((target = this.create$getStack(i)).method_7960() ? (count += this.create$getMaxCount(stack)) >= maxAmount : this.matches(target, stack) && (count += target.method_7914() - target.method_7947()) >= maxAmount)) continue;
            return maxAmount;
        }
        return count;
    }

    default public int countSpace(class_1799 stack, int maxAmount, int start, int end, class_2350 side) {
        return this.countSpace(stack, maxAmount, start, end);
    }

    default public int countSpace(class_1799 stack, int maxAmount, int start, int end) {
        int count = 0;
        for (int i = start; i <= end; ++i) {
            class_1799 target;
            if (!this.create$isValid(i, stack) || !((target = this.create$getStack(i)).method_7960() ? (count += this.create$getMaxCount(stack)) >= maxAmount : this.matches(target, stack) && (count += target.method_7914() - target.method_7947()) >= maxAmount)) continue;
            return maxAmount;
        }
        return count;
    }

    default public boolean countSpace(List<class_1799> stacks, class_2350 side) {
        return this.countSpace(stacks);
    }

    default public boolean countSpace(List<class_1799> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int count;
            class_1799 stack = stacks.getFirst();
            return this.countSpace(stack, count = stack.method_7947()) == count;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int count;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            return this.countSpace(stack, count = entry.getIntValue()) == count;
        }
        int size = this.create$size();
        block1: for (int i = 0; i < size; ++i) {
            class_1799 target = this.create$getStack(i);
            boolean empty = target.method_7960();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                class_1799 stack;
                if (!this.create$isValid(i, stack = (class_1799)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.create$getMaxCount(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue block1;
                        return true;
                    }
                    entry.setValue(remaining - insert2);
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.method_7914();
                int count = target.method_7947();
                if (count == maxCount) continue block1;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxCount - count))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue block1;
                    return true;
                }
                entry.setValue(remaining - insert);
                continue block1;
            } while (iterator.hasNext());
        }
        return false;
    }

    default public boolean countSpace(List<class_1799> stacks, int start, int end, class_2350 side) {
        return this.countSpace(stacks, start, end);
    }

    default public boolean countSpace(List<class_1799> stacks, int start, int end) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int count;
            class_1799 stack = stacks.getFirst();
            return this.countSpace(stack, count = stack.method_7947(), start, end) == count;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int count;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            return this.countSpace(stack, count = entry.getIntValue(), start, end) == count;
        }
        block1: for (int i = start; i <= end; ++i) {
            class_1799 target = this.create$getStack(i);
            boolean empty = target.method_7960();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                class_1799 stack;
                if (!this.create$isValid(i, stack = (class_1799)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.create$getMaxCount(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue block1;
                        return true;
                    }
                    entry.setValue(remaining - insert2);
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.method_7914();
                int count = target.method_7947();
                if (count == maxCount) continue block1;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxCount - count))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue block1;
                    return true;
                }
                entry.setValue(remaining - insert);
                continue block1;
            } while (iterator.hasNext());
        }
        return false;
    }

    default public class_1799 directCopy(class_1799 stack, int count) {
        if (!2.$assertionsDisabled && stack.field_8038 == null) {
            throw new AssertionError();
        }
        class_1799 copy = new class_1799((class_1935)stack.field_8038, count, stack.field_49270.method_57941());
        copy.method_7912(stack.method_7965());
        return copy;
    }

    default public int extract(class_1799 stack, class_2350 side) {
        return this.extract(stack);
    }

    default public int extract(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.extract(stack, maxAmount);
    }

    default public int extract(class_1799 stack, int maxAmount, class_2350 side) {
        return this.extract(stack, maxAmount);
    }

    default public int extract(class_1799 stack, int maxAmount) {
        int remaining = maxAmount;
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 target = this.create$getStack(i);
            if (target.method_7960() || !this.matches(target, stack)) continue;
            int count = target.method_7947();
            if (count > remaining) {
                target.method_7939(count - remaining);
                this.create$markDirty();
                return maxAmount;
            }
            this.create$setStack(i, class_1799.field_8037);
            if (count == remaining) {
                this.create$markDirty();
                return maxAmount;
            }
            remaining -= count;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.create$markDirty();
        return maxAmount - remaining;
    }

    default public class_1799 extract(Predicate<class_1799> predicate, class_2350 side) {
        return this.extract(predicate);
    }

    default public class_1799 extract(Predicate<class_1799> predicate) {
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 target = this.create$getStack(i);
            if (target.method_7960() || !predicate.test(target)) continue;
            this.create$setStack(i, class_1799.field_8037);
            this.create$markDirty();
            return this.onExtract(target);
        }
        return class_1799.field_8037;
    }

    default public class_1799 extract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        return this.extract(predicate, maxAmount);
    }

    default public class_1799 extract(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 findStack = this.create$getStack(i);
            if (findStack.method_7960() || !predicate.test(findStack)) continue;
            int count = findStack.method_7947();
            if (count > maxAmount) {
                findStack.method_7939(count - maxAmount);
                this.create$markDirty();
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            this.create$setStack(i, class_1799.field_8037);
            if (count == maxAmount) {
                this.create$markDirty();
                return this.onExtract(findStack);
            }
            int remaining = maxAmount - count;
            ++i;
            while (i < size) {
                class_1799 stack = this.create$getStack(i);
                if (!stack.method_7960() && this.matches(stack, findStack)) {
                    count = stack.method_7947();
                    if (count < remaining) {
                        this.create$setStack(i, class_1799.field_8037);
                        remaining -= count;
                    } else {
                        if (count == remaining) {
                            this.create$setStack(i, class_1799.field_8037);
                        } else {
                            stack.method_7939(count - remaining);
                        }
                        this.create$markDirty();
                        findStack.method_7939(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
            this.create$markDirty();
            findStack.method_7939(maxAmount - remaining);
            return this.onExtract(findStack);
        }
        return class_1799.field_8037;
    }

    default public List<class_1799> extract(List<class_1799> stacks, class_2350 side) {
        return this.extract(stacks);
    }

    default public List<class_1799> extract(List<class_1799> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int extract;
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            if (count == (extract = this.extract(stack))) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - extract));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int extract;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            int count = entry.getIntValue();
            if (count == (extract = this.extract(stack, count))) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - extract));
        }
        boolean dirty = false;
        int size = this.create$size();
        block1: for (int i = 0; i < size; ++i) {
            class_1799 target = this.create$getStack(i);
            if (target.method_7960()) continue;
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int remaining;
                Object2IntMap.Entry entry;
                class_1799 stack;
                if (!this.matches(target, stack = (class_1799)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                int count = target.method_7947();
                if (count < (remaining = entry.getIntValue())) {
                    this.create$setStack(i, class_1799.field_8037);
                    entry.setValue(remaining - count);
                    continue block1;
                }
                if (count == remaining) {
                    this.create$setStack(i, class_1799.field_8037);
                } else {
                    target.method_7939(count - remaining);
                }
                iterator.remove();
                if (entries.isEmpty()) {
                    this.create$markDirty();
                    return List.of();
                }
                dirty = true;
                continue block1;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<class_1799> result = new ArrayList<class_1799>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                class_1799 stack = (class_1799)entry.getKey();
                int count = entry.getIntValue();
                if (stack.method_7947() == count) {
                    result.add(stack);
                    continue;
                }
                result.add(this.directCopy(stack, count));
            }
            this.create$markDirty();
            return result;
        }
        return stacks;
    }

    default public int extractAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        return this.extractAll(predicate, maxAmount);
    }

    default public int extractAll(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return 0;
        }
        int remaining = maxAmount;
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = this.create$getStack(i);
            if (stack.method_7960() || !predicate.test(stack)) continue;
            int count = stack.method_7947();
            if (count < remaining) {
                this.create$setStack(i, class_1799.field_8037);
                remaining -= count;
                continue;
            }
            if (count == remaining) {
                this.create$setStack(i, class_1799.field_8037);
            } else {
                stack.method_7939(count - remaining);
            }
            this.create$markDirty();
            return maxAmount;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.create$markDirty();
        return maxAmount - remaining;
    }

    default public class_1799 extractAny(class_2350 side) {
        return this.extractAny();
    }

    default public class_1799 extractAny() {
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 target = this.create$getStack(i);
            if (target.method_7960()) continue;
            this.create$setStack(i, class_1799.field_8037);
            this.create$markDirty();
            return this.onExtract(target);
        }
        return class_1799.field_8037;
    }

    default public class_1799 extractAny(int maxAmount, class_2350 side) {
        return this.extractAny(maxAmount);
    }

    default public class_1799 extractAny(int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 findStack = this.create$getStack(i);
            if (findStack.method_7960()) continue;
            int count = findStack.method_7947();
            if (count > maxAmount) {
                findStack.method_7939(count - maxAmount);
                this.create$markDirty();
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            this.create$setStack(i, class_1799.field_8037);
            if (count == maxAmount) {
                this.create$markDirty();
                return this.onExtract(findStack);
            }
            int remaining = maxAmount - count;
            ++i;
            while (i < size) {
                class_1799 stack = this.create$getStack(i);
                if (!stack.method_7960() && this.matches(stack, findStack)) {
                    count = stack.method_7947();
                    if (count < remaining) {
                        this.create$setStack(i, class_1799.field_8037);
                        remaining -= count;
                    } else {
                        if (count == remaining) {
                            this.create$setStack(i, class_1799.field_8037);
                        } else {
                            stack.method_7939(count - remaining);
                        }
                        this.create$markDirty();
                        findStack.method_7939(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
            this.create$markDirty();
            findStack.method_7939(maxAmount - remaining);
            return this.onExtract(findStack);
        }
        return class_1799.field_8037;
    }

    default public int forceInsert(class_1799 stack) {
        return this.insert(stack);
    }

    default public int forceInsert(class_1799 stack, int maxAmount) {
        return this.insert(stack, maxAmount);
    }

    default public boolean forcePreciseInsert(class_1799 stack) {
        return this.preciseInsert(stack);
    }

    default public boolean forcePreciseInsert(class_1799 stack, int maxAmount) {
        return this.preciseInsert(stack, maxAmount);
    }

    default public int insert(class_1799 stack, class_2350 side) {
        return this.insert(stack);
    }

    default public int insert(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insert(stack, maxAmount);
    }

    default public int insert(class_1799 stack, int maxAmount, class_2350 side) {
        return this.insert(stack, maxAmount);
    }

    default public int insert(class_1799 stack, int maxAmount) {
        int remaining = maxAmount;
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            if (!this.create$isValid(i, stack)) continue;
            class_1799 target = this.create$getStack(i);
            if (target.method_7960()) {
                int insert = Math.min(remaining, this.create$getMaxCount(stack));
                this.create$setStack(i, this.directCopy(stack, insert));
                if (remaining == insert) {
                    this.create$markDirty();
                    return maxAmount;
                }
                remaining -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.method_7914();
            int count = target.method_7947();
            if (count == maxCount) continue;
            int insert = Math.min(remaining, maxCount - count);
            target.method_7939(count + insert);
            if (remaining == insert) {
                this.create$markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.create$markDirty();
        return maxAmount - remaining;
    }

    default public int insert(class_1799 stack, int maxAmount, int start, int end, class_2350 side) {
        return this.insert(stack, maxAmount, start, end);
    }

    default public int insert(class_1799 stack, int maxAmount, int start, int end) {
        int remaining = maxAmount;
        for (int i = start; i < end; ++i) {
            if (!this.create$isValid(i, stack)) continue;
            class_1799 target = this.create$getStack(i);
            if (target.method_7960()) {
                int insert = Math.min(remaining, this.create$getMaxCount(stack));
                this.create$setStack(i, this.directCopy(stack, insert));
                if (remaining == insert) {
                    this.create$markDirty();
                    return maxAmount;
                }
                remaining -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.method_7914();
            int count = target.method_7947();
            if (count == maxCount) continue;
            int insert = Math.min(remaining, maxCount - count);
            target.method_7939(count + insert);
            if (remaining == insert) {
                this.create$markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.create$markDirty();
        return maxAmount - remaining;
    }

    default public List<class_1799> insert(List<class_1799> stacks, class_2350 side) {
        return this.insert(stacks);
    }

    default public List<class_1799> insert(List<class_1799> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            if (count == (insert = this.insert(stack))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            int count = entry.getIntValue();
            if (count == (insert = this.insert(stack, count))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        boolean dirty = false;
        int size = this.create$size();
        block1: for (int i = 0; i < size; ++i) {
            class_1799 target = this.create$getStack(i);
            boolean empty = target.method_7960();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry;
                class_1799 stack;
                if (!this.create$isValid(i, stack = (class_1799)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int remaining = entry.getIntValue();
                    int insert = Math.min(remaining, this.create$getMaxCount(stack));
                    this.create$setStack(i, this.directCopy(stack, insert));
                    if (remaining == insert) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            this.create$markDirty();
                            return List.of();
                        }
                    } else {
                        entry.setValue(remaining - insert);
                    }
                    dirty = true;
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.method_7914();
                int count = target.method_7947();
                if (count == maxCount) continue block1;
                int remaining = entry.getIntValue();
                int insert = Math.min(remaining, maxCount - count);
                target.method_7939(count + insert);
                if (remaining == insert) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        this.create$markDirty();
                        return List.of();
                    }
                } else {
                    entry.setValue(remaining - insert);
                }
                dirty = true;
                continue block1;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<class_1799> result = new ArrayList<class_1799>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                class_1799 stack = (class_1799)entry.getKey();
                int count = entry.getIntValue();
                if (stack.method_7947() == count) {
                    result.add(stack);
                    continue;
                }
                result.add(this.directCopy(stack, count));
            }
            this.create$markDirty();
            return result;
        }
        return stacks;
    }

    default public List<class_1799> insert(List<class_1799> stacks, int start, int end, class_2350 side) {
        return this.insert(stacks, start, end);
    }

    default public List<class_1799> insert(List<class_1799> stacks, int start, int end) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            if (count == (insert = this.insert(stack, count, start, end))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            int count = entry.getIntValue();
            if (count == (insert = this.insert(stack, count, start, end))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        boolean dirty = false;
        block1: for (int i = start; i < end; ++i) {
            class_1799 target = this.create$getStack(i);
            boolean empty = target.method_7960();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry;
                class_1799 stack;
                if (!this.create$isValid(i, stack = (class_1799)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int remaining = entry.getIntValue();
                    int insert = Math.min(remaining, this.create$getMaxCount(stack));
                    this.create$setStack(i, this.directCopy(stack, insert));
                    if (remaining == insert) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            this.create$markDirty();
                            return List.of();
                        }
                    } else {
                        entry.setValue(remaining - insert);
                    }
                    dirty = true;
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.method_7914();
                int count = target.method_7947();
                if (count == maxCount) continue block1;
                int remaining = entry.getIntValue();
                int insert = Math.min(remaining, maxCount - count);
                target.method_7939(count + insert);
                if (remaining == insert) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        this.create$markDirty();
                        return List.of();
                    }
                } else {
                    entry.setValue(remaining - insert);
                }
                dirty = true;
                continue block1;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<class_1799> result = new ArrayList<class_1799>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                class_1799 stack = (class_1799)entry.getKey();
                int count = entry.getIntValue();
                if (stack.method_7947() == count) {
                    result.add(stack);
                    continue;
                }
                result.add(this.directCopy(stack, count));
            }
            this.create$markDirty();
            return result;
        }
        return stacks;
    }

    default public int insertExist(class_1799 stack, class_2350 side) {
        return this.insertExist(stack);
    }

    default public int insertExist(class_1799 stack, int maxAmount, class_2350 side) {
        return this.insertExist(stack);
    }

    default public int insertExist(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insertExist(stack, maxAmount);
    }

    default public int insertExist(class_1799 stack, int maxAmount) {
        int remaining = maxAmount;
        ArrayList<Integer> emptys = new ArrayList<Integer>();
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            if (!this.create$isValid(i, stack)) continue;
            class_1799 target = this.create$getStack(i);
            if (target.method_7960()) {
                emptys.add(i);
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.method_7914();
            int count = target.method_7947();
            if (count == maxCount) continue;
            int insert = Math.min(remaining, maxCount - count);
            target.method_7939(count + insert);
            if (remaining == insert) {
                this.create$markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        Iterator iterator = emptys.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            int insert = Math.min(remaining, this.create$getMaxCount(stack));
            this.create$setStack(i, this.directCopy(stack, insert));
            if (remaining == insert) {
                this.create$markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.create$markDirty();
        return maxAmount - remaining;
    }

    @NotNull
    default public Iterator<class_1799> iterator(class_2350 side) {
        return this.iterator();
    }

    default public boolean matches(class_1799 stack, class_1799 otherStack) {
        if (stack.method_31574(otherStack.method_7909())) {
            class_9335 stackComponents = stack.field_49270;
            class_9335 otherStackComponents = otherStack.field_49270;
            if (stackComponents == otherStackComponents) {
                return true;
            }
            Reference2ObjectMap stackComponentMap = stackComponents.field_49655;
            Reference2ObjectMap otherStackComponentMap = otherStackComponents.field_49655;
            if (stackComponentMap == otherStackComponentMap) {
                return true;
            }
            int stackComponentCount = stackComponentMap.size();
            if (stackComponentMap.containsKey((Object)class_9334.field_50071)) {
                --stackComponentCount;
            }
            int otherStackComponentCount = otherStackComponentMap.size();
            boolean hasMaxCapacityComponent = false;
            if (otherStackComponentMap.containsKey((Object)class_9334.field_50071)) {
                --otherStackComponentCount;
                hasMaxCapacityComponent = true;
            }
            if (stackComponentCount != otherStackComponentCount) {
                return false;
            }
            if (hasMaxCapacityComponent) {
                ObjectSet stackComponentSet = stackComponentMap.reference2ObjectEntrySet();
                for (Reference2ObjectMap.Entry componentEntry : otherStackComponentMap.reference2ObjectEntrySet()) {
                    if (stackComponentSet.contains((Object)componentEntry) || componentEntry.getKey() == class_9334.field_50071) continue;
                    return false;
                }
                return true;
            }
            return stackComponentMap.reference2ObjectEntrySet().containsAll((Collection)otherStackComponentMap.reference2ObjectEntrySet());
        }
        return false;
    }

    default public class_1799 onExtract(class_1799 stack) {
        return stack;
    }

    default public boolean preciseExtract(class_1799 stack, class_2350 side) {
        return this.preciseExtract(stack);
    }

    default public boolean preciseExtract(class_1799 stack) {
        if (stack.method_7960()) {
            return true;
        }
        int remaining = stack.method_7947();
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 target = this.create$getStack(i);
            if (target.method_7960() || !this.matches(target, stack)) continue;
            int count = target.method_7947();
            if (count > remaining) {
                changes.forEach(Runnable::run);
                target.method_7939(count - remaining);
                this.create$markDirty();
                return true;
            }
            if (count == remaining) {
                changes.forEach(Runnable::run);
                this.create$setStack(i, class_1799.field_8037);
                this.create$markDirty();
                return true;
            }
            int slot = i;
            changes.add(() -> this.create$setStack(slot, class_1799.field_8037));
            remaining -= count;
        }
        return false;
    }

    default public class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        return this.preciseExtract(predicate, maxAmount);
    }

    default public class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int size = this.create$size();
        ArrayList<Integer> buffer = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            class_1799 findStack = this.create$getStack(i);
            if (findStack.method_7960() || !predicate.test(findStack)) continue;
            int count = findStack.method_7947();
            if (count > maxAmount) {
                findStack.method_7939(count - maxAmount);
                this.create$markDirty();
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            if (count == maxAmount) {
                this.create$setStack(i, class_1799.field_8037);
                this.create$markDirty();
                return this.onExtract(findStack);
            }
            buffer.add(i);
            int remaining = maxAmount - count;
            ++i;
            while (i < size) {
                class_1799 stack = this.create$getStack(i);
                if (!stack.method_7960() && this.matches(stack, findStack)) {
                    count = stack.method_7947();
                    if (count < remaining) {
                        buffer.add(i);
                        remaining -= count;
                    } else {
                        buffer.forEach(slot -> this.create$setStack((int)slot, class_1799.field_8037));
                        if (count == remaining) {
                            this.create$setStack(i, class_1799.field_8037);
                        } else {
                            stack.method_7939(count - remaining);
                        }
                        this.create$markDirty();
                        findStack.method_7939(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
        }
        return class_1799.field_8037;
    }

    default public boolean preciseInsert(class_1799 stack, class_2350 side) {
        return this.preciseInsert(stack);
    }

    default public boolean preciseInsert(class_1799 stack) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return true;
        }
        return this.preciseInsert(stack, maxAmount);
    }

    default public boolean preciseInsert(class_1799 stack, int maxAmount, class_2350 side) {
        return this.preciseInsert(stack, maxAmount);
    }

    default public boolean preciseInsert(class_1799 stack, int maxAmount) {
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            if (!this.create$isValid(i, stack)) continue;
            class_1799 target = this.create$getStack(i);
            if (target.method_7960()) {
                int insert = Math.min(maxAmount, this.create$getMaxCount(stack));
                if (maxAmount == insert) {
                    changes.forEach(Runnable::run);
                    this.create$setStack(i, this.directCopy(stack, insert));
                    this.create$markDirty();
                    return true;
                }
                int slot = i;
                changes.add(() -> this.create$setStack(slot, this.directCopy(stack, insert)));
                maxAmount -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.method_7914();
            int count = target.method_7947();
            if (count == maxCount) continue;
            int insert = Math.min(maxAmount, maxCount - count);
            if (maxAmount == insert) {
                changes.forEach(Runnable::run);
                target.method_7939(count + insert);
                this.create$markDirty();
                return true;
            }
            changes.add(() -> target.method_7939(count + insert));
            maxAmount -= insert;
        }
        return false;
    }

    default public boolean preciseInsert(List<class_1799> stacks, class_2350 side) {
        return this.preciseInsert(stacks);
    }

    default public boolean preciseInsert(List<class_1799> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            return this.preciseInsert(stacks.getFirst());
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            return this.preciseInsert((class_1799)entry.getKey(), entry.getIntValue());
        }
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        int size = this.create$size();
        block1: for (int i = 0; i < size; ++i) {
            class_1799 target = this.create$getStack(i);
            boolean empty = target.method_7960();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                class_1799 stack;
                if (!this.create$isValid(i, stack = (class_1799)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.create$getMaxCount(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue block1;
                        changes.forEach(Runnable::run);
                        this.create$setStack(i, this.directCopy(stack, insert2));
                        this.create$markDirty();
                        return true;
                    }
                    int slot = i;
                    changes.add(() -> this.create$setStack(slot, this.directCopy(stack, insert2)));
                    entry.setValue(remaining - insert2);
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.method_7914();
                int count = target.method_7947();
                if (count == maxCount) continue block1;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxCount - count))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue block1;
                    changes.forEach(Runnable::run);
                    target.method_7939(count + insert);
                    this.create$markDirty();
                    return true;
                }
                changes.add(() -> target.method_7939(count + insert));
                entry.setValue(remaining - insert);
                continue block1;
            } while (iterator.hasNext());
        }
        return false;
    }

    default public boolean update(Predicate<class_1799> predicate, Function<class_1799, class_1799> update, class_2350 side) {
        return this.update(predicate, update);
    }

    default public boolean update(Predicate<class_1799> predicate, Function<class_1799, class_1799> update) {
        int size = this.create$size();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = this.create$getStack(i);
            if (stack.method_7960() || !predicate.test(stack)) continue;
            class_1799 replace = update.apply(stack);
            if (replace != stack) {
                this.create$setStack(i, replace);
            }
            this.create$markDirty();
            return true;
        }
        return false;
    }

    default public class_1799 removeMaxSize(class_1799 stack, Optional<Integer> max) {
        class_9335 components = stack.field_49270;
        components.method_57942();
        components.field_49655.remove((Object)class_9334.field_50071, max);
        return stack;
    }

    default public void setMaxSize(class_1799 stack, Optional<Integer> max) {
        class_9335 components = stack.field_49270;
        components.method_57942();
        components.field_49655.put((Object)class_9334.field_50071, max);
    }

    default public Stream<class_1799> stream(class_2350 side) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(side), 16), false);
    }

    default public Stream<class_1799> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        ITEM_STACK_HASH_STRATEGY = new Hash.Strategy<class_1799>(){

            public boolean equals(class_1799 stack, class_1799 other) {
                return stack == other || stack != null && other != null && class_1799.method_31577((class_1799)stack, (class_1799)other);
            }

            public int hashCode(class_1799 stack) {
                return class_1799.method_57355((class_1799)stack);
            }
        };
    }
}

