package com.zurrtum.create;

import com.zurrtum.create.content.trains.bogey.AllBogeySizes;
import com.zurrtum.create.content.trains.bogey.BogeyStyle;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

import static com.zurrtum.create.Create.MOD_ID;

public class AllBogeyStyles {
    public static final Map<class_2960, BogeyStyle> BOGEY_STYLES = new HashMap<>();
    public static final Map<class_2960, Map<class_2960, BogeyStyle>> CYCLE_GROUPS = new HashMap<>();
    private static final Map<class_2960, BogeyStyle> EMPTY_GROUP = Collections.emptyMap();

    public static final class_2960 STANDARD_CYCLE_GROUP = class_2960.method_60655(MOD_ID, "standard");

    public static final BogeyStyle STANDARD = builder("standard", STANDARD_CYCLE_GROUP).displayName(class_2561.method_43471(
        "create.bogey.style.standard")).size(AllBogeySizes.SMALL, AllBlocks.SMALL_BOGEY).size(AllBogeySizes.LARGE, AllBlocks.LARGE_BOGEY).build();

    public static Map<class_2960, BogeyStyle> getCycleGroup(class_2960 cycleGroup) {
        return CYCLE_GROUPS.getOrDefault(cycleGroup, EMPTY_GROUP);
    }

    private static BogeyStyle.Builder builder(String name, class_2960 cycleGroup) {
        return new BogeyStyle.Builder(class_2960.method_60655(MOD_ID, name), cycleGroup);
    }

    public static void register() {
    }
}
