package com.zurrtum.create.api.contraption.dispenser;

import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2965;
import net.minecraft.class_6088;
import org.jetbrains.annotations.Nullable;

/**
 * A parallel to {@link class_2965}, providing a base implementation for projectile-shooting behaviors.
 */
public abstract class MountedProjectileDispenseBehavior extends DefaultMountedDispenseBehavior {
    @Override
    protected class_1799 execute(class_1799 stack, MovementContext context, class_2338 pos, class_243 facing) {
        double x = pos.method_10263() + facing.field_1352 * .7 + .5;
        double y = pos.method_10264() + facing.field_1351 * .7 + .5;
        double z = pos.method_10260() + facing.field_1350 * .7 + .5;
        class_1676 projectile = getProjectile(context.world, x, y, z, stack.method_7972(), MountedDispenseBehavior.getClosestFacingDirection(facing));
        if (projectile == null)
            return stack;

        class_243 motion = facing.method_1021(getPower()).method_1019(context.motion);
        projectile.method_7485(motion.field_1352, motion.field_1351, motion.field_1350, (float) motion.method_1033(), getUncertainty());
        context.world.method_8649(projectile);
        stack.method_7934(1);
        return stack;
    }

    @Override
    protected void playSound(class_1936 level, class_2338 pos) {
        level.method_20290(class_6088.field_31160, pos, 0);
    }

    @Nullable
    protected abstract class_1676 getProjectile(class_1937 level, double x, double y, double z, class_1799 stack, class_2350 facing);

    protected float getUncertainty() {
        return 6;
    }

    protected float getPower() {
        return 1.1f;
    }

    /**
     * Create a mounted behavior wrapper from a vanilla projectile dispense behavior.
     */
    public static MountedDispenseBehavior of(class_2965 vanillaBehaviour) {
        return new MountedProjectileDispenseBehavior() {
            @Override
            protected class_1676 getProjectile(class_1937 level, double x, double y, double z, class_1799 stack, class_2350 facing) {
                return vanillaBehaviour.field_50243.method_58648(level, new class_243(x, y, z), stack, facing);
            }

            @Override
            protected float getUncertainty() {
                return vanillaBehaviour.field_50244.comp_2545();
            }

            @Override
            protected float getPower() {
                return vanillaBehaviour.field_50244.comp_2546();
            }
        };
    }
}
