package com.zurrtum.create.api.contraption.storage.item;

import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1799;

/**
 * Partial implementation of a MountedItemStorage that wraps an item handler.
 */
public abstract class WrapperMountedItemStorage<T extends class_1263> extends MountedItemStorage {
    protected T wrapped;

    protected WrapperMountedItemStorage(MountedItemStorageType<?> type) {
        super(type);
    }

    protected WrapperMountedItemStorage(MountedItemStorageType<?> type, T wrapped) {
        super(type);
        this.wrapped = wrapped;
    }

    @Override
    public int method_5439() {
        return wrapped.method_5439();
    }

    @Override
    public class_1799 method_5438(int slot) {
        return wrapped.method_5438(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        wrapped.method_5447(slot, stack);
    }

    @Override
    public int method_5444() {
        return wrapped.method_5444();
    }

    @Override
    public int method_58350(class_1799 stack) {
        return wrapped.method_58350(stack);
    }

    @Override
    public int insert(class_1799 stack) {
        return wrapped.insert(stack);
    }

    @Override
    public int extract(class_1799 stack) {
        return wrapped.extract(stack);
    }

    public static ItemStackHandler copyToItemStackHandler(class_1263 handler) {
        int size = handler.method_5439();
        ItemStackHandler copy = new ItemStackHandler(size);
        for (int i = 0; i < size; i++) {
            copy.method_5447(i, handler.method_5438(i).method_7972());
        }
        return copy;
    }
}
