package com.zurrtum.create.api.contraption.storage.item.menu;

import com.zurrtum.create.infrastructure.items.ItemInventory;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_11565;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class StorageInteractionWrapper implements ItemInventory {
    private final class_1263 inv;
    private final Predicate<class_1657> stillValid;
    private final Consumer<class_11565> onClose;

    public StorageInteractionWrapper(class_1263 inv, Predicate<class_1657> stillValid, Consumer<class_11565> onClose) {
        this.inv = inv;
        this.stillValid = stillValid;
        this.onClose = onClose;
    }

    @Override
    public int method_5439() {
        return inv.method_5439();
    }

    @Override
    public class_1799 method_5438(int slot) {
        return inv.method_5438(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        inv.method_5447(slot, stack);
    }

    @Override
    public int method_5444() {
        return inv.method_5444();
    }

    @Override
    public int method_58350(class_1799 stack) {
        return inv.method_58350(stack);
    }

    @Override
    public int insert(class_1799 stack) {
        return inv.insert(stack);
    }

    @Override
    public int extract(class_1799 stack) {
        return inv.extract(stack);
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return stillValid.test(player);
    }

    @Override
    public void method_5432(class_11565 player) {
        onClose.accept(player);
    }
}
