package com.zurrtum.create.catnip.animation;

import com.zurrtum.create.catnip.math.AngleHelper;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class LerpedFloat {

    protected Interpolator interpolator;
    protected float previousValue;
    protected float value;

    @Nullable
    protected Chaser chaseFunction;
    protected float chaseTarget;
    protected float chaseSpeed;
    protected boolean angularChase;

    protected boolean forcedSync;

    public LerpedFloat(Interpolator interpolator) {
        this.interpolator = interpolator;
        startWithValue(0);
        forcedSync = true;
    }

    public static LerpedFloat linear() {
        return new LerpedFloat((p, c, t) -> (float) class_3532.method_16436(p, c, t));
    }

    public static LerpedFloat angular() {
        LerpedFloat lerpedFloat = new LerpedFloat(AngleHelper::angleLerp);
        lerpedFloat.angularChase = true;
        return lerpedFloat;
    }

    public LerpedFloat startWithValue(double value) {
        float f = (float) value;
        this.previousValue = f;
        this.chaseTarget = f;
        this.value = f;
        return this;
    }

    public LerpedFloat chase(double value, double speed, Chaser chaseFunction) {
        updateChaseTarget((float) value);
        this.chaseSpeed = (float) speed;
        this.chaseFunction = chaseFunction;
        return this;
    }

    public LerpedFloat chaseTimed(double value, int ticks) {
        double diff = value - this.value;
        return chase(value, Math.abs(diff / ticks), Chaser.LINEAR);
    }

    public LerpedFloat disableSmartAngleChasing() {
        angularChase = false;
        return this;
    }

    public void updateChaseTarget(float target) {
        if (angularChase)
            target = value + AngleHelper.getShortestAngleDiff(value, target);
        this.chaseTarget = target;
    }

    public boolean updateChaseSpeed(double speed) {
        float prevSpeed = this.chaseSpeed;
        this.chaseSpeed = (float) speed;
        return !class_3532.method_20390(prevSpeed, speed);
    }

    public void tickChaser() {
        previousValue = value;
        if (chaseFunction == null)
            return;
        if (class_3532.method_20390((double) value, chaseTarget)) {
            value = chaseTarget;
            return;
        }
        value = chaseFunction.chase(value, chaseSpeed, chaseTarget);
    }

    public void setValueNoUpdate(double value) {
        this.value = (float) value;
    }

    public void setValue(double value) {
        this.previousValue = this.value;
        this.value = (float) value;
    }

    public float getValue() {
        return getValue(1);
    }

    public float getValue(float partialTicks) {
        return interpolator.interpolate(partialTicks, previousValue, value);
    }

    public boolean settled() {
        return class_3532.method_20390((double) previousValue, value) && (chaseFunction == null || class_3532.method_20390((double) value, chaseTarget));
    }

    public float getChaseTarget() {
        return chaseTarget;
    }

    public void forceNextSync() {
        forcedSync = true;
    }

    public void write(class_11372 view) {
        view.method_71464("Speed", chaseSpeed);
        view.method_71464("Target", chaseTarget);
        view.method_71464("Value", value);
        if (forcedSync)
            view.method_71472("Force", true);
        forcedSync = false;
    }

    public void read(class_11368 view, boolean clientPacket) {
        if (!clientPacket || view.method_71433("Force", false))
            startWithValue(view.method_71423("Value", 0));
        readChaser(view);
    }

    protected void readChaser(class_11368 view) {
        chaseSpeed = view.method_71423("Speed", 0);
        chaseTarget = view.method_71423("Target", 0);
    }

    @FunctionalInterface
    public interface Interpolator {
        float interpolate(double progress, double current, double target);
    }

    @FunctionalInterface
    public interface Chaser {

        Chaser IDLE = (c, s, t) -> (float) c;
        Chaser EXP = exp(Double.MAX_VALUE);
        Chaser LINEAR = (c, s, t) -> (float) (c + class_3532.method_15350(t - c, -s, s));

        static Chaser exp(double maxEffectiveSpeed) {
            return (c, s, t) -> (float) (c + class_3532.method_15350((t - c) * s, -maxEffectiveSpeed, maxEffectiveSpeed));
        }

        float chase(double current, double speed, double target);
    }

}
