package com.zurrtum.create.catnip.math;

import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_3532;

public class AngleHelper {

    public static float horizontalAngle(class_2350 facing) {
        if (facing.method_10166().method_10178())
            return 0;
        float angle = facing.method_10144();
        if (facing.method_10166() == class_2351.field_11048)
            angle = -angle;
        return angle;
    }

    public static float verticalAngle(class_2350 facing) {
        return facing == class_2350.field_11036 ? -90 : facing == class_2350.field_11033 ? 90 : 0;
    }

    public static float rad(double angle) {
        if (angle == 0)
            return 0;
        return (float) (angle / 180 * Math.PI);
    }

    public static float deg(double angle) {
        if (angle == 0)
            return 0;
        return (float) (angle * 180 / Math.PI);
    }

    public static float angleLerp(double pct, double current, double target) {
        return (float) (current + getShortestAngleDiff(current, target) * pct);
    }

    public static float getShortestAngleDiff(double current, double target) {
        current = current % 360;
        target = target % 360;
        return (float) (((((target - current) % 360) + 540) % 360) - 180);
    }

    public static float getShortestAngleDiff(double current, double target, float hint) {
        float diff = getShortestAngleDiff(current, target);
        if (class_3532.method_15347(Math.abs(diff), 180) && Math.signum(diff) != Math.signum(hint)) {
            return diff + 360 * Math.signum(hint);
        }
        return diff;
    }

    public static float wrapAngle180(float angle) {
        return (angle + 180) % 360 - 180;
    }

}
