package com.zurrtum.create.client.catnip.gui.render;

import net.minecraft.class_11256;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

public record EntityBlockRenderState(
    int id, Matrix3x2f pose, class_1937 world, class_2338 pos, class_2586 entity, class_2680 state, int x0, int y0, int x1, int y1, float scale, float size,
    float xRot, float yRot, float zRot, class_8030 bounds
) implements class_11256 {
    public static EntityBlockRenderState create(
        int id,
        class_332 graphics,
        class_1937 world,
        class_2338 pos,
        class_2586 entity,
        class_2680 state,
        int x,
        int y,
        float scale,
        int padding,
        float xRot,
        float yRot,
        float zRot
    ) {
        Matrix3x2f pose = new Matrix3x2f(graphics.method_51448());
        scale = scale * 16;
        float size = scale + padding;
        return new EntityBlockRenderState(
            id,
            pose,
            world,
            pos,
            entity,
            state,
            x,
            y,
            (int) (x + size),
            (int) (y + size),
            scale,
            size,
            class_3532.field_29847 * xRot,
            class_3532.field_29847 * yRot,
            class_3532.field_29847 * zRot,
            new class_8030(x, y, (int) size, (int) size).method_71523(pose)
        );
    }

    @Override
    public @Nullable class_8030 comp_4128() {
        return null;
    }
}
