package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_11661;
import net.minecraft.class_11684;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_7833;

public class ItemTransformElementRenderer extends class_11239<ItemTransformRenderState> {
    private static final Map<Object, GpuTexture> TEXTURES = new HashMap<>();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public ItemTransformElementRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(Object key) {
        GpuTexture texture = TEXTURES.remove(key);
        if (texture != null) {
            texture.close();
        }
    }

    @Override
    public void prepare(ItemTransformRenderState item, class_11246 state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        float size = item.comp_4133() * windowScaleFactor;
        Object key = item.getKey();
        GpuTexture texture = TEXTURES.get(key);
        boolean draw;
        if (texture == null) {
            texture = GpuTexture.create((int) size);
            TEXTURES.put(key, texture);
            draw = true;
        } else {
            draw = item.state().method_70948();
        }
        if (draw) {
            RenderSystem.setProjectionMatrix(field_60042.method_71092(size, size), class_10366.field_54954);
            texture.prepare();
            matrices.method_22903();
            matrices.method_46416(size / 2, size / 2, 0);
            if (item.padding() != 0) {
                size -= item.padding() * windowScaleFactor;
            }
            matrices.method_22905(size, -size, size);
            if (item.zRot() != 0) {
                matrices.method_22907(class_7833.field_40718.rotation(item.zRot()));
            }
            if (item.xRot() != 0) {
                matrices.method_22907(class_7833.field_40714.rotation(item.xRot()));
            }
            if (item.yRot() != 0) {
                matrices.method_22907(class_7833.field_40716.rotation(item.yRot()));
            }
            boolean blockLight = item.state().method_65608();
            class_308 lighting = class_310.method_1551().field_1773.method_71114();
            if (blockLight) {
                lighting.method_71034(class_308.class_11274.field_60027);
            } else {
                lighting.method_71034(class_308.class_11274.field_60026);
            }
            class_11684 renderDispatcher = class_310.method_1551().field_1773.method_72911();
            class_11661 queue = renderDispatcher.method_73003();
            item.state().method_65604(matrices, queue, class_765.field_32767, class_4608.field_21444, 0);
            renderDispatcher.method_73002();
            field_59933.method_22993();
            matrices.method_22909();
            texture.clear();
        }
        state.method_71996(new class_11241(
            class_10799.field_59968,
            class_11231.method_70900(texture.textureView(), RenderSystem.getSamplerCache().method_75297(FilterMode.NEAREST)),
            item.method_72127(),
            item.comp_4122(),
            item.comp_4123(),
            item.comp_4124(),
            item.comp_4125(),
            0.0F,
            1.0F,
            1.0F,
            0.0F,
            -1,
            item.comp_4128(),
            null
        ));
    }

    @Override
    protected void renderToTexture(ItemTransformRenderState item, class_4587 matrices) {
    }

    @Override
    protected String method_70906() {
        return "Item Transform";
    }

    @Override
    public Class<ItemTransformRenderState> method_70903() {
        return ItemTransformRenderState.class;
    }
}
