package com.zurrtum.create.client.catnip.impl.client.render;

import com.zurrtum.create.client.flywheel.lib.math.MatrixMath;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.UnknownNullability;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

// https://github.com/Engine-Room/Flywheel/blob/2f67f54c8898d91a48126c3c753eefa6cd224f84/common/src/lib/java/dev/engine_room/flywheel/lib/model/baked/TransformingVertexConsumer.java
public class TransformingVertexConsumer implements class_4588 {
    @UnknownNullability
    private class_4588 delegate;
    @UnknownNullability
    private class_4587 poseStack;

    public void prepare(class_4588 delegate, class_4587 poseStack) {
        this.delegate = delegate;
        this.poseStack = poseStack;
    }

    public void clear() {
        delegate = null;
        poseStack = null;
    }

    @Override
    public class_4588 method_22912(float x, float y, float z) {
        Matrix4f matrix = poseStack.method_23760().method_23761();

        delegate.method_22912(
            MatrixMath.transformPositionX(matrix, x, y, z),
            MatrixMath.transformPositionY(matrix, x, y, z),
            MatrixMath.transformPositionZ(matrix, x, y, z)
        );
        return this;
    }

    @Override
    public class_4588 method_39415(int color) {
        delegate.method_39415(color);
        return this;
    }

    @Override
    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        delegate.method_1336(red, green, blue, alpha);
        return this;
    }

    @Override
    public class_4588 method_22913(float u, float v) {
        delegate.method_22913(u, v);
        return this;
    }

    @Override
    public class_4588 method_60796(int u, int v) {
        delegate.method_60796(u, v);
        return this;
    }

    @Override
    public class_4588 method_22921(int u, int v) {
        delegate.method_22921(u, v);
        return this;
    }

    @Override
    public class_4588 method_22914(float x, float y, float z) {
        Matrix3f matrix = poseStack.method_23760().method_23762();
        delegate.method_22914(
            MatrixMath.transformNormalX(matrix, x, y, z),
            MatrixMath.transformNormalY(matrix, x, y, z),
            MatrixMath.transformNormalZ(matrix, x, y, z)
        );
        return this;
    }

    @Override
    public class_4588 method_75298(float width) {
        delegate.method_75298(width);
        return this;
    }
}
