package com.zurrtum.create.client.catnip.impl.client.render.model;

import com.zurrtum.create.client.catnip.client.render.model.ShadeSeparatedBufferSource;
import net.minecraft.class_11515;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_777;
import org.jetbrains.annotations.UnknownNullability;

// Modified from https://github.com/Engine-Room/Flywheel/blob/2f67f54c8898d91a48126c3c753eefa6cd224f84/forge/src/lib/java/dev/engine_room/flywheel/lib/model/baked/MeshEmitter.java
public class UniversalMeshEmitter implements class_4588 {
    @UnknownNullability
    private ShadeSeparatedBufferSource bufferSource;
    @UnknownNullability
    private class_11515 layer;

    public void prepare(ShadeSeparatedBufferSource bufferSource, class_11515 layer) {
        this.bufferSource = bufferSource;
        this.layer = layer;
    }

    public void clear() {
        bufferSource = null;
    }

    @Override
    public void method_22919(class_4587.class_4665 pose, class_777 quad, float red, float green, float blue, float alpha, int light, int overlay) {
        class_4588 buffer = bufferSource.getBuffer(layer, quad.comp_3725());
        buffer.method_22919(pose, quad, red, green, blue, alpha, light, overlay);
    }

    @Override
    public void method_22920(
        class_4587.class_4665 pose,
        class_777 quad,
        float[] brightnesses,
        float red,
        float green,
        float blue,
        float alpha,
        int[] lights,
        int overlay
    ) {
        class_4588 buffer = bufferSource.getBuffer(layer, quad.comp_3725());
        buffer.method_22920(pose, quad, brightnesses, red, green, blue, alpha, lights, overlay);
    }

    @Override
    public class_4588 method_22912(float x, float y, float z) {
        throw new UnsupportedOperationException("UniversalMeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_39415(int color) {
        throw new UnsupportedOperationException("UniversalMeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        throw new UnsupportedOperationException("UniversalMeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_22913(float u, float v) {
        throw new UnsupportedOperationException("UniversalMeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_60796(int u, int v) {
        throw new UnsupportedOperationException("UniversalMeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_22921(int u, int v) {
        throw new UnsupportedOperationException("UniversalMeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_22914(float x, float y, float z) {
        throw new UnsupportedOperationException("UniversalMeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_75298(float width) {
        throw new UnsupportedOperationException("UniversalMeshEmitter only supports putBulkData!");
    }
}
