package com.zurrtum.create.client.compat.jei;

import com.zurrtum.create.AllFluids;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.compat.jei.category.*;
import com.zurrtum.create.client.compat.jei.display.BlockCuttingDisplay;
import com.zurrtum.create.client.compat.jei.display.MysteriousItemConversionDisplay;
import com.zurrtum.create.client.content.equipment.blueprint.BlueprintScreen;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelSetItemScreen;
import com.zurrtum.create.client.content.logistics.filter.AbstractFilterScreen;
import com.zurrtum.create.client.content.logistics.redstoneRequester.RedstoneRequesterScreen;
import com.zurrtum.create.client.content.redstone.link.controller.LinkedControllerScreen;
import com.zurrtum.create.client.content.trains.schedule.ScheduleScreen;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlock;
import com.zurrtum.create.content.fluids.transfer.EmptyingRecipe;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.zurrtum.create.content.kinetics.crusher.AbstractCrushingRecipe;
import com.zurrtum.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.zurrtum.create.content.kinetics.deployer.ManualApplicationRecipe;
import com.zurrtum.create.content.kinetics.fan.processing.HauntingRecipe;
import com.zurrtum.create.content.kinetics.fan.processing.SplashingRecipe;
import com.zurrtum.create.content.kinetics.millstone.MillingRecipe;
import com.zurrtum.create.content.kinetics.mixer.CompactingRecipe;
import com.zurrtum.create.content.kinetics.mixer.MixingRecipe;
import com.zurrtum.create.content.kinetics.mixer.PotionRecipe;
import com.zurrtum.create.content.kinetics.press.PressingRecipe;
import com.zurrtum.create.content.kinetics.saw.CuttingRecipe;
import com.zurrtum.create.content.processing.sequenced.SequencedAssemblyRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.*;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import net.minecraft.class_10289;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_2960;
import net.minecraft.class_3862;
import net.minecraft.class_3955;
import net.minecraft.class_3972;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.world.item.crafting.*;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import static com.zurrtum.create.Create.MOD_ID;

@JeiPlugin
public class JeiClientPlugin implements IModPlugin {
    public static final class_2960 ID = Create.asResource("jei_plugin");
    public static final IRecipeType<class_8786<class_3955>> AUTOMATIC_PACKING = createRecipeHolderType("automatic_packing");
    public static final IRecipeType<class_8786<CompactingRecipe>> PACKING = createRecipeHolderType("packing");
    public static final IRecipeType<class_8786<PressingRecipe>> PRESSING = createRecipeHolderType("pressing");
    public static final IRecipeType<class_8786<class_1867>> AUTOMATIC_SHAPELESS = createRecipeHolderType("automatic_shapeless");
    public static final IRecipeType<class_8786<MixingRecipe>> MIXING = createRecipeHolderType("mixing");
    public static final IRecipeType<class_8786<MillingRecipe>> MILLING = createRecipeHolderType("milling");
    public static final IRecipeType<class_8786<CuttingRecipe>> SAWING = createRecipeHolderType("sawing");
    public static final IRecipeType<class_8786<? extends AbstractCrushingRecipe>> CRUSHING = createRecipeHolderType("crushing");
    public static final IRecipeType<class_8786<ManualApplicationRecipe>> ITEM_APPLICATION = createRecipeHolderType("item_application");
    public static final IRecipeType<class_8786<? extends ItemApplicationRecipe>> DEPLOYING = createRecipeHolderType("deploying");
    public static final IRecipeType<class_8786<EmptyingRecipe>> DRAINING = createRecipeHolderType("draining");
    public static final IRecipeType<class_8786<MechanicalCraftingRecipe>> MECHANICAL_CRAFTING = createRecipeHolderType("mechanical_crafting");
    public static final IRecipeType<class_8786<FillingRecipe>> SPOUT_FILLING = createRecipeHolderType("spout_filling");
    public static final IRecipeType<class_8786<SandPaperPolishingRecipe>> SANDPAPER_POLISHING = createRecipeHolderType("sandpaper_polishing");
    public static final IRecipeType<class_8786<SequencedAssemblyRecipe>> SEQUENCED_ASSEMBLY = createRecipeHolderType("sequenced_assembly");
    public static final IRecipeType<class_8786<? extends class_3972>> FAN_BLASTING = createRecipeHolderType("fan_blasting");
    public static final IRecipeType<class_8786<HauntingRecipe>> FAN_HAUNTING = createRecipeHolderType("fan_haunting");
    public static final IRecipeType<class_8786<class_3862>> FAN_SMOKING = createRecipeHolderType("fan_smoking");
    public static final IRecipeType<class_8786<SplashingRecipe>> FAN_WASHING = createRecipeHolderType("fan_washing");
    public static final IRecipeType<class_8786<PotionRecipe>> AUTOMATIC_BREWING = createRecipeHolderType("automatic_brewing");
    public static final IRecipeType<MysteriousItemConversionDisplay> MYSTERY_CONVERSION = IRecipeType.create(
        MOD_ID,
        "mystery_conversion",
        MysteriousItemConversionDisplay.class
    );
    public static final IRecipeType<BlockCuttingDisplay> BLOCK_CUTTING = IRecipeType.create(MOD_ID, "block_cutting", BlockCuttingDisplay.class);

    @SuppressWarnings("unchecked")
    public static <T> IRecipeType<T> createRecipeHolderType(String path) {
        class_2960 uid = class_2960.method_60655(MOD_ID, path);
        return (IRecipeType<T>) IRecipeType.create(uid, class_8786.class);
    }

    @Override
    @NotNull
    public class_2960 getPluginUid() {
        return ID;
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(
            new AutoCompactingCategory(),
            new CompactingCategory(),
            new PressingCategory(),
            new AutoMixingCategory(),
            new MixingCategory(),
            new MillingCategory(),
            new SawingCategory(),
            new CrushingCategory(),
            new MysteriousItemConversionCategory(),
            new ManualApplicationCategory(),
            new DeployingCategory(),
            new DrainingCategory(),
            new MechanicalCraftingCategory(),
            new SpoutFillingCategory(),
            new SandpaperPolishingCategory(),
            new SequencedAssemblyCategory(),
            new FanBlastingCategory(),
            new FanHauntingCategory(),
            new FanSmokingCategory(),
            new FanWashingCategory(),
            new PotionCategory(),
            new BlockCuttingCategory()
        );
    }

    @Override
    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(AUTOMATIC_PACKING, AllItems.MECHANICAL_PRESS, AllItems.BASIN);
        registration.addCraftingStation(PACKING, AllItems.MECHANICAL_PRESS, AllItems.BASIN);
        registration.addCraftingStation(PRESSING, AllItems.MECHANICAL_PRESS);
        registration.addCraftingStation(AUTOMATIC_SHAPELESS, AllItems.MECHANICAL_MIXER, AllItems.BASIN);
        registration.addCraftingStation(MIXING, AllItems.MECHANICAL_MIXER, AllItems.BASIN);
        registration.addCraftingStation(MILLING, AllItems.MILLSTONE);
        registration.addCraftingStation(SAWING, AllItems.MECHANICAL_SAW);
        registration.addCraftingStation(CRUSHING, AllItems.CRUSHING_WHEEL);
        registration.addCraftingStation(DEPLOYING, AllItems.DEPLOYER, AllItems.DEPOT, AllItems.BELT_CONNECTOR);
        registration.addCraftingStation(DRAINING, AllItems.ITEM_DRAIN);
        registration.addCraftingStation(MECHANICAL_CRAFTING, AllItems.MECHANICAL_CRAFTER);
        registration.addCraftingStation(SPOUT_FILLING, AllItems.SPOUT);
        registration.addCraftingStation(SANDPAPER_POLISHING, AllItems.SAND_PAPER, AllItems.RED_SAND_PAPER);
        registration.addCraftingStation(FAN_BLASTING, AllItems.ENCASED_FAN);
        registration.addCraftingStation(FAN_HAUNTING, AllItems.ENCASED_FAN);
        registration.addCraftingStation(FAN_SMOKING, AllItems.ENCASED_FAN);
        registration.addCraftingStation(FAN_WASHING, AllItems.ENCASED_FAN);
        registration.addCraftingStation(AUTOMATIC_BREWING, AllItems.MECHANICAL_MIXER, AllItems.BASIN);
        registration.addCraftingStation(BLOCK_CUTTING, AllItems.MECHANICAL_SAW);
    }

    @Override
    public void registerRecipes(IRecipeRegistration registration) {
        class_10289 preparedRecipes = Internal.getClientSyncedRecipes();
        registration.addRecipes(AUTOMATIC_PACKING, AutoCompactingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(PACKING, CompactingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(PRESSING, PressingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(AUTOMATIC_SHAPELESS, AutoMixingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(MIXING, MixingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(MILLING, MillingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(SAWING, SawingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(CRUSHING, CrushingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(MYSTERY_CONVERSION, MysteriousItemConversionCategory.getRecipes());
        registration.addRecipes(ITEM_APPLICATION, ManualApplicationCategory.getRecipes(preparedRecipes));
        registration.addRecipes(DEPLOYING, DeployingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(MECHANICAL_CRAFTING, MechanicalCraftingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(SANDPAPER_POLISHING, SandpaperPolishingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(SEQUENCED_ASSEMBLY, SequencedAssemblyCategory.getRecipes(preparedRecipes));
        registration.addRecipes(FAN_BLASTING, FanBlastingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(FAN_HAUNTING, FanHauntingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(FAN_SMOKING, FanSmokingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(FAN_WASHING, FanWashingCategory.getRecipes(preparedRecipes));
        registration.addRecipes(AUTOMATIC_BREWING, PotionCategory.getRecipes(preparedRecipes));
        IIngredientManager ingredientManager = registration.getIngredientManager();
        Collection<class_1799> stacks = ingredientManager.getAllIngredients(VanillaTypes.ITEM_STACK);
        registration.addRecipes(DRAINING, DrainingCategory.getRecipes(preparedRecipes, stacks.stream()));
        registration.addRecipes(
            SPOUT_FILLING,
            SpoutFillingCategory.getRecipes(preparedRecipes, stacks.stream(), ingredientManager.getAllIngredients(FabricTypes.FLUID_STACK).stream())
        );
        registerToolboxRecipes(registration);
        registration.addRecipes(BLOCK_CUTTING, BlockCuttingCategory.getRecipes(preparedRecipes));
    }

    public static void registerToolboxRecipes(IRecipeRegistration registration) {
        List<class_6880<class_1792>> toolboxes = new ArrayList<>();
        for (class_6880<class_1792> entry : class_7923.field_41178.method_40286(AllItemTags.TOOLBOXES)) {
            toolboxes.add(entry);
        }
        class_1856 ingredient = class_1856.method_8106(class_6885.method_40242(toolboxes));
        String group = "create.toolbox.color";
        List<class_8786<class_3955>> recipes = new ArrayList<>();
        for (class_1767 color : class_1767.values()) {
            recipes.add(new class_8786<>(
                class_5321.method_29179(class_7924.field_52178, class_2960.method_60655(MOD_ID, group + "/" + color)), new class_1867(
                group,
                class_7710.field_40251,
                ToolboxBlock.getColorBlock(color).method_8389().method_7854(),
                List.of(class_1856.method_8101(class_1769.method_7803(color)), ingredient)
            )
            ));
        }
        registration.addRecipes(RecipeTypes.CRAFTING, recipes);
    }

    @Override
    public <T> void registerFluidSubtypes(ISubtypeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        registration.registerSubtypeInterpreter(FabricTypes.FLUID_STACK, AllFluids.POTION, PotionFluidSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(FabricTypes.FLUID_STACK, AllFluids.POTION.method_15750(), PotionFluidSubtypeInterpreter.INSTANCE);
    }

    @Override
    @SuppressWarnings({"unchecked", "rawtypes"})
    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AbstractSimiContainerScreen.class, new JeiExclusionZones());
        registration.addGhostIngredientHandler(AbstractFilterScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(BlueprintScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(LinkedControllerScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(ScheduleScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(RedstoneRequesterScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(FactoryPanelSetItemScreen.class, new GhostIngredientHandler());
    }
}
