package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.TwoIconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.FanRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_10289;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3612;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3956;
import net.minecraft.class_3972;
import net.minecraft.class_638;
import net.minecraft.class_8786;
import net.minecraft.class_9696;
import net.minecraft.world.item.crafting.*;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class FanBlastingCategory extends CreateCategory<class_8786<? extends class_3972>> {
    public static List<class_8786<? extends class_3972>> getRecipes(class_10289 preparedRecipes) {
        List<class_8786<? extends class_3972>> recipes = new ArrayList<>();
        Collection<class_8786<class_3859>> blastingRecipes = preparedRecipes.method_64698(class_3956.field_17547);
        Collection<class_8786<class_3862>> smokingRecipes = preparedRecipes.method_64698(class_3956.field_17548);
        class_638 world = class_310.method_1551().field_1687;
        for (class_8786<class_3859> entry : blastingRecipes) {
            addRecipe(recipes, entry, world, null, smokingRecipes);
        }
        for (class_8786<class_3861> entry : preparedRecipes.method_64698(class_3956.field_17546)) {
            addRecipe(recipes, entry, world, blastingRecipes, smokingRecipes);
        }
        return recipes;
    }

    private static void addRecipe(
        List<class_8786<? extends class_3972>> list,
        class_8786<? extends class_3972> entry,
        class_638 world,
        Collection<class_8786<class_3859>> blastingRecipes,
        Collection<class_8786<class_3862>> smokingRecipes
    ) {
        if (!AllRecipeTypes.CAN_BE_AUTOMATED.test(entry)) {
            return;
        }
        class_3972 recipe = entry.comp_1933();
        class_1856 ingredient = recipe.method_64720();
        Optional<class_1799> firstInput = ingredient.field_9019.method_40239().findFirst().map(item -> item.comp_349().method_7854());
        if (firstInput.isEmpty()) {
            return;
        }
        class_9696 input = new class_9696(firstInput.get());
        if (blastingRecipes != null) {
            Optional<class_8786<class_3859>> blastingRecipe = blastingRecipes.stream().filter(e -> e.comp_1933().method_64719(input, world)).findFirst()
                .filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            if (blastingRecipe.isPresent()) {
                return;
            }
        }
        Optional<class_8786<class_3862>> smokingRecipe = smokingRecipes.stream().filter(e -> e.comp_1933().method_64719(input, world)).findFirst()
            .filter(AllRecipeTypes.CAN_BE_AUTOMATED);
        if (smokingRecipe.isPresent()) {
            return;
        }
        list.add(entry);
    }

    @Override
    @NotNull
    public IRecipeType<class_8786<? extends class_3972>> getRecipeType() {
        return JeiClientPlugin.FAN_BLASTING;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.fan_blasting");
    }

    @Override
    public IDrawable getIcon() {
        return new TwoIconRenderer(AllItems.PROPELLER, class_1802.field_8187);
    }

    @Override
    public int getHeight() {
        return 72;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<? extends class_3972> entry, IFocusGroup focuses) {
        class_3972 recipe = entry.comp_1933();
        builder.addInputSlot(21, 48).setBackground(SLOT, -1, -1).add(recipe.method_64720());
        builder.addOutputSlot(141, 48).setBackground(SLOT, -1, -1).add(recipe.method_64721());
    }

    @Override
    public void draw(
        class_8786<? extends class_3972> entry,
        IRecipeSlotsView recipeSlotsView,
        class_332 graphics,
        double mouseX,
        double mouseY
    ) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 46, 27);
        AllGuiTextures.JEI_LIGHT.render(graphics, 65, 39);
        AllGuiTextures.JEI_LONG_ARROW.render(graphics, 54, 51);
        graphics.field_59826.method_70922(new FanRenderState(
            new Matrix3x2f(graphics.method_51448()),
            56,
            4,
            class_3612.field_15908.method_15785().method_15759()
        ));
    }
}
