package com.zurrtum.create.client.compat.rei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.compat.rei.CreateCategory;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.DeployerRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.compat.rei.display.DeployingDisplay;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;

import java.util.List;

public class DeployingCategory extends CreateCategory<DeployingDisplay> {
    @Override
    public CategoryIdentifier<? extends DeployingDisplay> getCategoryIdentifier() {
        return ReiCommonPlugin.DEPLOYING;
    }

    @Override
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.deploying");
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of(AllItems.DEPLOYER);
    }

    @Override
    public void addWidgets(List<Widget> widgets, DeployingDisplay display, Rectangle bounds) {
        Point input = new Point(bounds.x + 56, bounds.y + 10);
        Point target = new Point(bounds.x + 32, bounds.y + 56);
        Point output = new Point(bounds.x + 137, bounds.y + 56);
        widgets.add(Widgets.createDrawableWidget((class_332 graphics, int mouseX, int mouseY, float delta) -> {
            drawSlotBackground(graphics, input, target, output);
            AllGuiTextures.JEI_SHADOW.render(graphics, bounds.x + 67, bounds.y + 62);
            AllGuiTextures.JEI_DOWN_ARROW.render(graphics, bounds.x + 131, bounds.y + 34);
            graphics.field_59826.method_70922(new DeployerRenderState(
                new Matrix3x2f(graphics.method_51448()),
                bounds.x + 80,
                bounds.y - 5
            ));
        }));
        widgets.add(createInputSlot(input).entries(display.input()));
        widgets.add(createInputSlot(target).entries(display.target()));
        widgets.add(createOutputSlot(output).entries(display.output()));
    }

    @Override
    public int getDisplayHeight() {
        return 80;
    }
}
