package com.zurrtum.create.client.content.contraptions;

import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.*;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity.ContraptionRotationState;
import com.zurrtum.create.content.contraptions.ContraptionCollider.PlayerType;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.foundation.collision.ContinuousOBBCollider;
import com.zurrtum.create.foundation.collision.Matrix3d;
import com.zurrtum.create.foundation.collision.OrientedBB;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.ClientMotionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ContraptionColliderLockPacketRequest;
import com.zurrtum.create.infrastructure.packet.c2s.TrainCollisionPacket;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.MutablePair;

import java.lang.ref.WeakReference;
import java.util.*;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1311;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_745;
import net.minecraft.class_746;

public class ContraptionColliderClient {
    private static MutablePair<WeakReference<AbstractContraptionEntity>, Double> safetyLock = new MutablePair<>();
    private static Map<AbstractContraptionEntity, Map<class_1657, Double>> remoteSafetyLocks = new WeakHashMap<>();

    static void collideEntities(AbstractContraptionEntity contraptionEntity) {
        Contraption contraption = contraptionEntity.getContraption();
        if (contraption == null)
            return;
        class_238 bounds = contraptionEntity.method_5829();
        if (bounds == null)
            return;

        class_243 contraptionPosition = contraptionEntity.method_73189();
        class_243 contraptionMotion = contraptionPosition.method_1020(contraptionEntity.getPrevPositionVec());
        class_243 anchorVec = contraptionEntity.getAnchorVec();
        ContraptionRotationState rotation = null;

        if (safetyLock.left != null && safetyLock.left.get() == contraptionEntity)
            saveClientPlayerFromClipping(contraptionEntity, contraptionMotion);

        // After death, multiple refs to the client player may show up in the area
        boolean skipClientPlayer = false;

        class_1937 world = contraptionEntity.method_73183();
        List<class_1297> entitiesWithinAABB = world.method_8390(
            class_1297.class,
            bounds.method_1014(2).method_1012(0, 32, 0),
            contraptionEntity::method_30949
        );
        for (class_1297 entity : entitiesWithinAABB) {
            if (!entity.method_5805())
                continue;

            PlayerType playerType = getPlayerType(entity);
            if (playerType == PlayerType.REMOTE) {
                if (!(contraption instanceof TranslatingContraption))
                    continue;
                saveRemotePlayerFromClipping((class_1657) entity, contraptionEntity, contraptionMotion);
                continue;
            }

            entity.method_24204().forEach(e -> {
                if (e instanceof class_3222 playerEntity)
                    playerEntity.field_13987.field_14138 = 0;
            });

            if (playerType == PlayerType.CLIENT) {
                if (skipClientPlayer)
                    continue;
                else
                    skipClientPlayer = true;
            }

            // Init matrix
            if (rotation == null)
                rotation = contraptionEntity.getRotationState();
            Matrix3d rotationMatrix = rotation.asMatrix();

            // Transform entity position and motion to local space
            class_243 entityPosition = entity.method_73189();
            class_238 entityBounds = entity.method_5829();
            class_243 motion = entity.method_18798();
            float yawOffset = rotation.getYawOffset();
            class_243 position = ContraptionCollider.getWorldToLocalTranslation(entity, anchorVec, rotationMatrix, yawOffset);

            // Make player 'shorter' to make it less likely to become stuck
            if (playerType == PlayerType.CLIENT && entityBounds.method_17940() > 1)
                entityBounds = entityBounds.method_1002(0, 2 / 16f, 0);

            motion = motion.method_1020(contraptionMotion);
            motion = rotationMatrix.transform(motion);

            // Prepare entity bounds
            class_238 localBB = entityBounds.method_997(position).method_1014(1.0E-7D);

            OrientedBB obb = new OrientedBB(localBB);
            obb.setRotation(rotationMatrix);

            // Use simplified bbs when present
            final class_243 motionCopy = motion;
            List<class_238> collidableBBs = contraption.getSimplifiedEntityColliders().orElseGet(() -> {

                // Else find 'nearby' individual block shapes to collide with
                List<class_238> bbs = new ArrayList<>();
                List<class_265> potentialHits = ContraptionCollider.getPotentiallyCollidedShapes(
                    world,
                    contraption,
                    localBB.method_18804(motionCopy)
                );
                potentialHits.forEach(shape -> bbs.addAll(shape.method_1090()));
                return bbs;

            });

            MutableObject<class_243> collisionResponse = new MutableObject<>(class_243.field_1353);
            MutableObject<class_243> normal = new MutableObject<>(class_243.field_1353);
            MutableObject<class_243> location = new MutableObject<>(class_243.field_1353);
            MutableBoolean surfaceCollision = new MutableBoolean(false);
            MutableFloat temporalResponse = new MutableFloat(1);
            class_243 obbCenter = obb.getCenter();

            // Apply separation maths
            boolean doHorizontalPass = !rotation.hasVerticalRotation();
            for (boolean horizontalPass : Iterate.trueAndFalse) {
                boolean verticalPass = !horizontalPass || !doHorizontalPass;

                for (class_238 bb : collidableBBs) {
                    class_243 currentResponse = collisionResponse.getValue();
                    class_243 currentCenter = obbCenter.method_1019(currentResponse);

                    if (Math.abs(currentCenter.field_1352 - bb.method_1005().field_1352) - entityBounds.method_17939() - 1 > bb.method_17939() / 2)
                        continue;
                    if (Math.abs((currentCenter.field_1351 + motion.field_1351) - bb.method_1005().field_1351) - entityBounds.method_17940() - 1 > bb.method_17940() / 2)
                        continue;
                    if (Math.abs(currentCenter.field_1350 - bb.method_1005().field_1350) - entityBounds.method_17941() - 1 > bb.method_17941() / 2)
                        continue;

                    obb.setCenter(currentCenter);
                    ContinuousOBBCollider.ContinuousSeparationManifold intersect = obb.intersect(bb, motion);

                    if (intersect == null)
                        continue;
                    if (verticalPass && surfaceCollision.isFalse())
                        surfaceCollision.setValue(intersect.isSurfaceCollision());

                    double timeOfImpact = intersect.getTimeOfImpact();
                    boolean isTemporal = timeOfImpact > 0 && timeOfImpact < 1;
                    class_243 collidingNormal = intersect.getCollisionNormal();
                    class_243 collisionPosition = intersect.getCollisionPosition();

                    if (!isTemporal) {
                        class_243 separation = intersect.asSeparationVec(entity.method_49476());
                        if (separation != null && !separation.equals(class_243.field_1353)) {
                            collisionResponse.setValue(currentResponse.method_1019(separation));
                            timeOfImpact = 0;
                        }
                    }

                    boolean nearest = timeOfImpact >= 0 && temporalResponse.getValue() > timeOfImpact;
                    if (collidingNormal != null && nearest)
                        normal.setValue(collidingNormal);
                    if (collisionPosition != null && nearest)
                        location.setValue(collisionPosition);

                    if (isTemporal) {
                        if (temporalResponse.getValue() > timeOfImpact)
                            temporalResponse.setValue(timeOfImpact);
                    }
                }

                if (verticalPass)
                    break;

                boolean noVerticalMotionResponse = temporalResponse.getValue() == 1;
                boolean noVerticalCollision = collisionResponse.getValue().field_1351 == 0;
                if (noVerticalCollision && noVerticalMotionResponse)
                    break;

                // Re-run collisions with horizontal offset
                collisionResponse.setValue(collisionResponse.getValue().method_18805(129 / 128f, 0, 129 / 128f));
            }

            // Resolve collision
            class_243 entityMotion = entity.method_18798();
            class_243 entityMotionNoTemporal = entityMotion;
            class_243 collisionNormal = normal.getValue();
            class_243 collisionLocation = location.getValue();
            class_243 totalResponse = collisionResponse.getValue();
            boolean hardCollision = !totalResponse.equals(class_243.field_1353);
            boolean temporalCollision = temporalResponse.getValue() != 1;
            class_243 motionResponse = !temporalCollision ? motion : motion.method_1029().method_1021(motion.method_1033() * temporalResponse.getValue());

            rotationMatrix.transpose();
            motionResponse = rotationMatrix.transform(motionResponse).method_1019(contraptionMotion);
            totalResponse = rotationMatrix.transform(totalResponse);
            totalResponse = VecHelper.rotate(totalResponse, yawOffset, class_2350.class_2351.field_11052);
            collisionNormal = rotationMatrix.transform(collisionNormal);
            collisionNormal = VecHelper.rotate(collisionNormal, yawOffset, class_2350.class_2351.field_11052);
            collisionNormal = collisionNormal.method_1029();
            collisionLocation = rotationMatrix.transform(collisionLocation);
            collisionLocation = VecHelper.rotate(collisionLocation, yawOffset, class_2350.class_2351.field_11052);
            rotationMatrix.transpose();

            double bounce = 0;
            double slide = 0;

            if (!collisionLocation.equals(class_243.field_1353)) {
                collisionLocation = collisionLocation.method_1019(entity.method_73189().method_1019(entity.method_5829().method_1005()).method_1021(.5f));
                if (temporalCollision)
                    collisionLocation = collisionLocation.method_1031(0, motionResponse.field_1351, 0);

                class_2338 pos = class_2338.method_49638(contraptionEntity.toLocalVector(entity.method_73189(), 0));
                if (contraption.getBlocks().containsKey(pos)) {
                    class_2680 blockState = contraption.getBlocks().get(pos).comp_1342();
                    if (blockState.method_26164(class_3481.field_22414)) {
                        surfaceCollision.setTrue();
                        totalResponse = totalResponse.method_1031(0, .1f, 0);
                    }
                }

                pos = class_2338.method_49638(contraptionEntity.toLocalVector(collisionLocation, 0));
                if (contraption.getBlocks().containsKey(pos)) {
                    class_2680 blockState = contraption.getBlocks().get(pos).comp_1342();

                    MovingInteractionBehaviour movingInteractionBehaviour = contraption.getInteractors().get(pos);
                    if (movingInteractionBehaviour != null)
                        movingInteractionBehaviour.handleEntityCollision(entity, pos, contraptionEntity);

                    bounce = BlockHelper.getBounceMultiplier(blockState.method_26204());
                    slide = Math.max(0, blockState.method_26204().method_9499() - .6f);
                }
            }

            boolean hasNormal = !collisionNormal.equals(class_243.field_1353);
            boolean anyCollision = hardCollision || temporalCollision;

            if (bounce > 0 && hasNormal && anyCollision && ContraptionCollider.bounceEntity(entity, collisionNormal, contraptionEntity, bounce)) {
                entity.method_73183().method_43128(
                    playerType == PlayerType.CLIENT ? entity : null,
                    entity.method_23317(),
                    entity.method_23318(),
                    entity.method_23321(),
                    class_3417.field_14560,
                    class_3419.field_15245,
                    .5f,
                    1
                );
                continue;
            }

            if (temporalCollision) {
                double idealVerticalMotion = motionResponse.field_1351;
                if (idealVerticalMotion != entityMotion.field_1351) {
                    entity.method_18799(entityMotion.method_18805(1, 0, 1).method_1031(0, idealVerticalMotion, 0));
                    entityMotion = entity.method_18798();
                }
            }

            if (hardCollision) {
                double motionX = entityMotion.method_10216();
                double motionY = entityMotion.method_10214();
                double motionZ = entityMotion.method_10215();
                double intersectX = totalResponse.method_10216();
                double intersectY = totalResponse.method_10214();
                double intersectZ = totalResponse.method_10215();

                double horizonalEpsilon = 1 / 128f;
                if (motionX != 0 && Math.abs(intersectX) > horizonalEpsilon && motionX > 0 == intersectX < 0)
                    entityMotion = entityMotion.method_18805(0, 1, 1);
                if (motionY != 0 && intersectY != 0 && motionY > 0 == intersectY < 0)
                    entityMotion = entityMotion.method_18805(1, 0, 1).method_1031(0, contraptionMotion.field_1351, 0);
                if (motionZ != 0 && Math.abs(intersectZ) > horizonalEpsilon && motionZ > 0 == intersectZ < 0)
                    entityMotion = entityMotion.method_18805(1, 1, 0);

            }

            if (bounce == 0 && slide > 0 && hasNormal && anyCollision && rotation.hasVerticalRotation()) {
                double slideFactor = collisionNormal.method_18805(1, 0, 1).method_1033() * 1.25f;
                class_243 motionIn = entityMotionNoTemporal.method_18805(0, .9, 0).method_1031(0, -.01f, 0);
                class_243 slideNormal = collisionNormal.method_1036(motionIn.method_1036(collisionNormal)).method_1029();
                class_243 newMotion = entityMotion.method_18805(.85, 0, .85)
                    .method_1019(slideNormal.method_1021((.2f + slide) * motionIn.method_1033() * slideFactor).method_1031(0, -.1f - collisionNormal.field_1351 * .125f, 0));
                entity.method_18799(newMotion);
                entityMotion = entity.method_18798();
            }

            if (!hardCollision && surfaceCollision.isFalse())
                continue;

            class_243 allowedMovement = ContraptionCollider.collide(totalResponse, entity);
            entity.method_5814(entityPosition.field_1352 + allowedMovement.field_1352, entityPosition.field_1351 + allowedMovement.field_1351, entityPosition.field_1350 + allowedMovement.field_1350);
            entityPosition = entity.method_73189();

            entityMotion = handleDamageFromTrain(world, contraptionEntity, contraptionMotion, entity, entityMotion, playerType);

            entity.field_6037 = true;
            class_243 contactPointMotion = class_243.field_1353;

            if (surfaceCollision.isTrue()) {
                contraptionEntity.registerColliding(entity);
                entity.field_6017 = 0;
                for (class_1297 rider : entity.method_5736())
                    if (getPlayerType(rider) == PlayerType.CLIENT)
                        class_310.method_1551().field_1724.field_3944.method_52787(new ClientMotionPacket(rider.method_18798(), true, 0));
                boolean canWalk = bounce != 0 || slide == 0;
                if (canWalk || !rotation.hasVerticalRotation()) {
                    if (canWalk)
                        entity.method_24830(true);
                    if (entity instanceof class_1542)
                        entityMotion = entityMotion.method_18805(.5f, 1, .5f);
                }
                contactPointMotion = contraptionEntity.getContactPointMotion(entityPosition);
                allowedMovement = ContraptionCollider.collide(contactPointMotion, entity);
                entity.method_5814(entityPosition.field_1352 + allowedMovement.field_1352, entityPosition.field_1351, entityPosition.field_1350 + allowedMovement.field_1350);
            }

            entity.method_18799(entityMotion);

            if (playerType != PlayerType.CLIENT)
                continue;

            double d0 = entity.method_23317() - entity.field_6014 - contactPointMotion.field_1352;
            double d1 = entity.method_23321() - entity.field_5969 - contactPointMotion.field_1350;
            float limbSwing = class_3532.method_15355((float) (d0 * d0 + d1 * d1)) * 4.0F;
            if (limbSwing > 1.0F)
                limbSwing = 1.0F;
            class_310.method_1551().field_1724.field_3944.method_52787(new ClientMotionPacket(entityMotion, true, limbSwing));

            if (entity.method_24828() && contraption instanceof TranslatingContraption) {
                safetyLock.setLeft(new WeakReference<>(contraptionEntity));
                safetyLock.setRight(entity.method_23318() - contraptionEntity.method_23318());
            }
        }

    }

    private static class_243 handleDamageFromTrain(
        class_1937 world,
        AbstractContraptionEntity contraptionEntity,
        class_243 contraptionMotion,
        class_1297 entity,
        class_243 entityMotion,
        PlayerType playerType
    ) {
        if (!(contraptionEntity instanceof CarriageContraptionEntity cce))
            return entityMotion;
        if (!entity.method_24828())
            return entityMotion;

        if (AllSynchedDatas.CONTRAPTION_GROUNDED.get(entity)) {
            AllSynchedDatas.CONTRAPTION_GROUNDED.set(entity, false);
            return entityMotion;
        }

        if (cce.collidingEntities.containsKey(entity))
            return entityMotion;
        if (entity instanceof class_1542)
            return entityMotion;
        if (cce.nonDamageTicks != 0)
            return entityMotion;
        if (!AllConfigs.server().trains.trainsCauseDamage.get())
            return entityMotion;

        class_243 diffMotion = contraptionMotion.method_1020(entity.method_18798());

        if (diffMotion.method_1033() <= 0.35f || contraptionMotion.method_1033() <= 0.35f)
            return entityMotion;

        class_1282 source = AllDamageSources.get(world).runOver(contraptionEntity);
        double damage = diffMotion.method_1033();
        if (entity.method_5864().method_5891() == class_1311.field_6302)
            damage *= 2;

        if (entity instanceof class_1657 p && (p.method_68878() || p.method_7325()))
            return entityMotion;

        if (playerType == PlayerType.CLIENT) {
            ((class_746) entity).field_3944.method_52787(new TrainCollisionPacket((int) (damage * 16), contraptionEntity.method_5628()));
            world.method_8396(entity, entity.method_24515(), class_3417.field_15016, class_3419.field_15254, 1, .75f);
        }

        class_243 added = entityMotion.method_1019(contraptionMotion.method_18805(1, 0, 1).method_1029().method_1031(0, .25, 0).method_1021(damage * 4)).method_1019(diffMotion);

        return VecHelper.clamp(added, 3);
    }

    private static int packetCooldown = 0;

    private static void saveClientPlayerFromClipping(AbstractContraptionEntity contraptionEntity, class_243 contraptionMotion) {
        class_746 entity = class_310.method_1551().field_1724;
        if (entity.method_5765())
            return;

        double prevDiff = safetyLock.right;
        double currentDiff = entity.method_23318() - contraptionEntity.method_23318();
        double motion = contraptionMotion.method_1020(entity.method_18798()).field_1351;
        double trend = Math.signum(currentDiff - prevDiff);

        class_634 handler = entity.field_3944;
        if (handler.method_2880().size() > 1) {
            if (packetCooldown > 0)
                packetCooldown--;
            if (packetCooldown == 0) {
                handler.method_52787(new ContraptionColliderLockPacketRequest(contraptionEntity.method_5628(), currentDiff));
                packetCooldown = 3;
            }
        }

        if (trend == 0)
            return;
        if (trend == Math.signum(motion))
            return;

        double speed = contraptionMotion.method_18805(0, 1, 0).method_1027();
        if (trend > 0 && speed < 0.1)
            return;
        if (speed < 0.05)
            return;

        if (!savePlayerFromClipping(entity, contraptionEntity, contraptionMotion, prevDiff))
            safetyLock.setLeft(null);
    }

    public static void lockPacketReceived(int contraptionId, int remotePlayerId, double suggestedOffset) {
        class_638 level = class_310.method_1551().field_1687;
        if (!(level.method_8469(contraptionId) instanceof ControlledContraptionEntity contraptionEntity))
            return;
        if (!(level.method_8469(remotePlayerId) instanceof class_745 player))
            return;
        remoteSafetyLocks.computeIfAbsent(contraptionEntity, $ -> new WeakHashMap<>()).put(player, suggestedOffset);
    }

    private static void saveRemotePlayerFromClipping(class_1657 entity, AbstractContraptionEntity contraptionEntity, class_243 contraptionMotion) {
        if (entity.method_5765())
            return;

        Map<class_1657, Double> locksOnThisContraption = remoteSafetyLocks.getOrDefault(contraptionEntity, Collections.emptyMap());
        double prevDiff = locksOnThisContraption.getOrDefault(entity, entity.method_23318() - contraptionEntity.method_23318());
        if (!savePlayerFromClipping(entity, contraptionEntity, contraptionMotion, prevDiff))
            if (locksOnThisContraption.containsKey(entity))
                locksOnThisContraption.remove(entity);
    }

    private static boolean savePlayerFromClipping(
        class_1657 entity,
        AbstractContraptionEntity contraptionEntity,
        class_243 contraptionMotion,
        double yStartOffset
    ) {
        class_238 bb = entity.method_5829().method_35580(1 / 4f, 0, 1 / 4f);
        double shortestDistance = Double.MAX_VALUE;
        double yStart = entity.method_49476() + contraptionEntity.method_23318() + yStartOffset;
        double rayLength = Math.max(5, Math.abs(entity.method_23318() - yStart));

        for (int rayIndex = 0; rayIndex < 4; rayIndex++) {
            class_243 start = new class_243(rayIndex / 2 == 0 ? bb.field_1323 : bb.field_1320, yStart, rayIndex % 2 == 0 ? bb.field_1321 : bb.field_1324);
            class_243 end = start.method_1031(0, -rayLength, 0);

            class_3965 hitResult = ContraptionHandlerClient.rayTraceContraption(start, end, contraptionEntity);
            if (hitResult == null)
                continue;

            class_243 hit = contraptionEntity.toGlobalVector(hitResult.method_17784(), 1);
            double hitDiff = start.field_1351 - hit.field_1351;
            if (shortestDistance > hitDiff)
                shortestDistance = hitDiff;
        }

        if (shortestDistance > rayLength)
            return false;
        entity.method_5814(entity.method_23317(), yStart - shortestDistance, entity.method_23321());
        return true;
    }

    private static PlayerType getPlayerType(class_1297 entity) {
        if (!(entity instanceof class_1657))
            return PlayerType.NONE;
        return entity instanceof class_746 ? PlayerType.CLIENT : PlayerType.REMOTE;
    }
}
