package com.zurrtum.create.client.content.contraptions.actors.roller;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlock;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class RollerRenderer extends SmartBlockEntityRenderer<RollerBlockEntity, RollerRenderer.RollerRenderState> {
    public RollerRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public RollerRenderState createRenderState() {
        return new RollerRenderState();
    }

    @Override
    public void extractRenderState(
        RollerBlockEntity be,
        RollerRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        state.layer = class_12249.method_75972();
        state.wheel = CachedBuffers.partial(AllPartialModels.ROLLER_WHEEL, state.blockState);
        class_2350 facing = state.blockState.getValue(RollerBlock.field_11177);
        state.offset = class_243.method_24954(facing.method_62675()).method_1021(17 / 16f).method_1031(0, -0.25f, 0);
        float angle = AngleHelper.horizontalAngle(facing);
        state.wheelAngle = AngleHelper.rad(angle);
        class_1937 world = be.method_10997();
        float time = AnimationTickHolder.getRenderTime(world) / 20;
        state.rotate = AngleHelper.rad((time * be.getAnimatedSpeed()) % 360);
        state.yRot = class_3532.field_29847 * 90;
        state.frame = CachedBuffers.partial(AllPartialModels.ROLLER_FRAME, state.blockState);
        state.frameAngle = AngleHelper.rad(angle + 180);
    }

    @Override
    public void submit(RollerRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.submit(state, matrices, queue, cameraState);
        queue.method_73483(matrices, state.layer, state);
    }

    public static class RollerRenderState extends SmartRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer wheel;
        public class_243 offset;
        public float wheelAngle;
        public float rotate;
        public float yRot;
        public SuperByteBuffer frame;
        public float frameAngle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            wheel.translate(offset).rotateCentered(wheelAngle, class_2350.field_11036).rotate(rotate, class_2350.field_11039).translate(0, -.5, .5).rotateY(yRot)
                .light(lightCoords).renderInto(matricesEntry, vertexConsumer);
            frame.rotateCentered(frameAngle, class_2350.field_11036).light(lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
