package com.zurrtum.create.client.content.contraptions.chassis;


import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.foundation.block.connected.CTSpriteShiftEntry;
import com.zurrtum.create.client.foundation.block.connected.ConnectedTextureBehaviour;
import com.zurrtum.create.content.contraptions.chassis.LinearChassisBlock;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import org.jetbrains.annotations.Nullable;

public class ChassisCTBehaviour extends ConnectedTextureBehaviour.Base {

    @Override
    public CTSpriteShiftEntry getShift(class_2680 state, class_2350 direction, @Nullable class_1058 sprite) {
        class_2248 block = state.method_26204();
        class_2746 glueableSide = ((LinearChassisBlock) block).getGlueableSide(state, direction);
        if (glueableSide == null)
            return state.method_27852(AllBlocks.LINEAR_CHASSIS) ? AllSpriteShifts.CHASSIS_SIDE : AllSpriteShifts.SECONDARY_CHASSIS_SIDE;
        return state.method_11654(glueableSide) ? AllSpriteShifts.CHASSIS_STICKY : AllSpriteShifts.CHASSIS;
    }

    @Override
    protected class_2350 getUpDirection(class_1920 reader, class_2338 pos, class_2680 state, class_2350 face) {
        class_2350.class_2351 axis = state.method_11654(class_2741.field_12496);
        if (face.method_10166() == axis)
            return super.getUpDirection(reader, pos, state, face);
        return class_2350.method_10156(class_2350.class_2352.field_11056, axis);
    }

    @Override
    protected class_2350 getRightDirection(class_1920 reader, class_2338 pos, class_2680 state, class_2350 face) {
        class_2350.class_2351 axis = state.method_11654(class_2741.field_12496);
        return axis != face.method_10166() && axis.method_10179() ? (face.method_10166()
            .method_10179() ? class_2350.field_11033 : (axis == class_2350.class_2351.field_11048 ? class_2350.field_11043 : class_2350.field_11034)) : super.getRightDirection(
            reader,
            pos,
            state,
            face
        );
    }

    @Override
    protected boolean reverseUVsHorizontally(class_2680 state, class_2350 face) {
        class_2350.class_2351 axis = state.method_11654(class_2741.field_12496);
        boolean side = face.method_10166() != axis;
        if (side && axis == class_2350.class_2351.field_11048 && face.method_10166().method_10179())
            return true;
        return super.reverseUVsHorizontally(state, face);
    }

    @Override
    protected boolean reverseUVsVertically(class_2680 state, class_2350 face) {
        return super.reverseUVsVertically(state, face);
    }

    @Override
    public boolean reverseUVs(class_2680 state, class_2350 face) {
        class_2350.class_2351 axis = state.method_11654(class_2741.field_12496);
        boolean end = face.method_10166() == axis;
        if (end && axis.method_10179() && (face.method_10171() == class_2350.class_2352.field_11056))
            return true;
        if (!end && axis.method_10179() && face == class_2350.field_11033)
            return true;
        return super.reverseUVs(state, face);
    }

    @Override
    public boolean connectsTo(class_2680 state, class_2680 other, class_1920 reader, class_2338 pos, class_2338 otherPos, class_2350 face) {
        class_2350.class_2351 axis = state.method_11654(class_2741.field_12496);
        boolean superConnect = face.method_10166() == axis ? super.connectsTo(state, other, reader, pos, otherPos, face) : state.method_27852(other.method_26204());
        return superConnect && axis == other.method_11654(class_2741.field_12496);
    }

}