package com.zurrtum.create.client.content.contraptions.elevator;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.pulley.AbstractPulleyRenderer;
import com.zurrtum.create.client.content.contraptions.pulley.PulleyRenderer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.elevator.ElevatorPulleyBlock;
import com.zurrtum.create.content.contraptions.elevator.ElevatorPulleyBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;

public class ElevatorPulleyRenderer extends KineticBlockEntityRenderer<ElevatorPulleyBlockEntity, ElevatorPulleyRenderer.ElevatorPulleyRenderState> {
    public ElevatorPulleyRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public ElevatorPulleyRenderState createRenderState() {
        return new ElevatorPulleyRenderState();
    }

    @Override
    public void extractRenderState(
        ElevatorPulleyBlockEntity be,
        ElevatorPulleyRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        class_1937 world = be.method_10997();
        class_2680 blockState = be.method_11010();
        float offset = PulleyRenderer.getBlockEntityOffset(tickProgress, be);
        boolean running = PulleyRenderer.isPulleyRunning(be);
        state.yRot = class_3532.field_29847 * (180 + AngleHelper.horizontalAngle(blockState.method_11654(ElevatorPulleyBlock.HORIZONTAL_FACING)));
        if (running || offset == 0) {
            state.magnet = CachedBuffers.partial(AllPartialModels.ELEVATOR_MAGNET, blockState);
            state.magnetOffset = -offset;
            state.magnetLight = class_761.method_23794(world, state.blockPos.below((int) offset));
        }
        state.rotatedCoil = getRotatedCoil(be);
        if (offset == 0) {
            return;
        }
        state.coilShift = AllSpriteShifts.ELEVATOR_COIL;
        state.coilScroll = AbstractPulleyRenderer.getCoilVScroll(state.coilShift, offset, 2);
        float f = offset % 1;
        if (f < .25f || f > .75f) {
            state.halfRope = CachedBuffers.partial(AllPartialModels.ELEVATOR_BELT_HALF, blockState);
            updateHalfShift(state, offset);
            float down = f > .75f ? f - 1 : f;
            state.halfRopeOffset = -down;
            state.halfRopeLight = class_761.method_23794(world, state.blockPos.below((int) down));
        }
        if (!running) {
            return;
        }
        if (state.halfRope == null) {
            updateHalfShift(state, offset);
        }
        state.rope = CachedBuffers.partial(AllPartialModels.ELEVATOR_BELT, blockState);
        int size = (int) Math.ceil(offset - .25f);
        float[] offsets = new float[size];
        int[] lights = new int[size];
        for (int i = 0; i < size; i++) {
            float down = offset - i;
            int light = class_761.method_23794(world, state.blockPos.below((int) down));
            offsets[i] = -down;
            lights[i] = light;
        }
        state.offsets = offsets;
        state.lights = lights;
    }

    @Override
    public void submit(ElevatorPulleyRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
    }

    private static void updateHalfShift(ElevatorPulleyRenderState state, float offset) {
        state.halfShift = AllSpriteShifts.ELEVATOR_BELT;
        double beltScroll = (-(offset + .5) - Math.floor(-(offset + .5))) / 2;
        class_1058 target = state.halfShift.getTarget();
        float spriteSize = target.method_4575() - target.method_4593();
        state.halfScroll = (float) beltScroll * spriteSize;
    }

    @Override
    protected class_1921 getRenderType(ElevatorPulleyBlockEntity be, class_2680 state) {
        return class_12249.method_75965();
    }

    @Override
    protected class_2680 getRenderedBlockState(ElevatorPulleyBlockEntity be) {
        return shaft(getRotationAxisOf(be));
    }

    protected SuperByteBuffer getRotatedCoil(KineticBlockEntity be) {
        class_2680 blockState = be.method_11010();
        return CachedBuffers.partialFacing(AllPartialModels.ELEVATOR_COIL, blockState, blockState.method_11654(ElevatorPulleyBlock.HORIZONTAL_FACING));
    }

    @Override
    public boolean method_3563() {
        return true;
    }

    public static class ElevatorPulleyRenderState extends KineticRenderState {
        public float yRot;
        public SuperByteBuffer magnet;
        public float magnetOffset;
        public int magnetLight;
        public SuperByteBuffer rotatedCoil;
        public SpriteShiftEntry coilShift;
        public float coilScroll;
        public SuperByteBuffer halfRope;
        public SpriteShiftEntry halfShift;
        public float halfScroll;
        public float halfRopeOffset;
        public int halfRopeLight;
        public SuperByteBuffer rope;
        public float[] offsets;
        public int[] lights;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (model != null) {
                super.render(matricesEntry, vertexConsumer);
            }
            if (magnet != null) {
                magnet.center().rotateY(yRot).uncenter().translate(0, magnetOffset, 0).light(magnetLight).renderInto(matricesEntry, vertexConsumer);
            }
            if (coilScroll != 0) {
                rotatedCoil.shiftUVScrolling(coilShift, coilScroll);
            }
            rotatedCoil.light(lightCoords).renderInto(matricesEntry, vertexConsumer);
            if (halfRope != null) {
                halfRope.center().rotateY(yRot).uncenter().translate(0, halfRopeOffset, 0).shiftUVScrolling(halfShift, halfScroll)
                    .light(halfRopeLight).renderInto(matricesEntry, vertexConsumer);
            }
            if (rope != null) {
                for (int i = 0, size = offsets.length; i < size; i++) {
                    rope.center().rotateY(yRot).uncenter().translate(0, offsets[i], 0).shiftUVScrolling(halfShift, halfScroll).light(lights[i])
                        .renderInto(matricesEntry, vertexConsumer);
                }
            }
        }
    }
}
