package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_4587;

public class ControlledContraptionVisual extends ContraptionVisual<ControlledContraptionEntity> {
    public ControlledContraptionVisual(VisualizationContext ctx, ControlledContraptionEntity entity, float partialTick) {
        super(ctx, entity, partialTick);
    }

    @Override
    public void transform(class_4587 matrixStack, float partialTicks) {
        class_2351 axis = entity.getRotationAxis();
        if (axis != null) {
            float angle = entity.getAngle(partialTicks);
            TransformStack.of(matrixStack).nudge(entity.method_5628()).center().rotateDegrees(angle, axis).uncenter();
        }
    }
}
