package com.zurrtum.create.client.content.decoration;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.foundation.block.connected.AllCTTypes;
import com.zurrtum.create.client.foundation.block.connected.CTSpriteShiftEntry;
import com.zurrtum.create.client.foundation.block.connected.CTType;
import com.zurrtum.create.client.foundation.block.connected.ConnectedTextureBehaviour;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class RoofBlockCTBehaviour extends ConnectedTextureBehaviour.Base {

    private final CTSpriteShiftEntry shift;

    public RoofBlockCTBehaviour(CTSpriteShiftEntry shift) {
        this.shift = shift;
    }

    @Override
    public @Nullable CTSpriteShiftEntry getShift(class_2680 state, class_2350 direction, @Nullable class_1058 sprite) {
        if (direction == class_2350.field_11036)
            return shift;
        return null;
    }

    @Override
    public boolean buildContextForOccludedDirections() {
        return true;
    }

    @Override
    public CTContext buildContext(class_1920 reader, class_2338 pos, class_2680 state, class_2350 face, ContextRequirement requirement) {

        if (isUprightStair(state))
            return getStairMapping(state);

        return super.buildContext(reader, pos, state, face, requirement);
    }

    @Override
    public boolean connectsTo(
        class_2680 state,
        class_2680 other,
        class_1920 reader,
        class_2338 pos,
        class_2338 otherPos,
        class_2350 face,
        class_2350 primaryOffset,
        class_2350 secondaryOffset
    ) {

        if (connects(reader, pos, state, other) || connectsHigh(reader, pos, state, other, reader.method_8320(otherPos.method_10084())))
            return true;
        if (primaryOffset != null && secondaryOffset != null)
            return false;

        for (boolean p : Iterate.trueAndFalse) {
            class_2350 offset = p ? primaryOffset : secondaryOffset;
            if (offset == null)
                continue;
            if (offset.method_10166().method_10178())
                continue;

            if (connectsHigh(
                reader,
                pos,
                state,
                reader.method_8320(pos.method_10093(offset.method_10170())),
                reader.method_8320(pos.method_10093(offset.method_10170()).method_10084())
            ) || connectsHigh(
                reader,
                pos,
                state,
                reader.method_8320(pos.method_10093(offset.method_10160())),
                reader.method_8320(pos.method_10093(offset.method_10160()).method_10084())
            ))
                return true;
        }

        return false;
    }

    public boolean isUprightStair(class_2680 state) {
        return state.method_28498(class_2510.field_11565) && state.method_61767(class_2510.field_11572, class_2760.field_12619) == class_2760.field_12617;
    }

    public CTContext getStairMapping(class_2680 state) {
        CTContext context = new CTContext();
        class_2778 shape = state.method_11654(class_2510.field_11565);
        class_2350 facing = state.method_11654(class_2510.field_11571);

        if (shape == class_2778.field_12708)
            facing = facing.method_10160();
        if (shape == class_2778.field_12712)
            facing = facing.method_10160();

        int type = shape == class_2778.field_12710 ? 0 : (shape == class_2778.field_12712 || shape == class_2778.field_12713) ? 1 : 2;
        int rot = facing.method_10161();
        context.up = type >= 2;
        context.right = type % 2 == 1;
        context.left = rot >= 2;
        context.down = rot % 2 == 1;
        return context;
    }

    protected boolean connects(class_1920 reader, class_2338 pos, class_2680 state, class_2680 other) {
        double top = state.method_26220(reader, pos).method_1105(class_2351.field_11052);
        double topOther = other.method_26231() != class_2498.field_27204 ? 0 : other.method_26220(reader, pos).method_1105(class_2351.field_11052);
        return class_3532.method_20390(top, topOther);
    }

    protected boolean connectsHigh(class_1920 reader, class_2338 pos, class_2680 state, class_2680 other, class_2680 aboveOther) {
        if (state.method_26204() instanceof class_2482 && other.method_26204() instanceof class_2482)
            if (state.method_11654(class_2482.field_11501) == class_2771.field_12681 && other.method_11654(class_2482.field_11501) != class_2771.field_12681)
                return true;

        if (state.method_26204() instanceof class_2482 && state.method_11654(class_2482.field_11501) == class_2771.field_12681) {
            double top = state.method_26220(reader, pos).method_1105(class_2351.field_11052);
            double topOther = other.method_26220(reader, pos).method_1105(class_2351.field_11052);
            return !class_3532.method_20390(top, topOther) && topOther > top;
        }

        double topAboveOther = aboveOther.method_26220(reader, pos).method_1105(class_2351.field_11052);
        return topAboveOther > 0;
    }

    @Override
    public @Nullable CTType getDataType(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
        return isUprightStair(state) ? AllCTTypes.ROOF_STAIR : AllCTTypes.ROOF;
    }

}