package com.zurrtum.create.client.content.decoration.slidingDoor;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControl;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlockEntity;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2323;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7923;
import net.minecraft.class_827;

public class SlidingDoorRenderer implements class_827<SlidingDoorBlockEntity, SlidingDoorRenderer.DoorRenderState> {
    public SlidingDoorRenderer(class_5614.class_5615 context) {
    }

    @Override
    public DoorRenderState method_74335() {
        return new DoorRenderState();
    }

    @Override
    public void extractRenderState(
        SlidingDoorBlockEntity be,
        DoorRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        state.field_62674 = be.method_11010();
        if (!be.shouldRenderSpecial(state.field_62674)) {
            return;
        }
        state.field_62673 = be.method_11016();
        state.field_62675 = be.method_11017();
        class_1937 world = be.method_10997();
        state.field_62676 = world != null ? class_761.method_23794(world, state.field_62673) : 15728880;
        state.layer = class_12249.method_75972();
        class_2350 facing = state.field_62674.method_11654(class_2323.field_10938);
        class_2350 movementDirection = facing.method_10170();
        boolean isLeft = state.field_62674.method_11654(class_2323.field_10941) == class_2750.field_12588;
        float value = be.animation.getValue(tickProgress);
        class_243 offset = class_243.method_24954(facing.method_62675()).method_1021(class_3532.method_15363(value * 10, 0, 1) * 1 / 32f);
        SlidingDoorBlock block = (SlidingDoorBlock) state.field_62674.method_26204();
        if (block.isFoldingDoor()) {
            FoldingDoorRenderState renderState = new FoldingDoorRenderState();
            renderState.offsetY = -1 / 512f;
            renderState.offset = offset;
            renderState.angle = class_3532.field_29847 * AngleHelper.horizontalAngle(movementDirection);
            float f = isLeft ? 1 : -1;
            float v = f * value * value;
            renderState.yRot = class_3532.field_29847 * 91 * v;
            renderState.flip = !isLeft;
            Couple<PartialModel> partials = AllPartialModels.FOLDING_DOORS.get(class_7923.field_41175.method_10221(block));
            renderState.left = CachedBuffers.partial(partials.get(isLeft), state.field_62674);
            renderState.right = CachedBuffers.partial(partials.get(renderState.flip), state.field_62674);
            renderState.rightOffset = f / 2f;
            renderState.rightYRot = class_3532.field_29847 * -181 * v;
            renderState.light = state.field_62676;
            state.renderer = renderState;
        } else {
            if (isLeft) {
                movementDirection = movementDirection.method_10153();
            }
            SlidingDoorRenderState renderState = new SlidingDoorRenderState();
            class_2680 blockState = state.field_62674.method_11657(class_2323.field_10945, false);
            renderState.upper = CachedBuffers.block(blockState.method_11657(class_2323.field_10946, class_2756.field_12609));
            renderState.lower = CachedBuffers.block(blockState.method_11657(class_2323.field_10946, class_2756.field_12607));
            renderState.upperOffset = 1 - 1 / 512f;
            renderState.offset = class_243.method_24954(movementDirection.method_62675()).method_1021(value * value * 13 / 16f).method_1019(offset);
            renderState.light = state.field_62676;
            state.renderer = renderState;
        }
    }

    @Override
    public void submit(DoorRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.renderer != null) {
            queue.method_73483(matrices, state.layer, state.renderer);
        }
    }

    public static Pair<ScrollInput, Label> createWidget(class_310 mc, int x, int y, Consumer<DoorControl> callback, DoorControl initial) {
        class_1297 entity = mc.method_1560();
        DoorControl playerFacing = entity != null ? switch (entity.method_5735()) {
            case field_11034 -> DoorControl.EAST;
            case field_11039 -> DoorControl.WEST;
            case field_11043 -> DoorControl.NORTH;
            case field_11035 -> DoorControl.SOUTH;
            default -> DoorControl.NONE;
        } : DoorControl.NONE;

        Label label = new Label(x + 4, y + 6, class_2561.method_43473()).withShadow();
        ScrollInput input = new SelectionScrollInput(x, y, 53, 16).forOptions(CreateLang.translatedOptions(
            "contraption.door_control",
            valuesAsString()
        )).titled(CreateLang.translateDirect("contraption.door_control")).calling(s -> {
            DoorControl mode = DoorControl.values()[s];
            label.text = CreateLang.translateDirect("contraption.door_control." + Lang.asId(mode.name()) + ".short");
            callback.accept(mode);
        }).addHint(CreateLang.translateDirect(
            "contraption.door_control.player_facing",
            CreateLang.translateDirect("contraption.door_control." + Lang.asId(playerFacing.name()) + ".short")
        )).setState(initial.ordinal());
        input.onChanged();
        return Pair.of(input, label);
    }

    public static String[] valuesAsString() {
        DoorControl[] values = DoorControl.values();
        return Arrays.stream(values).map(dc -> dc.name().toLowerCase(Locale.ROOT)).toList().toArray(new String[values.length]);
    }

    public static class DoorRenderState extends class_11954 {
        public class_11659.class_11660 renderer;
        public class_1921 layer;
    }

    public static class FoldingDoorRenderState implements class_11659.class_11660 {
        public float offsetY;
        public class_243 offset;
        public float angle;
        public float yRot;
        public boolean flip;
        public SuperByteBuffer left;
        public SuperByteBuffer right;
        public float rightOffset;
        public float rightYRot;
        public int light;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            left.translate(0, offsetY, 0).translate(offset).rotateCentered(angle, class_2350.field_11036);
            if (flip) {
                left.translate(0, 0, 1);
            }
            left.rotateY(yRot);
            if (flip) {
                left.translate(0, 0, -0.5f);
            }
            left.light(light).renderInto(matricesEntry, vertexConsumer);
            right.translate(0, offsetY, 0).translate(offset).rotateCentered(angle, class_2350.field_11036);
            if (flip) {
                right.translate(0, 0, 1);
            }
            right.rotateY(yRot).translate(0, 0, rightOffset).rotateY(rightYRot);
            if (flip) {
                right.translate(0, 0, -0.5f);
            }
            right.light(light).renderInto(matricesEntry, vertexConsumer);
        }
    }

    public static class SlidingDoorRenderState implements class_11659.class_11660 {
        public SuperByteBuffer upper;
        public SuperByteBuffer lower;
        public float upperOffset;
        public class_243 offset;
        public int light;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            upper.translate(0, upperOffset, 0).translate(offset).light(light).renderInto(matricesEntry, vertexConsumer);
            lower.translate(offset).light(light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
