package com.zurrtum.create.client.content.decoration.steamWhistle;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.animation.AnimationBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.animation.WhistleAnimationBehaviour;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock.WhistleSize;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class WhistleRenderer implements class_827<WhistleBlockEntity, WhistleRenderer.WhistleRenderState> {
    public WhistleRenderer(class_5614.class_5615 context) {
    }

    @Override
    public WhistleRenderState method_74335() {
        return new WhistleRenderState();
    }

    @Override
    public void extractRenderState(
        WhistleBlockEntity be,
        WhistleRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        state.field_62674 = be.method_11010();
        if (!(state.field_62674.method_26204() instanceof WhistleBlock)) {
            return;
        }
        state.field_62673 = be.method_11016();
        state.field_62675 = be.method_11017();
        class_1937 world = be.method_10997();
        state.field_62676 = world != null ? class_761.method_23794(world, state.field_62673) : class_765.field_32767;
        state.field_62677 = crumblingOverlay;
        state.layer = class_12249.method_75965();
        class_2350 direction = state.field_62674.method_11654(WhistleBlock.FACING);
        WhistleSize size = state.field_62674.method_11654(WhistleBlock.SIZE);
        PartialModel mouth = size == WhistleSize.LARGE ? AllPartialModels.WHISTLE_MOUTH_LARGE : size == WhistleSize.MEDIUM ? AllPartialModels.WHISTLE_MOUTH_MEDIUM : AllPartialModels.WHISTLE_MOUTH_SMALL;
        WhistleAnimationBehaviour behaviour = (WhistleAnimationBehaviour) be.getBehaviour(AnimationBehaviour.TYPE);
        float offset = behaviour.animation.getValue(tickProgress);
        if (behaviour.animation.getChaseTarget() > 0 && behaviour.animation.getValue() > 0.5f) {
            float wiggleProgress = (AnimationTickHolder.getTicks(world) + tickProgress) / 8f;
            offset = (float) (offset - Math.sin(wiggleProgress * (2 * class_3532.field_29844) * (4 - size.ordinal())) / 16f);
        }
        state.model = CachedBuffers.partial(mouth, state.field_62674);
        state.yRot = class_3532.field_29847 * AngleHelper.horizontalAngle(direction);
        state.offset = offset * 4 / 16f;
    }

    @Override
    public void submit(WhistleRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
    }

    public static class WhistleRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer model;
        public float yRot;
        public float offset;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            model.center().rotateY(yRot).uncenter().translate(0, offset, 0).light(field_62676).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
