package com.zurrtum.create.client.content.decoration.steamWhistle;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock.WhistleSize;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3419;

public class WhistleSoundInstance extends class_1101 {

    private boolean active;
    private int keepAlive;
    private WhistleSize size;

    public WhistleSoundInstance(WhistleSize size, class_2338 worldPosition) {
        super(
            (size == WhistleSize.SMALL ? AllSoundEvents.WHISTLE_HIGH : size == WhistleSize.MEDIUM ? AllSoundEvents.WHISTLE_MEDIUM : AllSoundEvents.WHISTLE_LOW).getMainEvent(),
            class_3419.field_15247,
            class_1113.method_43221()
        );
        this.size = size;
        field_5446 = true;
        active = true;
        field_5442 = 0.05f;
        field_5451 = 0;
        keepAlive();
        class_243 v = class_243.method_24953(worldPosition);
        field_5439 = v.field_1352;
        field_5450 = v.field_1351;
        field_5449 = v.field_1350;
    }

    public WhistleSize getOctave() {
        return size;
    }

    public void fadeOut() {
        this.active = false;
    }

    public void keepAlive() {
        keepAlive = 2;
    }

    public void setPitch(float pitch) {
        this.field_5441 = pitch;
    }

    @Override
    public void method_16896() {
        if (active) {
            field_5442 = Math.min(1, field_5442 + .25f);
            keepAlive--;
            if (keepAlive == 0)
                fadeOut();
            return;

        }
        field_5442 = Math.max(0, field_5442 - .25f);
        if (field_5442 == 0)
            method_24876();
    }

}
