package com.zurrtum.create.client.content.equipment.bell;

import java.util.*;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class SoulPulseEffectHandler {
    private final List<SoulPulseEffect> pulses;
    private final Queue<SoulPulseEffect> queue;
    private final Set<class_2338> occupied;

    public SoulPulseEffectHandler() {
        pulses = new LinkedList<>();
        queue = new ConcurrentLinkedQueue<>();
        occupied = new HashSet<>();
    }

    public void tick(class_1937 world) {
        Iterator<SoulPulseEffect> iterator = pulses.iterator();
        SoulPulseEffect pulse;
        while (iterator.hasNext()) {
            pulse = iterator.next();
            List<class_2338> spawns = pulse.tick(world);
            if (spawns != null) {
                if (pulse.canOverlap()) {
                    for (class_2338 pos : spawns) {
                        pulse.spawnParticles(world, pos);
                    }
                    if (pulse.finished()) {
                        iterator.remove();
                    }
                } else if (pulse.finished()) {
                    for (class_2338 pos : spawns) {
                        if (occupied.contains(pos)) {
                            continue;
                        }
                        pulse.spawnParticles(world, pos);
                    }
                    pulse.added.forEach(occupied::remove);
                    iterator.remove();
                } else {
                    for (class_2338 pos : spawns) {
                        if (occupied.add(pos)) {
                            pulse.spawnParticles(world, pos);
                            pulse.added.add(pos);
                        }
                    }
                }
            } else if (pulse.finished()) {
                if (!pulse.canOverlap()) {
                    pulse.added.forEach(occupied::remove);
                }
                iterator.remove();
            }
        }
        while ((pulse = queue.poll()) != null) {
            List<class_2338> spawns = pulse.tick(world);
            if (spawns != null) {
                if (pulse.canOverlap()) {
                    for (class_2338 pos : spawns) {
                        pulse.spawnParticles(world, pos);
                    }
                } else {
                    for (class_2338 pos : spawns) {
                        if (occupied.add(pos)) {
                            pulse.spawnParticles(world, pos);
                            pulse.added.add(pos);
                        }
                    }
                }
            }
            pulses.add(pulse);
        }
    }

    public void addPulse(SoulPulseEffect pulse) {
        queue.offer(pulse);
    }

    public void refresh() {
        pulses.clear();
        occupied.clear();
    }
}
