package com.zurrtum.create.client.content.equipment.toolbox;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.infrastructure.packet.c2s.ToolboxDisposeAllPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ToolboxEquipPacket;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;

import static com.zurrtum.create.content.equipment.toolbox.ToolboxInventory.STACKS_PER_COMPARTMENT;

public class RadialToolboxMenu extends AbstractSimiScreen {

    private State state;
    private int ticksOpen;
    private int hoveredSlot;
    private boolean scrollMode;
    private int scrollSlot = 0;
    private final List<ToolboxBlockEntity> toolboxes;
    private ToolboxBlockEntity selectedBox;

    private static final int DEPOSIT = -7;
    private static final int UNEQUIP = -5;

    public RadialToolboxMenu(List<ToolboxBlockEntity> toolboxes, State state, @Nullable ToolboxBlockEntity selectedBox) {
        this.toolboxes = toolboxes;
        this.state = state;
        hoveredSlot = -1;

        if (selectedBox != null)
            this.selectedBox = selectedBox;
    }

    public void prevSlot(int slot) {
        scrollSlot = slot;
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        float fade = class_3532.method_15363((ticksOpen + AnimationTickHolder.getPartialTicks()) / 10f, 1 / 512f, 1);

        hoveredSlot = -1;
        class_1041 window = field_22787.method_22683();
        float hoveredX = mouseX - window.method_4486() / 2;
        float hoveredY = mouseY - window.method_4502() / 2;

        float distance = hoveredX * hoveredX + hoveredY * hoveredY;
        if (distance > 25 && distance < 10000)
            hoveredSlot = (class_3532.method_15375((AngleHelper.deg(class_3532.method_15349(hoveredY, hoveredX)) + 360 + 180 - 22.5f)) % 360) / 45;
        boolean renderCenterSlot = state == State.SELECT_ITEM_UNEQUIP;
        if (scrollMode && distance > 150)
            scrollMode = false;
        if (renderCenterSlot && distance <= 150)
            hoveredSlot = UNEQUIP;

        Matrix3x2fStack ms = graphics.method_51448();
        ms.pushMatrix();
        ms.translate(field_22789 / 2, field_22790 / 2);
        class_2561 tip = null;

        if (state == State.DETACH) {

            tip = CreateLang.translateDirect("toolbox.outOfRange");
            if (hoveredX > -20 && hoveredX < 20 && hoveredY > -80 && hoveredY < -20)
                hoveredSlot = UNEQUIP;

            ms.pushMatrix();
            AllGuiTextures.TOOLBELT_INACTIVE_SLOT.render(graphics, -12, -12);
            graphics.method_51427(AllItems.BROWN_TOOLBOX.method_7854(), -9, -9);

            ms.translate(0, -40 + (10 * (1 - fade) * (1 - fade)));
            AllGuiTextures.TOOLBELT_SLOT.render(graphics, -12, -12);
            ms.translate(-0.5F, 0.5F);
            AllIcons.I_DISABLE.render(graphics, -9, -9);
            ms.translate(0.5F, -0.5F);
            if (!scrollMode && hoveredSlot == UNEQUIP) {
                AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -13, -13);
                tip = CreateLang.translateDirect("toolbox.detach").method_27692(class_124.field_1065);
            }
            ms.popMatrix();

        } else {

            if (hoveredX > 60 && hoveredX < 100 && hoveredY > -20 && hoveredY < 20)
                hoveredSlot = DEPOSIT;

            ms.pushMatrix();
            ms.translate(80 + (-5 * (1 - fade) * (1 - fade)), 0);
            AllGuiTextures.TOOLBELT_SLOT.render(graphics, -12, -12);
            ms.translate(-0.5F, 0.5F);
            AllIcons.I_TOOLBOX.render(graphics, -9, -9);
            ms.translate(0.5F, -0.5F);
            if (!scrollMode && hoveredSlot == DEPOSIT) {
                AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -13, -13);
                tip = CreateLang.translateDirect(state == State.SELECT_BOX ? "toolbox.depositAll" : "toolbox.depositBox")
                    .method_27692(class_124.field_1065);
            }
            ms.popMatrix();

            for (int slot = 0; slot < 8; slot++) {
                ms.pushMatrix();
                ms.rotate(class_3532.field_29847 * (slot * 45 - 45));
                ms.translate(0, -40 + (10 * (1 - fade) * (1 - fade)));
                ms.rotate(class_3532.field_29847 * (-slot * 45 + 45));
                ms.translate(-12, -12);

                if (state == State.SELECT_ITEM || state == State.SELECT_ITEM_UNEQUIP) {
                    ToolboxInventory inv = selectedBox.inventory;
                    class_1799 stackInSlot = inv.filters.get(slot);

                    if (!stackInSlot.method_7960()) {
                        boolean empty = inv.method_5438(slot * STACKS_PER_COMPARTMENT).method_7960();

                        (empty ? AllGuiTextures.TOOLBELT_INACTIVE_SLOT : AllGuiTextures.TOOLBELT_SLOT).render(graphics, 0, 0);
                        graphics.method_51427(stackInSlot, 3, 3);

                        if (slot == (scrollMode ? scrollSlot : hoveredSlot) && !empty) {
                            AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -1, -1);
                            tip = stackInSlot.method_7964();
                        }
                    } else
                        AllGuiTextures.TOOLBELT_EMPTY_SLOT.render(graphics, 0, 0);

                } else if (state == State.SELECT_BOX) {

                    if (slot < toolboxes.size()) {
                        AllGuiTextures.TOOLBELT_SLOT.render(graphics, 0, 0);
                        ToolboxBlockEntity toolboxBlockEntity = toolboxes.get(slot);
                        class_1799 stack = toolboxBlockEntity.method_11010().method_26204().method_8389().method_7854();
                        graphics.method_51427(stack, 3, 3);

                        if (slot == (scrollMode ? scrollSlot : hoveredSlot)) {
                            AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -1, -1);
                            tip = toolboxBlockEntity.method_5476();
                        }
                    } else
                        AllGuiTextures.TOOLBELT_EMPTY_SLOT.render(graphics, 0, 0);

                }

                ms.popMatrix();
            }

            if (renderCenterSlot) {
                ms.pushMatrix();
                AllGuiTextures.TOOLBELT_SLOT.render(graphics, -12, -12);
                (scrollMode ? AllIcons.I_REFRESH : AllIcons.I_FLIP).render(graphics, -9, -9);
                if (!scrollMode && UNEQUIP == hoveredSlot) {
                    AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -13, -13);
                    tip = CreateLang.translateDirect("toolbox.unequip", field_22787.field_1724.method_6047().method_7964())
                        .method_27692(class_124.field_1065);
                }
                ms.popMatrix();
            }
        }
        ms.popMatrix();

        if (tip != null) {
            int i1 = (int) (fade * 255.0F);
            if (i1 > 255)
                i1 = 255;

            if (i1 > 8) {
                ms.pushMatrix();
                ms.translate((float) (field_22789 / 2), (float) (field_22790 - 68));
                int k1 = 16777215;
                int k = i1 << 24 & -16777216;
                int l = field_22793.method_27525(tip);
                graphics.method_51439(field_22793, tip, Math.round(-l / 2f), -4, k1 | k, false);
                ms.popMatrix();
            }
        }

    }

    @Override
    public void method_25420(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Color color = BACKGROUND_COLOR.scaleAlpha(Math.min(1, (ticksOpen + AnimationTickHolder.getPartialTicks()) / 20f));

        pGuiGraphics.method_25296(0, 0, this.field_22789, this.field_22790, color.getRGB(), color.getRGB());
    }

    @Override
    public void method_25393() {
        ticksOpen++;
        super.method_25393();
    }

    @Override
    public void method_25432() {
        super.method_25432();

        int selected = (scrollMode ? scrollSlot : hoveredSlot);

        if (selected == DEPOSIT) {
            if (state == State.DETACH)
                return;
            else if (state == State.SELECT_BOX)
                toolboxes.forEach(be -> field_22787.field_1724.field_3944.method_52787(new ToolboxDisposeAllPacket(be.method_11016())));
            else
                field_22787.field_1724.field_3944.method_52787(new ToolboxDisposeAllPacket(selectedBox.method_11016()));
            return;
        }

        if (state == State.SELECT_BOX)
            return;

        if (state == State.DETACH) {
            if (selected == UNEQUIP)
                field_22787.field_1724.field_3944.method_52787(new ToolboxEquipPacket(null, selected, field_22787.field_1724.method_31548().method_67532()));
            return;
        }

        if (selected == UNEQUIP)
            field_22787.field_1724.field_3944.method_52787(new ToolboxEquipPacket(
                selectedBox.method_11016(),
                selected,
                field_22787.field_1724.method_31548().method_67532()
            ));

        if (selected < 0)
            return;
        ToolboxInventory inv = selectedBox.inventory;
        class_1799 stackInSlot = inv.filters.get(selected);
        if (stackInSlot.method_7960())
            return;
        if (inv.method_5438(selected * STACKS_PER_COMPARTMENT).method_7960())
            return;

        field_22787.field_1724.field_3944.method_52787(new ToolboxEquipPacket(
            selectedBox.method_11016(),
            selected,
            field_22787.field_1724.method_31548().method_67532()
        ));
    }

    @Override
    public boolean method_25401(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        class_1041 window = field_22787.method_22683();
        double hoveredX = pMouseY - window.method_4486() / 2;
        double hoveredY = pMouseY - window.method_4502() / 2;
        double distance = hoveredX * hoveredX + hoveredY * hoveredY;
        if (distance <= 150) {
            scrollMode = true;
            scrollSlot = (((int) (scrollSlot - pScrollY)) + 8) % 8;
            for (int i = 0; i < 10; i++) {

                if (state == State.SELECT_ITEM || state == State.SELECT_ITEM_UNEQUIP) {
                    ToolboxInventory inv = selectedBox.inventory;
                    class_1799 stackInSlot = inv.filters.get(scrollSlot);
                    if (!stackInSlot.method_7960() && !inv.method_5438(scrollSlot * STACKS_PER_COMPARTMENT).method_7960())
                        break;
                }

                if (state == State.SELECT_BOX)
                    if (scrollSlot < toolboxes.size())
                        break;

                if (state == State.DETACH)
                    break;

                scrollSlot -= class_3532.method_17822(pScrollY);
                scrollSlot = (scrollSlot + 8) % 8;
            }
            return true;
        }

        return super.method_25401(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        int selected = scrollMode ? scrollSlot : hoveredSlot;
        int button = click.method_74245();

        if (button == 0) {
            if (selected == DEPOSIT) {
                method_25419();
                ToolboxHandlerClient.COOLDOWN = 2;
                return true;
            }

            if (state == State.SELECT_BOX && selected >= 0 && selected < toolboxes.size()) {
                state = State.SELECT_ITEM;
                selectedBox = toolboxes.get(selected);
                return true;
            }

            if (state == State.DETACH || state == State.SELECT_ITEM || state == State.SELECT_ITEM_UNEQUIP) {
                if (selected == UNEQUIP || selected >= 0) {
                    method_25419();
                    ToolboxHandlerClient.COOLDOWN = 2;
                    return true;
                }
            }
        }

        if (button == 1) {
            if (state == State.SELECT_ITEM && toolboxes.size() > 1) {
                state = State.SELECT_BOX;
                return true;
            }

            if (state == State.SELECT_ITEM_UNEQUIP && selected == UNEQUIP) {
                if (toolboxes.size() > 1) {
                    field_22787.field_1724.field_3944.method_52787(new ToolboxEquipPacket(
                        selectedBox.method_11016(),
                        selected,
                        field_22787.field_1724.method_31548().method_67532()
                    ));
                    state = State.SELECT_BOX;
                    return true;
                }

                method_25419();
                ToolboxHandlerClient.COOLDOWN = 2;
                return true;
            }
        }

        return super.method_25402(click, doubled);
    }

    @Override
    public boolean method_25404(class_11908 input) {
        class_304[] hotbarBinds = field_22787.field_1690.field_1852;
        for (int i = 0; i < hotbarBinds.length && i < 8; i++) {
            if (hotbarBinds[i].method_1417(input)) {

                if (state == State.SELECT_ITEM || state == State.SELECT_ITEM_UNEQUIP) {
                    ToolboxInventory inv = selectedBox.inventory;
                    class_1799 stackInSlot = inv.filters.get(i);
                    if (stackInSlot.method_7960() || inv.method_5438(i * STACKS_PER_COMPARTMENT).method_7960())
                        return false;
                }

                if (state == State.SELECT_BOX)
                    if (i >= toolboxes.size())
                        return false;

                scrollMode = true;
                scrollSlot = i;
                method_25402(new class_11909(0, 0, new class_11910(0, 0)), false);
                return true;
            }
        }

        return super.method_25404(input);
    }

    @Override
    public boolean method_16803(class_11908 input) {
        class_3675.class_306 mouseKey = class_3675.method_15985(input);
        if (mouseKey == AllKeys.TOOLBELT.field_1655) {
            method_25419();
            return true;
        }
        return super.method_16803(input);
    }

    public enum State {
        SELECT_BOX,
        SELECT_ITEM,
        SELECT_ITEM_UNEQUIP,
        DETACH
    }

}
