package com.zurrtum.create.client.content.fluids.drain;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.fluids.drain.ItemDrainBlockEntity;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour.TankSegment;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

import java.util.Random;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_9326;

public class ItemDrainRenderer implements class_827<ItemDrainBlockEntity, ItemDrainRenderer.ItemDrainRenderState> {
    protected final class_10442 itemModelManager;

    public ItemDrainRenderer(class_5614.class_5615 context) {
        itemModelManager = context.comp_4536();
    }

    @Override
    public ItemDrainRenderState method_74335() {
        return new ItemDrainRenderState();
    }

    @Override
    public void extractRenderState(
        ItemDrainBlockEntity be,
        ItemDrainRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        updateFluidRenderState(be, state, tickProgress);
        updateItemRenderState(be, state, itemModelManager, tickProgress);
    }

    @Override
    public void submit(ItemDrainRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.process != null) {
            queue.method_73483(matrices, state.process.layer, state.process);
        }
        if (state.item != null) {
            state.item.render(matrices, queue, cameraState.field_63078, state.field_62676);
        }
        if (state.fluid != null) {
            matrices.method_46416(0, state.fluid.offset, 0);
            queue.method_73483(matrices, state.fluid.layer, state.fluid);
        }
    }

    public static void updateFluidRenderState(ItemDrainBlockEntity be, ItemDrainRenderState state, float tickProgress) {
        SmartFluidTankBehaviour tank = be.internalTank;
        if (tank == null) {
            return;
        }
        TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        if (!fluidStack.isEmpty()) {
            float level = primaryTank.getFluidLevel().getValue(tickProgress);
            if (level != 0) {
                float yMax = 5f / 16f;
                float min = 2f / 16f;
                float max = min + (12 / 16f);
                float yOffset = (7 / 16f) * level;
                float yMin = yMax - yOffset;
                state.fluid = new FluidRenderState(
                    class_12249.method_75977(),
                    fluidStack.getFluid(),
                    fluidStack.getComponentChanges(),
                    min,
                    max,
                    yMin,
                    yMax,
                    yOffset,
                    state.field_62676
                );
            }
        }
        class_1799 heldItemStack = be.getHeldItemStack();
        if (heldItemStack.method_7960()) {
            return;
        }
        int processingTicks = be.processingTicks;
        if (processingTicks == -1) {
            return;
        }
        FluidStack fluidStack2 = GenericItemEmptying.emptyItem(be.method_10997(), heldItemStack, true).getFirst();
        if (fluidStack2.isEmpty()) {
            if (fluidStack.isEmpty()) {
                return;
            }
            fluidStack2 = fluidStack;
        }
        float processingPT = processingTicks - tickProgress;
        float processingProgress = 1 - (processingPT - 5) / 10;
        processingProgress = class_3532.method_15363(processingProgress, 0, 1);
        float radius = (float) (Math.pow(((2 * processingProgress) - 1), 2) - 1);
        class_238 box = new class_238(0.5, 1.0, 0.5, 0.5, 0.25, 0.5).method_1014(radius / 32f);
        state.process = new ProcessRenderState(
            class_12249.method_75977(),
            fluidStack2.getFluid(),
            fluidStack2.getComponentChanges(),
            box,
            state.field_62676
        );
    }

    public static void updateItemRenderState(
        ItemDrainBlockEntity be,
        ItemDrainRenderState state,
        class_10442 itemModelManager,
        float tickProgress
    ) {
        TransportedItemStack transported = be.heldItem;
        if (transported == null) {
            return;
        }
        class_2350 insertedFrom = transported.insertedFrom;
        if (!insertedFrom.method_10166().method_10179()) {
            return;
        }
        HeldItemRenderState item = state.item = new HeldItemRenderState();
        item.itemPosition = VecHelper.getCenterOf(state.field_62673);
        float offset = class_3532.method_16439(tickProgress, transported.prevBeltPosition, transported.beltPosition);
        float sideOffset = class_3532.method_16439(tickProgress, transported.prevSideOffset, transported.sideOffset);
        item.offsetVec = class_243.method_24954(insertedFrom.method_10153().method_62675()).method_1021(.5f - offset);
        boolean alongX = insertedFrom.method_10170().method_10166() == class_2351.field_11048;
        if (!alongX)
            sideOffset *= -1;
        item.translate = item.offsetVec.method_1031(alongX ? sideOffset : 0, 0, alongX ? 0 : sideOffset);
        class_1799 itemStack = transported.stack;
        item.count = class_3532.method_15351(itemStack.method_7947()) / 2;
        item.upright = BeltHelper.isItemUpright(itemStack);
        int positive = insertedFrom.method_10171().method_10181();
        item.axis = insertedFrom.method_10166();
        item.verticalAngle = positive * offset * 360;
        class_10444 renderState = state.item.state = new class_10444();
        renderState.field_55337 = class_811.field_4319;
        itemModelManager.method_65596(renderState, itemStack, renderState.field_55337, be.method_10997(), null, 0);
    }

    public static class ItemDrainRenderState extends class_11954 {
        public FluidRenderState fluid;
        public ProcessRenderState process;
        public HeldItemRenderState item;
    }

    public record FluidRenderState(
        class_1921 layer, class_3611 fluid, class_9326 changes, float min, float max, float yMin, float yMax, float offset, int light
    ) implements class_11659.class_11660 {
        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            FluidRenderHelper.renderFluidBox(fluid, changes, min, yMin, min, max, yMax, max, vertexConsumer, matricesEntry, light, false, false);
        }
    }

    public record ProcessRenderState(
        class_1921 layer, class_3611 fluid, class_9326 changes, class_238 box, int light
    ) implements class_11659.class_11660 {
        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            FluidRenderHelper.renderFluidBox(
                fluid,
                changes,
                (float) box.field_1323,
                (float) box.field_1322,
                (float) box.field_1321,
                (float) box.field_1320,
                (float) box.field_1325,
                (float) box.field_1324,
                vertexConsumer,
                matricesEntry,
                light,
                true,
                false
            );
        }
    }

    public static class HeldItemRenderState {
        public class_10444 state;
        public class_243 itemPosition;
        public class_243 translate;
        public class_243 offsetVec;
        public int count;
        public boolean upright;
        public class_2351 axis;
        public float verticalAngle;

        public void render(class_4587 matrices, class_11659 queue, class_243 positionVec, int light) {
            var msr = TransformStack.of(matrices);
            matrices.method_22903();
            matrices.method_46416(.5f, 15 / 16f, .5f);
            msr.nudge(0);
            matrices.method_61958(translate);
            boolean renderUpright = upright;
            if (renderUpright) {
                matrices.method_22904(0, 3 / 32d, 0);
            }
            if (axis != class_2351.field_11048) {
                msr.rotateXDegrees(verticalAngle);
            }
            if (axis != class_2351.field_11051) {
                msr.rotateZDegrees(-verticalAngle);
            }
            if (renderUpright) {
                class_243 vectorForOffset = itemPosition.method_1019(offsetVec);
                class_243 diff = vectorForOffset.method_1020(positionVec);
                if (axis != class_2351.field_11048) {
                    diff = VecHelper.rotate(diff, verticalAngle, class_2351.field_11048);
                }
                if (axis != class_2351.field_11051) {
                    diff = VecHelper.rotate(diff, -verticalAngle, class_2351.field_11051);
                }
                float yRot = (float) class_3532.method_15349(diff.field_1350, -diff.field_1352);
                matrices.method_22907(net.minecraft.class_7833.field_40716.rotation((float) (yRot - Math.PI / 2)));
                matrices.method_46416(0, 0, -1 / 16f);
            }
            Random r = new Random(0);
            boolean blockItem = state.method_65608();
            for (int i = 0; i < count; i++) {
                matrices.method_22903();
                if (blockItem) {
                    matrices.method_46416(r.nextFloat() * .0625f * i, 0, r.nextFloat() * .0625f * i);
                }
                matrices.method_22905(.5f, .5f, .5f);
                if (!blockItem && !renderUpright) {
                    msr.rotateXDegrees(90);
                }
                state.method_65604(matrices, queue, light, class_4608.field_21444, 0);
                matrices.method_22909();
                if (!renderUpright) {
                    if (!blockItem) {
                        msr.rotateYDegrees(10);
                    }
                    matrices.method_22904(0, blockItem ? 1 / 64d : 1 / 16d, 0);
                } else {
                    matrices.method_46416(0, 0, -1 / 16f);
                }
            }
            matrices.method_22903();
            if (blockItem) {
                matrices.method_46416(r.nextFloat() * .0625f * count, 0, r.nextFloat() * .0625f * count);
            }
            matrices.method_22905(.5f, .5f, .5f);
            if (!blockItem && !renderUpright) {
                msr.rotateXDegrees(90);
            }
            state.method_65604(matrices, queue, light, class_4608.field_21444, 0);
            matrices.method_22909();
            matrices.method_22909();
        }
    }
}
