package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.foundation.render.CreateRenderTypes;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity.ConnectionStats;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.logistics.box.PackageItem;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_7923;

public class ChainConveyorRenderer extends KineticBlockEntityRenderer<ChainConveyorBlockEntity, ChainConveyorRenderer.ChainConveyorRenderState> {
    public static final class_2960 CHAIN_LOCATION = class_2960.method_60656("textures/block/iron_chain.png");
    public static final int MIP_DISTANCE = 48;

    public ChainConveyorRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public ChainConveyorRenderState createRenderState() {
        return new ChainConveyorRenderState();
    }

    @Override
    public void extractRenderState(
        ChainConveyorBlockEntity be,
        ChainConveyorRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        class_1937 world = be.method_10997();
        if (state.support) {
            class_2338 pos = be.method_11016();
            state.chains = getChainsRenderState(be, world, pos, cameraPos);
            if (state.chains == null) {
                return;
            }
            state.blockPos = pos;
            state.blockEntityType = be.method_11017();
            state.chain = CreateRenderTypes.chain(CHAIN_LOCATION);
            return;
        }
        state.chains = getChainsRenderState(be, world, state.blockPos, cameraPos);
        state.wheel = CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_WHEEL, state.blockState);
        if (state.chains != null) {
            state.chain = CreateRenderTypes.chain(CHAIN_LOCATION);
            state.guard = CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_GUARD, state.blockState);
        }
        List<BoxRenderState> boxes = new ArrayList<>();
        for (ChainConveyorPackage box : be.getLoopingPackages()) {
            ChainConveyorPackagePhysicsData data = getPhysicsData(world, box);
            if (data != null) {
                boxes.add(getBoxRenderState(world, state.blockState, state.blockPos, box, data, tickProgress));
            }
        }
        for (Map.Entry<class_2338, List<ChainConveyorPackage>> entry : be.getTravellingPackages().entrySet()) {
            for (ChainConveyorPackage box : entry.getValue()) {
                ChainConveyorPackagePhysicsData data = getPhysicsData(world, box);
                if (data != null) {
                    boxes.add(getBoxRenderState(world, state.blockState, state.blockPos, box, data, tickProgress));
                }
            }
        }
        if (boxes.isEmpty()) {
            return;
        }
        state.boxes = boxes;
    }

    @Override
    public void submit(ChainConveyorRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.chains != null) {
            for (ChainRenderState chain : state.chains) {
                chain.render(matrices, state.chain, queue);
            }
        }
    }

    public ChainConveyorPackagePhysicsData getPhysicsData(class_1937 world, ChainConveyorPackage box) {
        if (box.worldPosition == null || box.item == null || box.item.method_7960()) {
            return null;
        }
        ChainConveyorPackagePhysicsData physicsData = ChainConveyorClientBehaviour.physicsData(box, world);
        if (physicsData.prevPos == null) {
            return null;
        }
        if (physicsData.modelKey == null) {
            class_2960 key = class_7923.field_41178.method_10221(box.item.method_7909());
            if (key == class_7923.field_41178.method_10137()) {
                return null;
            }
            physicsData.modelKey = key;
        }
        return physicsData;
    }

    public BoxRenderState getBoxRenderState(
        class_1937 world,
        class_2680 blockState,
        class_2338 pos,
        ChainConveyorPackage box,
        ChainConveyorPackagePhysicsData physicsData,
        float partialTicks
    ) {
        BoxRenderState state = new BoxRenderState();
        class_243 position = physicsData.prevPos.method_35590(physicsData.pos, partialTicks);
        class_243 targetPosition = physicsData.prevTargetPos.method_35590(physicsData.targetPos, partialTicks);
        float yaw = AngleHelper.angleLerp(partialTicks, physicsData.prevYaw, physicsData.yaw);
        state.yaw = class_3532.field_29847 * yaw;
        state.offset = new class_243(targetPosition.field_1352 - pos.method_10263(), targetPosition.field_1351 - pos.method_10264(), targetPosition.field_1350 - pos.method_10260());
        class_2338 containingPos = class_2338.method_49638(position);
        state.light = class_765.method_23687(world.method_8314(class_1944.field_9282, containingPos), world.method_8314(class_1944.field_9284, containingPos));
        class_243 dangleDiff = VecHelper.rotate(targetPosition.method_1031(0, 0.5, 0).method_1020(position), -yaw, class_2351.field_11052);
        float zRot = class_3532.method_15393((float) class_3532.method_15349(-dangleDiff.field_1352, dangleDiff.field_1351) * class_3532.field_29848) / 2;
        float xRot = class_3532.method_15393((float) class_3532.method_15349(dangleDiff.field_1350, dangleDiff.field_1351) * class_3532.field_29848) / 2;
        state.zRot = class_3532.field_29847 * class_3532.method_15363(zRot, -25, 25);
        state.xRot = class_3532.field_29847 * class_3532.method_15363(xRot, -25, 25);
        if (physicsData.flipped) {
            state.yRot = class_3532.field_29847 * 180;
        }
        state.offsetY = -PackageItem.getHookDistance(box.item) + 7 / 16f;
        state.rig = CachedBuffers.partial(AllPartialModels.PACKAGE_RIGGING.get(physicsData.modelKey), blockState);
        state.box = CachedBuffers.partial(AllPartialModels.PACKAGES.get(physicsData.modelKey), blockState);
        return state;
    }

    @Nullable
    public List<ChainRenderState> getChainsRenderState(ChainConveyorBlockEntity be, class_1937 world, class_2338 tilePos, class_243 cameraPos) {
        List<ChainRenderState> chains = new ArrayList<>();
        class_243 position = class_243.method_24953(tilePos);
        boolean renderWorld = class_310.method_1551().field_1687 == world;
        float time = AnimationTickHolder.getRenderTime(world) / (360f / Math.abs(be.getSpeed()));
        time %= 1;
        if (time < 0) {
            time += 1;
        }
        float animation = time - 0.5f;
        int light1 = class_765.method_23687(world.method_8314(class_1944.field_9282, tilePos), world.method_8314(class_1944.field_9284, tilePos));
        float yRot = class_3532.field_29847 * 45;
        for (class_2338 blockPos : be.connections) {
            ConnectionStats stats = be.connectionStats.get(blockPos);
            if (stats == null) {
                continue;
            }
            boolean far = renderWorld && !cameraPos.method_24802(
                class_243.method_24953(tilePos)
                    .method_1031(blockPos.method_10263() / 2f, blockPos.method_10264() / 2f, blockPos.method_10260() / 2f), MIP_DISTANCE
            );
            ChainRenderState state = far ? new FarChainRenderState() : new ChainRenderState();
            class_243 diff = stats.end().method_1020(stats.start());
            state.startOffset = stats.start().method_1020(position);
            state.yaw = (float) class_3532.method_15349(diff.field_1352, diff.field_1350);
            state.pitch = (float) (class_3532.field_29847 * (90 - class_3532.field_29848 * class_3532.method_15349(diff.field_1351, diff.method_18805(1, 0, 1).method_1033())));
            state.yRot = yRot;
            class_2338 pos = tilePos.method_10081(blockPos);
            state.light1 = light1;
            state.light2 = class_765.method_23687(world.method_8314(class_1944.field_9282, pos), world.method_8314(class_1944.field_9284, pos));
            state.animation = animation;
            state.length = stats.chainLength();
            state.maxV = far ? 0.0625f : state.length + animation;
            chains.add(state);
        }
        if (chains.isEmpty()) {
            return null;
        }
        return chains;
    }

    private static void renderPart(
        class_4587.class_4665 pose,
        class_4588 pConsumer,
        float pMaxY,
        float pX0,
        float pZ0,
        float pX1,
        float pZ1,
        float pX2,
        float pZ2,
        float pX3,
        float pZ3,
        float pMinU,
        float pMaxU,
        float pMinV,
        float pMaxV,
        int light1,
        int light2,
        float uO
    ) {
        Matrix4f matrix4f = pose.method_23761();
        renderQuad(matrix4f, pose, pConsumer, 0, pMaxY, pX0, pZ0, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        renderQuad(matrix4f, pose, pConsumer, 0, pMaxY, pX3, pZ3, pX0, pZ0, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        renderQuad(matrix4f, pose, pConsumer, 0, pMaxY, pX1, pZ1, pX2, pZ2, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
        renderQuad(matrix4f, pose, pConsumer, 0, pMaxY, pX2, pZ2, pX1, pZ1, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
    }

    private static void renderQuad(
        Matrix4f pPose,
        class_4587.class_4665 pNormal,
        class_4588 pConsumer,
        float pMinY,
        float pMaxY,
        float pMinX,
        float pMinZ,
        float pMaxX,
        float pMaxZ,
        float pMinU,
        float pMaxU,
        float pMinV,
        float pMaxV,
        int light1,
        int light2
    ) {
        addVertex(pPose, pNormal, pConsumer, pMaxY, pMinX, pMinZ, pMaxU, pMinV, light2);
        addVertex(pPose, pNormal, pConsumer, pMinY, pMinX, pMinZ, pMaxU, pMaxV, light1);
        addVertex(pPose, pNormal, pConsumer, pMinY, pMaxX, pMaxZ, pMinU, pMaxV, light1);
        addVertex(pPose, pNormal, pConsumer, pMaxY, pMaxX, pMaxZ, pMinU, pMinV, light2);
    }

    private static void addVertex(
        Matrix4f pPose,
        class_4587.class_4665 pNormal,
        class_4588 pConsumer,
        float pY,
        float pX,
        float pZ,
        float pU,
        float pV,
        int light
    ) {
        pConsumer.method_22918(pPose, pX, pY, pZ).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(pU, pV).method_22922(class_4608.field_21444).method_60803(light)
            .method_60831(pNormal, 0.0F, 1.0F, 0.0F);
    }

    @Override
    public int method_33893() {
        return 256;
    }

    @Override
    public boolean method_3563() {
        return true;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(ChainConveyorBlockEntity be, ChainConveyorRenderState state) {
        return CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_SHAFT, state.blockState);
    }

    @Override
    protected class_1921 getRenderType(ChainConveyorBlockEntity be, class_2680 state) {
        return class_12249.method_75972();
    }

    public static class ChainConveyorRenderState extends KineticRenderState {
        public SuperByteBuffer wheel;
        public SuperByteBuffer guard;
        public class_1921 chain;
        public List<ChainRenderState> chains;
        public List<BoxRenderState> boxes;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            wheel.light(lightCoords).overlay(class_4608.field_21444).renderInto(matricesEntry, vertexConsumer);
            if (guard != null) {
                for (ChainRenderState chain : chains) {
                    guard.center().rotateY(chain.yaw).uncenter().light(lightCoords).overlay(class_4608.field_21444)
                        .renderInto(matricesEntry, vertexConsumer);
                }
            }
            if (boxes != null) {
                for (BoxRenderState box : boxes) {
                    box.render(matricesEntry, vertexConsumer);
                }
            }
        }
    }

    public static class ChainRenderState implements class_11659.class_11660 {
        public class_243 startOffset;
        public float yaw;
        public float pitch;
        public float yRot;
        public float animation;
        public float length;
        public int light1;
        public int light2;
        public float maxV;

        public void render(class_4587 matrices, class_1921 layer, class_11659 queue) {
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_61958(startOffset);
            matrices.method_22907(net.minecraft.class_7833.field_40716.rotation(yaw));
            matrices.method_22907(net.minecraft.class_7833.field_40714.rotation(pitch));
            matrices.method_22907(net.minecraft.class_7833.field_40716.rotation(yRot));
            queue.method_73483(matrices, layer, this);
            matrices.method_22909();
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            renderPart(
                matricesEntry,
                vertexConsumer,
                length,
                0,
                0.09375f,
                0.09375f,
                0,
                -0.09375f,
                0,
                0,
                -0.09375f,
                0,
                0.1875f,
                animation,
                maxV,
                light1,
                light2,
                0.1875f
            );
        }
    }

    public static class FarChainRenderState extends ChainRenderState {
        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            renderPart(
                matricesEntry,
                vertexConsumer,
                length,
                0,
                0.0625f,
                0.0625f,
                0,
                -0.0625f,
                0,
                0,
                -0.0625f,
                0.1875f,
                0.25f,
                0,
                maxV,
                light1,
                light2,
                0
            );
        }
    }

    public static class BoxRenderState {
        public SuperByteBuffer rig;
        public SuperByteBuffer box;
        public float yaw;
        public class_243 offset;
        public float zRot;
        public float xRot;
        public float yRot;
        public float offsetY;
        public int light;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            rig.translate(offset).translate(0, 0.625f, 0).rotateY(yaw).rotateZ(zRot).rotateX(xRot).rotateY(yRot).uncenter();
            rig.translate(0, offsetY, 0).light(light).overlay(class_4608.field_21444).renderInto(matricesEntry, vertexConsumer);
            box.translate(offset).translate(0, 0.625f, 0).rotateY(yaw).rotateZ(zRot).rotateX(xRot).uncenter();
            box.translate(0, offsetY, 0).light(light).overlay(class_4608.field_21444).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
