package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.SingleAxisRotatingVisual;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleTickableVisual;
import com.zurrtum.create.client.flywheel.lib.visual.util.SmartRecycler;
import com.zurrtum.create.client.foundation.render.SpecialModels;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.logistics.box.PackageItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_765;
import net.minecraft.class_7923;

public class ChainConveyorVisual extends SingleAxisRotatingVisual<ChainConveyorBlockEntity> implements SimpleDynamicVisual, SimpleTickableVisual {

    private final List<TransformedInstance> guards = new ArrayList<>();

    private final SmartRecycler<class_2960, TransformedInstance> boxes;
    private final SmartRecycler<class_2960, TransformedInstance> rigging;

    public ChainConveyorVisual(VisualizationContext context, ChainConveyorBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick, Models.partial(AllPartialModels.CHAIN_CONVEYOR_SHAFT));

        setupGuards();

        boxes = new SmartRecycler<>(key -> instancerProvider().instancer(
            InstanceTypes.TRANSFORMED,
            Models.partial(AllPartialModels.PACKAGES.get(key))
        ).createInstance());
        rigging = new SmartRecycler<>(key -> instancerProvider().instancer(
            InstanceTypes.TRANSFORMED,
            Models.partial(AllPartialModels.PACKAGE_RIGGING.get(key))
        ).createInstance());
    }

    @Override
    public void update(float pt) {
        super.update(pt);

        setupGuards();
    }

    @Override
    public void tick(TickableVisual.Context context) {
        blockEntity.getBehaviour(ChainConveyorClientBehaviour.TYPE).tickBoxVisuals();
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        var partialTicks = ctx.partialTick();

        boxes.resetCount();
        rigging.resetCount();

        for (ChainConveyorPackage box : blockEntity.getLoopingPackages())
            setupBoxVisual(blockEntity, box, partialTicks);

        for (Map.Entry<class_2338, List<ChainConveyorPackage>> entry : blockEntity.getTravellingPackages().entrySet())
            for (ChainConveyorPackage box : entry.getValue())
                setupBoxVisual(blockEntity, box, partialTicks);

        boxes.discardExtra();
        rigging.discardExtra();
    }


    private void setupBoxVisual(ChainConveyorBlockEntity be, ChainConveyorPackage box, float partialTicks) {
        if (box.worldPosition == null)
            return;
        if (box.item == null || box.item.method_7960())
            return;

        ChainConveyorPackagePhysicsData physicsData = ChainConveyorClientBehaviour.physicsData(box, be.method_10997());
        if (physicsData.prevPos == null)
            return;

        class_243 position = physicsData.prevPos.method_35590(physicsData.pos, partialTicks);
        class_243 targetPosition = physicsData.prevTargetPos.method_35590(physicsData.targetPos, partialTicks);
        float yaw = AngleHelper.angleLerp(partialTicks, physicsData.prevYaw, physicsData.yaw);
        class_243 offset = new class_243(targetPosition.field_1352 - this.pos.method_10263(), targetPosition.field_1351 - this.pos.method_10264(), targetPosition.field_1350 - this.pos.method_10260());

        class_2338 containingPos = class_2338.method_49638(position);
        class_1937 level = be.method_10997();
        int light = class_765.method_23687(level.method_8314(class_1944.field_9282, containingPos), level.method_8314(class_1944.field_9284, containingPos));

        if (physicsData.modelKey == null) {
            class_2960 key = class_7923.field_41178.method_10221(box.item.method_7909());
            if (key == class_7923.field_41178.method_10137())
                return;
            physicsData.modelKey = key;
        }

        TransformedInstance rigBuffer = rigging.get(physicsData.modelKey);
        TransformedInstance boxBuffer = boxes.get(physicsData.modelKey);

        class_243 dangleDiff = VecHelper.rotate(targetPosition.method_1031(0, 0.5, 0).method_1020(position), -yaw, class_2350.class_2351.field_11052);
        float zRot = class_3532.method_15393((float) class_3532.method_15349(-dangleDiff.field_1352, dangleDiff.field_1351) * class_3532.field_29848) / 2;
        float xRot = class_3532.method_15393((float) class_3532.method_15349(dangleDiff.field_1350, dangleDiff.field_1351) * class_3532.field_29848) / 2;
        zRot = class_3532.method_15363(zRot, -25, 25);
        xRot = class_3532.method_15363(xRot, -25, 25);

        for (TransformedInstance buf : new TransformedInstance[]{rigBuffer, boxBuffer}) {
            buf.setIdentityTransform();
            buf.translate(getVisualPosition());
            buf.translate(offset);
            buf.translate(0, 10 / 16f, 0);
            buf.rotateYDegrees(yaw);

            buf.rotateZDegrees(zRot);
            buf.rotateXDegrees(xRot);

            if (physicsData.flipped && buf == rigBuffer)
                buf.rotateYDegrees(180);

            buf.uncenter();
            buf.translate(0, -PackageItem.getHookDistance(box.item) + 7 / 16f, 0);

            buf.light(light);

            buf.setChanged();
        }
    }

    private void deleteGuards() {
        for (TransformedInstance guard : guards) {
            guard.delete();
        }
        guards.clear();
    }

    private void setupGuards() {
        deleteGuards();

        var wheelInstancer = instancerProvider().instancer(
            InstanceTypes.TRANSFORMED,
            SpecialModels.chunkDiffuse(AllPartialModels.CHAIN_CONVEYOR_WHEEL)
        );
        var guardInstancer = instancerProvider().instancer(
            InstanceTypes.TRANSFORMED,
            SpecialModels.chunkDiffuse(AllPartialModels.CHAIN_CONVEYOR_GUARD)
        );

        TransformedInstance wheel = wheelInstancer.createInstance();

        wheel.translate(getVisualPosition()).light(rotatingModel.light).setChanged();

        guards.add(wheel);

        for (class_2338 blockPos : blockEntity.connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = blockEntity.connectionStats.get(blockPos);
            if (stats == null) {
                continue;
            }

            class_243 diff = stats.end().method_1020(stats.start());
            double yaw = class_3532.field_29848 * class_3532.method_15349(diff.field_1352, diff.field_1350);

            TransformedInstance guard = guardInstancer.createInstance();
            guard.translate(getVisualPosition()).center().rotateYDegrees((float) yaw).uncenter().light(rotatingModel.light).setChanged();

            guards.add(guard);
        }
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        for (TransformedInstance guard : guards) {
            relight(guard);
        }
    }

    @Override
    protected void _delete() {
        super._delete();
        deleteGuards();
        boxes.delete();
        rigging.delete();
    }
}
