package com.zurrtum.create.client.content.kinetics.clock;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.animation.AnimationBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.animation.CuckooClockAnimationBehaviour;
import com.zurrtum.create.content.kinetics.clock.CuckooClockBlock;
import com.zurrtum.create.content.kinetics.clock.CuckooClockBlockEntity;
import com.zurrtum.create.content.kinetics.clock.CuckooClockBlockEntity.Animation;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;

public class CuckooClockRenderer extends KineticBlockEntityRenderer<CuckooClockBlockEntity, CuckooClockRenderer.CuckooClockRenderState> {
    public CuckooClockRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public CuckooClockRenderState createRenderState() {
        return new CuckooClockRenderState();
    }

    @Override
    public void extractRenderState(
        CuckooClockBlockEntity be,
        CuckooClockRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            state.blockPos = be.method_11016();
            state.blockState = be.method_11010();
            state.blockEntityType = be.method_11017();
            class_1937 world = be.method_10997();
            state.lightCoords = world != null ? class_761.method_23794(world, state.blockPos) : class_765.field_32767;
            state.layer = class_12249.method_75965();
            state.facing = state.blockState.getValue(CuckooClockBlock.HORIZONTAL_FACING);
        }
        state.hourHand = CachedBuffers.partial(AllPartialModels.CUCKOO_HOUR_HAND, state.blockState);
        state.minuteHand = CachedBuffers.partial(AllPartialModels.CUCKOO_MINUTE_HAND, state.blockState);
        CuckooClockAnimationBehaviour behaviour = (CuckooClockAnimationBehaviour) be.getBehaviour(AnimationBehaviour.TYPE);
        state.angle = AngleHelper.rad(AngleHelper.horizontalAngle(state.facing.method_10160()));
        state.hourAngle = AngleHelper.rad(behaviour.hourHand.getValue(tickProgress));
        state.minuteAngle = AngleHelper.rad(behaviour.minuteHand.getValue(tickProgress));
        state.leftDoor = CachedBuffers.partial(AllPartialModels.CUCKOO_LEFT_DOOR, state.blockState);
        state.rightDoor = CachedBuffers.partial(AllPartialModels.CUCKOO_RIGHT_DOOR, state.blockState);
        float angle = 0;
        if (be.animationType != null) {
            float value = be.animationProgress.getValue(tickProgress);
            int step = be.animationType == Animation.SURPRISE ? 3 : 15;
            for (int phase = 30; phase <= 60; phase += step) {
                float local = value - phase;
                if (local < -step / 3)
                    continue;
                else if (local < 0)
                    angle = class_3532.method_48781(((value - (phase - 5)) / 5), 0, 135);
                else if (local < step / 3)
                    angle = 135;
                else if (local < 2 * step / 3)
                    angle = class_3532.method_48781(((value - (phase + 5)) / 5), 135, 0);
            }
        }
        state.doorAngle = AngleHelper.rad(angle);
        if (be.animationType != Animation.NONE) {
            PartialModel partialModel = (be.animationType == Animation.PIG ? AllPartialModels.CUCKOO_PIG : AllPartialModels.CUCKOO_CREEPER);
            state.figure = CachedBuffers.partial(partialModel, state.blockState);
            state.offset = -(angle / 135) * 1 / 2f + 10 / 16f;
        }
    }

    @Override
    public void updateBaseRenderState(
        CuckooClockBlockEntity be,
        CuckooClockRenderState state,
        class_1937 world,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateBaseRenderState(be, state, world, crumblingOverlay);
        state.facing = state.blockState.getValue(CuckooClockBlock.HORIZONTAL_FACING);
    }

    @Override
    public void submit(CuckooClockRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
    }

    @Override
    protected class_1921 getRenderType(CuckooClockBlockEntity be, class_2680 state) {
        return class_12249.method_75965();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(CuckooClockBlockEntity be, CuckooClockRenderState state) {
        return CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.blockState, state.facing.method_10153());
    }

    public static class CuckooClockRenderState extends KineticRenderState {
        public class_2350 facing;
        public SuperByteBuffer hourHand;
        public SuperByteBuffer minuteHand;
        public float angle;
        public float hourAngle;
        public float minuteAngle;
        public SuperByteBuffer leftDoor;
        public SuperByteBuffer rightDoor;
        public float doorAngle;
        public SuperByteBuffer figure;
        public float offset;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (model != null) {
                super.render(matricesEntry, vertexConsumer);
            }
            hourHand.rotateCentered(angle, class_2350.field_11036).translate(0.125f, 0.375f, 0.5f).rotate(hourAngle, class_2350.field_11034)
                .translate(-0.125f, -0.375f, -0.5f).light(lightCoords).renderInto(matricesEntry, vertexConsumer);
            minuteHand.rotateCentered(angle, class_2350.field_11036).translate(0.125f, 0.375f, 0.5f).rotate(minuteAngle, class_2350.field_11034)
                .translate(-0.125f, -0.375f, -0.5f).light(lightCoords).renderInto(matricesEntry, vertexConsumer);
            leftDoor.rotateCentered(angle, class_2350.field_11036).translate(0.125f, 0, 0.375f).rotate(-doorAngle, class_2350.field_11036).translate(-0.125f, 0, -0.375f)
                .light(lightCoords).renderInto(matricesEntry, vertexConsumer);
            rightDoor.rotateCentered(angle, class_2350.field_11036).translate(0.125f, 0, 0.625f).rotate(doorAngle, class_2350.field_11036).translate(-0.125f, 0, -0.625f)
                .light(lightCoords).renderInto(matricesEntry, vertexConsumer);
            if (figure != null) {
                figure.rotateCentered(angle, class_2350.field_11036).translate(offset, 0, 0).light(lightCoords).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}
